<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_GET_V001Request StructType
 * @subpackage Structs
 */
class S_GUEST_GET_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Guest_1
     */
    public $Guest;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GUEST_GET_V001Request
     * @uses S_GUEST_GET_V001Request::setAuthentication()
     * @uses S_GUEST_GET_V001Request::setGuest()
     * @uses S_GUEST_GET_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\Guest_1 $guest
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\Guest_1 $guest = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setGuest($guest)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GUEST_GET_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get Guest value
     * @return \StructType\Guest_1
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * Set Guest value
     * @param \StructType\Guest_1 $guest
     * @return \StructType\S_GUEST_GET_V001Request
     */
    public function setGuest(\StructType\Guest_1 $guest = null)
    {
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_GET_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
