<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_CRITERIA_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_GUEST_CRITERIA_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Guests
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guests[]
     */
    public $Guests;
    /**
     * Constructor method for S_GUEST_CRITERIA_SEARCH_V001Response
     * @uses S_GUEST_CRITERIA_SEARCH_V001Response::setResult()
     * @uses S_GUEST_CRITERIA_SEARCH_V001Response::setTransactionID()
     * @uses S_GUEST_CRITERIA_SEARCH_V001Response::setGuests()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Guests[] $guests
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $guests = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setGuests($guests);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GUEST_CRITERIA_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_CRITERIA_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Guests value
     * @return \StructType\Guests[]|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * This method is responsible for validating the values passed to the setGuests method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuests method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestsForArrayConstraintsFromSetGuests(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GUEST_CRITERIA_SEARCH_V001ResponseGuestsItem) {
            // validation for constraint: itemType
            if (!$s_GUEST_CRITERIA_SEARCH_V001ResponseGuestsItem instanceof \StructType\Guests) {
                $invalidValues[] = is_object($s_GUEST_CRITERIA_SEARCH_V001ResponseGuestsItem) ? get_class($s_GUEST_CRITERIA_SEARCH_V001ResponseGuestsItem) : sprintf('%s(%s)', gettype($s_GUEST_CRITERIA_SEARCH_V001ResponseGuestsItem), var_export($s_GUEST_CRITERIA_SEARCH_V001ResponseGuestsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guests property can only contain items of type \StructType\Guests, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guests value
     * @throws \InvalidArgumentException
     * @param \StructType\Guests[] $guests
     * @return \StructType\S_GUEST_CRITERIA_SEARCH_V001Response
     */
    public function setGuests(array $guests = array())
    {
        // validation for constraint: array
        if ('' !== ($guestsArrayErrorMessage = self::validateGuestsForArrayConstraintsFromSetGuests($guests))) {
            throw new \InvalidArgumentException($guestsArrayErrorMessage, __LINE__);
        }
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Add item to Guests value
     * @throws \InvalidArgumentException
     * @param \StructType\Guests $item
     * @return \StructType\S_GUEST_CRITERIA_SEARCH_V001Response
     */
    public function addToGuests(\StructType\Guests $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guests) {
            throw new \InvalidArgumentException(sprintf('The Guests property can only contain items of type \StructType\Guests, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guests[] = $item;
        return $this;
    }
}
