<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_CREATE_V005Response StructType
 * @subpackage Structs
 */
class S_GUEST_CREATE_V005Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The GUEST
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUEST[]
     */
    public $GUEST;
    /**
     * Constructor method for S_GUEST_CREATE_V005Response
     * @uses S_GUEST_CREATE_V005Response::setResult()
     * @uses S_GUEST_CREATE_V005Response::setTransactionID()
     * @uses S_GUEST_CREATE_V005Response::setGUEST()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\GUEST[] $gUEST
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $gUEST = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setGUEST($gUEST);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GUEST_CREATE_V005Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_CREATE_V005Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get GUEST value
     * @return \StructType\GUEST[]|null
     */
    public function getGUEST()
    {
        return $this->GUEST;
    }
    /**
     * This method is responsible for validating the values passed to the setGUEST method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUEST method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTForArrayConstraintsFromSetGUEST(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GUEST_CREATE_V005ResponseGUESTItem) {
            // validation for constraint: itemType
            if (!$s_GUEST_CREATE_V005ResponseGUESTItem instanceof \StructType\GUEST) {
                $invalidValues[] = is_object($s_GUEST_CREATE_V005ResponseGUESTItem) ? get_class($s_GUEST_CREATE_V005ResponseGUESTItem) : sprintf('%s(%s)', gettype($s_GUEST_CREATE_V005ResponseGUESTItem), var_export($s_GUEST_CREATE_V005ResponseGUESTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST[] $gUEST
     * @return \StructType\S_GUEST_CREATE_V005Response
     */
    public function setGUEST(array $gUEST = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTArrayErrorMessage = self::validateGUESTForArrayConstraintsFromSetGUEST($gUEST))) {
            throw new \InvalidArgumentException($gUESTArrayErrorMessage, __LINE__);
        }
        $this->GUEST = $gUEST;
        return $this;
    }
    /**
     * Add item to GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST $item
     * @return \StructType\S_GUEST_CREATE_V005Response
     */
    public function addToGUEST(\StructType\GUEST $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUEST) {
            throw new \InvalidArgumentException(sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUEST[] = $item;
        return $this;
    }
}
