<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GUEST_CONTACT_PERSON_ADD_V001Request StructType
 * @subpackage Structs
 */
class S_GUEST_CONTACT_PERSON_ADD_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The COMPANY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\COMPANY
     */
    public $COMPANY;
    /**
     * The CONTACT_PERSON
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CONTACT_PERSON
     */
    public $CONTACT_PERSON;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_GUEST_CONTACT_PERSON_ADD_V001Request
     * @uses S_GUEST_CONTACT_PERSON_ADD_V001Request::setAuthentication()
     * @uses S_GUEST_CONTACT_PERSON_ADD_V001Request::setCOMPANY()
     * @uses S_GUEST_CONTACT_PERSON_ADD_V001Request::setCONTACT_PERSON()
     * @uses S_GUEST_CONTACT_PERSON_ADD_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\COMPANY $cOMPANY
     * @param \StructType\CONTACT_PERSON $cONTACT_PERSON
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\COMPANY $cOMPANY = null, \StructType\CONTACT_PERSON $cONTACT_PERSON = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setCOMPANY($cOMPANY)
            ->setCONTACT_PERSON($cONTACT_PERSON)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_GUEST_CONTACT_PERSON_ADD_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get COMPANY value
     * @return \StructType\COMPANY
     */
    public function getCOMPANY()
    {
        return $this->COMPANY;
    }
    /**
     * Set COMPANY value
     * @param \StructType\COMPANY $cOMPANY
     * @return \StructType\S_GUEST_CONTACT_PERSON_ADD_V001Request
     */
    public function setCOMPANY(\StructType\COMPANY $cOMPANY = null)
    {
        $this->COMPANY = $cOMPANY;
        return $this;
    }
    /**
     * Get CONTACT_PERSON value
     * @return \StructType\CONTACT_PERSON
     */
    public function getCONTACT_PERSON()
    {
        return $this->{'CONTACT-PERSON'};
    }
    /**
     * Set CONTACT_PERSON value
     * @param \StructType\CONTACT_PERSON $cONTACT_PERSON
     * @return \StructType\S_GUEST_CONTACT_PERSON_ADD_V001Request
     */
    public function setCONTACT_PERSON(\StructType\CONTACT_PERSON $cONTACT_PERSON = null)
    {
        $this->CONTACT_PERSON = $this->{'CONTACT-PERSON'} = $cONTACT_PERSON;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GUEST_CONTACT_PERSON_ADD_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
