<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_GO_PERSON_SEARCH_V002Response StructType
 * @subpackage Structs
 */
class S_GO_PERSON_SEARCH_V002Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The GuestInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GuestInfo[]
     */
    public $GuestInfo;
    /**
     * Constructor method for S_GO_PERSON_SEARCH_V002Response
     * @uses S_GO_PERSON_SEARCH_V002Response::setResult()
     * @uses S_GO_PERSON_SEARCH_V002Response::setTransactionID()
     * @uses S_GO_PERSON_SEARCH_V002Response::setGuestInfo()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\GuestInfo[] $guestInfo
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $guestInfo = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setGuestInfo($guestInfo);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_GO_PERSON_SEARCH_V002Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_GO_PERSON_SEARCH_V002Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get GuestInfo value
     * @return \StructType\GuestInfo[]|null
     */
    public function getGuestInfo()
    {
        return $this->GuestInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestInfoForArrayConstraintsFromSetGuestInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_GO_PERSON_SEARCH_V002ResponseGuestInfoItem) {
            // validation for constraint: itemType
            if (!$s_GO_PERSON_SEARCH_V002ResponseGuestInfoItem instanceof \StructType\GuestInfo) {
                $invalidValues[] = is_object($s_GO_PERSON_SEARCH_V002ResponseGuestInfoItem) ? get_class($s_GO_PERSON_SEARCH_V002ResponseGuestInfoItem) : sprintf('%s(%s)', gettype($s_GO_PERSON_SEARCH_V002ResponseGuestInfoItem), var_export($s_GO_PERSON_SEARCH_V002ResponseGuestInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestInfo property can only contain items of type \StructType\GuestInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestInfo[] $guestInfo
     * @return \StructType\S_GO_PERSON_SEARCH_V002Response
     */
    public function setGuestInfo(array $guestInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($guestInfoArrayErrorMessage = self::validateGuestInfoForArrayConstraintsFromSetGuestInfo($guestInfo))) {
            throw new \InvalidArgumentException($guestInfoArrayErrorMessage, __LINE__);
        }
        $this->GuestInfo = $guestInfo;
        return $this;
    }
    /**
     * Add item to GuestInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestInfo $item
     * @return \StructType\S_GO_PERSON_SEARCH_V002Response
     */
    public function addToGuestInfo(\StructType\GuestInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestInfo) {
            throw new \InvalidArgumentException(sprintf('The GuestInfo property can only contain items of type \StructType\GuestInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GuestInfo[] = $item;
        return $this;
    }
}
