<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request StructType
 * @subpackage Structs
 */
class S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The EventServiceRes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\EventServiceRes
     */
    public $EventServiceRes;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request
     * @uses S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request::setAuthentication()
     * @uses S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request::setEventServiceRes()
     * @uses S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\EventServiceRes $eventServiceRes
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\EventServiceRes $eventServiceRes = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setEventServiceRes($eventServiceRes)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get EventServiceRes value
     * @return \StructType\EventServiceRes
     */
    public function getEventServiceRes()
    {
        return $this->EventServiceRes;
    }
    /**
     * Set EventServiceRes value
     * @param \StructType\EventServiceRes $eventServiceRes
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request
     */
    public function setEventServiceRes(\StructType\EventServiceRes $eventServiceRes = null)
    {
        $this->EventServiceRes = $eventServiceRes;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
