<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_EVENT_RESERVATION_SEARCH_V001Request StructType
 * @subpackage Structs
 */
class S_EVENT_RESERVATION_SEARCH_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The EVENT_RESERVATION_SEARCH
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\EVENT_RESERVATION_SEARCH
     */
    public $EVENT_RESERVATION_SEARCH;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_EVENT_RESERVATION_SEARCH_V001Request
     * @uses S_EVENT_RESERVATION_SEARCH_V001Request::setAuthentication()
     * @uses S_EVENT_RESERVATION_SEARCH_V001Request::setEVENT_RESERVATION_SEARCH()
     * @uses S_EVENT_RESERVATION_SEARCH_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\EVENT_RESERVATION_SEARCH $eVENT_RESERVATION_SEARCH
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\EVENT_RESERVATION_SEARCH $eVENT_RESERVATION_SEARCH = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setEVENT_RESERVATION_SEARCH($eVENT_RESERVATION_SEARCH)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_EVENT_RESERVATION_SEARCH_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get EVENT_RESERVATION_SEARCH value
     * @return \StructType\EVENT_RESERVATION_SEARCH
     */
    public function getEVENT_RESERVATION_SEARCH()
    {
        return $this->{'EVENT-RESERVATION-SEARCH'};
    }
    /**
     * Set EVENT_RESERVATION_SEARCH value
     * @param \StructType\EVENT_RESERVATION_SEARCH $eVENT_RESERVATION_SEARCH
     * @return \StructType\S_EVENT_RESERVATION_SEARCH_V001Request
     */
    public function setEVENT_RESERVATION_SEARCH(\StructType\EVENT_RESERVATION_SEARCH $eVENT_RESERVATION_SEARCH = null)
    {
        $this->EVENT_RESERVATION_SEARCH = $this->{'EVENT-RESERVATION-SEARCH'} = $eVENT_RESERVATION_SEARCH;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_EVENT_RESERVATION_SEARCH_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
