<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_AUTHENTICATE_V001Request StructType
 * @subpackage Structs
 */
class S_AUTHENTICATE_V001Request extends AbstractStructBase
{
    /**
     * The AuthenticationInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AuthenticationInfos
     */
    public $AuthenticationInfos;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_AUTHENTICATE_V001Request
     * @uses S_AUTHENTICATE_V001Request::setAuthenticationInfos()
     * @uses S_AUTHENTICATE_V001Request::setTransactionID()
     * @param \StructType\AuthenticationInfos $authenticationInfos
     * @param string $transactionID
     */
    public function __construct(\StructType\AuthenticationInfos $authenticationInfos = null, $transactionID = null)
    {
        $this
            ->setAuthenticationInfos($authenticationInfos)
            ->setTransactionID($transactionID);
    }
    /**
     * Get AuthenticationInfos value
     * @return \StructType\AuthenticationInfos
     */
    public function getAuthenticationInfos()
    {
        return $this->AuthenticationInfos;
    }
    /**
     * Set AuthenticationInfos value
     * @param \StructType\AuthenticationInfos $authenticationInfos
     * @return \StructType\S_AUTHENTICATE_V001Request
     */
    public function setAuthenticationInfos(\StructType\AuthenticationInfos $authenticationInfos = null)
    {
        $this->AuthenticationInfos = $authenticationInfos;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_AUTHENTICATE_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
