<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ALLOTMENT_SEARCH_V001Response StructType
 * @subpackage Structs
 */
class S_ALLOTMENT_SEARCH_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The ALLOTMENTS
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ALLOTMENTS[]
     */
    public $ALLOTMENTS;
    /**
     * Constructor method for S_ALLOTMENT_SEARCH_V001Response
     * @uses S_ALLOTMENT_SEARCH_V001Response::setResult()
     * @uses S_ALLOTMENT_SEARCH_V001Response::setTransactionID()
     * @uses S_ALLOTMENT_SEARCH_V001Response::setALLOTMENTS()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\ALLOTMENTS[] $aLLOTMENTS
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $aLLOTMENTS = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setALLOTMENTS($aLLOTMENTS);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ALLOTMENT_SEARCH_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ALLOTMENT_SEARCH_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ALLOTMENTS value
     * @return \StructType\ALLOTMENTS[]|null
     */
    public function getALLOTMENTS()
    {
        return $this->ALLOTMENTS;
    }
    /**
     * This method is responsible for validating the values passed to the setALLOTMENTS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setALLOTMENTS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateALLOTMENTSForArrayConstraintsFromSetALLOTMENTS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ALLOTMENT_SEARCH_V001ResponseALLOTMENTSItem) {
            // validation for constraint: itemType
            if (!$s_ALLOTMENT_SEARCH_V001ResponseALLOTMENTSItem instanceof \StructType\ALLOTMENTS) {
                $invalidValues[] = is_object($s_ALLOTMENT_SEARCH_V001ResponseALLOTMENTSItem) ? get_class($s_ALLOTMENT_SEARCH_V001ResponseALLOTMENTSItem) : sprintf('%s(%s)', gettype($s_ALLOTMENT_SEARCH_V001ResponseALLOTMENTSItem), var_export($s_ALLOTMENT_SEARCH_V001ResponseALLOTMENTSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ALLOTMENTS property can only contain items of type \StructType\ALLOTMENTS, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ALLOTMENTS value
     * @throws \InvalidArgumentException
     * @param \StructType\ALLOTMENTS[] $aLLOTMENTS
     * @return \StructType\S_ALLOTMENT_SEARCH_V001Response
     */
    public function setALLOTMENTS(array $aLLOTMENTS = array())
    {
        // validation for constraint: array
        if ('' !== ($aLLOTMENTSArrayErrorMessage = self::validateALLOTMENTSForArrayConstraintsFromSetALLOTMENTS($aLLOTMENTS))) {
            throw new \InvalidArgumentException($aLLOTMENTSArrayErrorMessage, __LINE__);
        }
        $this->ALLOTMENTS = $aLLOTMENTS;
        return $this;
    }
    /**
     * Add item to ALLOTMENTS value
     * @throws \InvalidArgumentException
     * @param \StructType\ALLOTMENTS $item
     * @return \StructType\S_ALLOTMENT_SEARCH_V001Response
     */
    public function addToALLOTMENTS(\StructType\ALLOTMENTS $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ALLOTMENTS) {
            throw new \InvalidArgumentException(sprintf('The ALLOTMENTS property can only contain items of type \StructType\ALLOTMENTS, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ALLOTMENTS[] = $item;
        return $this;
    }
}
