<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACTIVIY_GET_V001Response StructType
 * @subpackage Structs
 */
class S_ACTIVIY_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Activity[]
     */
    public $Activity;
    /**
     * Constructor method for S_ACTIVIY_GET_V001Response
     * @uses S_ACTIVIY_GET_V001Response::setResult()
     * @uses S_ACTIVIY_GET_V001Response::setTransactionID()
     * @uses S_ACTIVIY_GET_V001Response::setActivity()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Activity[] $activity
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $activity = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setActivity($activity);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ACTIVIY_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACTIVIY_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * This method is responsible for validating the values passed to the setActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityForArrayConstraintsFromSetActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ACTIVIY_GET_V001ResponseActivityItem) {
            // validation for constraint: itemType
            if (!$s_ACTIVIY_GET_V001ResponseActivityItem instanceof \StructType\Activity) {
                $invalidValues[] = is_object($s_ACTIVIY_GET_V001ResponseActivityItem) ? get_class($s_ACTIVIY_GET_V001ResponseActivityItem) : sprintf('%s(%s)', gettype($s_ACTIVIY_GET_V001ResponseActivityItem), var_export($s_ACTIVIY_GET_V001ResponseActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Activity property can only contain items of type \StructType\Activity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\Activity[] $activity
     * @return \StructType\S_ACTIVIY_GET_V001Response
     */
    public function setActivity(array $activity = array())
    {
        // validation for constraint: array
        if ('' !== ($activityArrayErrorMessage = self::validateActivityForArrayConstraintsFromSetActivity($activity))) {
            throw new \InvalidArgumentException($activityArrayErrorMessage, __LINE__);
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \StructType\Activity $item
     * @return \StructType\S_ACTIVIY_GET_V001Response
     */
    public function addToActivity(\StructType\Activity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Activity) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of type \StructType\Activity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
}
