<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACTIVITY_SEARCH_V002Request StructType
 * @subpackage Structs
 */
class S_ACTIVITY_SEARCH_V002Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The ActivitySearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ActivitySearch
     */
    public $ActivitySearch;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_ACTIVITY_SEARCH_V002Request
     * @uses S_ACTIVITY_SEARCH_V002Request::setAuthentication()
     * @uses S_ACTIVITY_SEARCH_V002Request::setActivitySearch()
     * @uses S_ACTIVITY_SEARCH_V002Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\ActivitySearch $activitySearch
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\ActivitySearch $activitySearch = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setActivitySearch($activitySearch)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ACTIVITY_SEARCH_V002Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get ActivitySearch value
     * @return \StructType\ActivitySearch
     */
    public function getActivitySearch()
    {
        return $this->ActivitySearch;
    }
    /**
     * Set ActivitySearch value
     * @param \StructType\ActivitySearch $activitySearch
     * @return \StructType\S_ACTIVITY_SEARCH_V002Request
     */
    public function setActivitySearch(\StructType\ActivitySearch $activitySearch = null)
    {
        $this->ActivitySearch = $activitySearch;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACTIVITY_SEARCH_V002Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
