<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACTIVITY_ADD_V001Request StructType
 * @subpackage Structs
 */
class S_ACTIVITY_ADD_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The TrailAdd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TrailAdd
     */
    public $TrailAdd;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * Constructor method for S_ACTIVITY_ADD_V001Request
     * @uses S_ACTIVITY_ADD_V001Request::setAuthentication()
     * @uses S_ACTIVITY_ADD_V001Request::setTrailAdd()
     * @uses S_ACTIVITY_ADD_V001Request::setTransactionID()
     * @uses S_ACTIVITY_ADD_V001Request::setActivity()
     * @param \StructType\Authentication $authentication
     * @param \StructType\TrailAdd $trailAdd
     * @param string $transactionID
     * @param \StructType\Activity $activity
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\TrailAdd $trailAdd = null, $transactionID = null, \StructType\Activity $activity = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setTrailAdd($trailAdd)
            ->setTransactionID($transactionID)
            ->setActivity($activity);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ACTIVITY_ADD_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get TrailAdd value
     * @return \StructType\TrailAdd
     */
    public function getTrailAdd()
    {
        return $this->TrailAdd;
    }
    /**
     * Set TrailAdd value
     * @param \StructType\TrailAdd $trailAdd
     * @return \StructType\S_ACTIVITY_ADD_V001Request
     */
    public function setTrailAdd(\StructType\TrailAdd $trailAdd = null)
    {
        $this->TrailAdd = $trailAdd;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACTIVITY_ADD_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\S_ACTIVITY_ADD_V001Request
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
}
