<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request StructType
 * @subpackage Structs
 */
class S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The ACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ACCOUNT
     */
    public $ACCOUNT;
    /**
     * The PAYMENT_INSTRUCTIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PAYMENT_INSTRUCTIONS
     */
    public $PAYMENT_INSTRUCTIONS;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request
     * @uses S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request::setAuthentication()
     * @uses S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request::setACCOUNT()
     * @uses S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request::setPAYMENT_INSTRUCTIONS()
     * @uses S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\ACCOUNT $aCCOUNT
     * @param \StructType\PAYMENT_INSTRUCTIONS $pAYMENT_INSTRUCTIONS
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\ACCOUNT $aCCOUNT = null, \StructType\PAYMENT_INSTRUCTIONS $pAYMENT_INSTRUCTIONS = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setACCOUNT($aCCOUNT)
            ->setPAYMENT_INSTRUCTIONS($pAYMENT_INSTRUCTIONS)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get ACCOUNT value
     * @return \StructType\ACCOUNT
     */
    public function getACCOUNT()
    {
        return $this->ACCOUNT;
    }
    /**
     * Set ACCOUNT value
     * @param \StructType\ACCOUNT $aCCOUNT
     * @return \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request
     */
    public function setACCOUNT(\StructType\ACCOUNT $aCCOUNT = null)
    {
        $this->ACCOUNT = $aCCOUNT;
        return $this;
    }
    /**
     * Get PAYMENT_INSTRUCTIONS value
     * @return \StructType\PAYMENT_INSTRUCTIONS
     */
    public function getPAYMENT_INSTRUCTIONS()
    {
        return $this->{'PAYMENT-INSTRUCTIONS'};
    }
    /**
     * Set PAYMENT_INSTRUCTIONS value
     * @param \StructType\PAYMENT_INSTRUCTIONS $pAYMENT_INSTRUCTIONS
     * @return \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request
     */
    public function setPAYMENT_INSTRUCTIONS(\StructType\PAYMENT_INSTRUCTIONS $pAYMENT_INSTRUCTIONS = null)
    {
        $this->PAYMENT_INSTRUCTIONS = $this->{'PAYMENT-INSTRUCTIONS'} = $pAYMENT_INSTRUCTIONS;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_SET_V001Request
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
