<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response StructType
 * @subpackage Structs
 */
class S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The PAYMENT_INSTRUCTIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PAYMENT_INSTRUCTIONS[]
     */
    public $PAYMENT_INSTRUCTIONS;
    /**
     * Constructor method for S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response
     * @uses S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response::setResult()
     * @uses S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response::setTransactionID()
     * @uses S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response::setPAYMENT_INSTRUCTIONS()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\PAYMENT_INSTRUCTIONS[] $pAYMENT_INSTRUCTIONS
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $pAYMENT_INSTRUCTIONS = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setPAYMENT_INSTRUCTIONS($pAYMENT_INSTRUCTIONS);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get PAYMENT_INSTRUCTIONS value
     * @return \StructType\PAYMENT_INSTRUCTIONS[]|null
     */
    public function getPAYMENT_INSTRUCTIONS()
    {
        return $this->{'PAYMENT-INSTRUCTIONS'};
    }
    /**
     * This method is responsible for validating the values passed to the setPAYMENT_INSTRUCTIONS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPAYMENT_INSTRUCTIONS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePAYMENT_INSTRUCTIONSForArrayConstraintsFromSetPAYMENT_INSTRUCTIONS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001ResponsePAYMENT_INSTRUCTIONSItem) {
            // validation for constraint: itemType
            if (!$s_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001ResponsePAYMENT_INSTRUCTIONSItem instanceof \StructType\PAYMENT_INSTRUCTIONS) {
                $invalidValues[] = is_object($s_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001ResponsePAYMENT_INSTRUCTIONSItem) ? get_class($s_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001ResponsePAYMENT_INSTRUCTIONSItem) : sprintf('%s(%s)', gettype($s_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001ResponsePAYMENT_INSTRUCTIONSItem), var_export($s_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001ResponsePAYMENT_INSTRUCTIONSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PAYMENT_INSTRUCTIONS property can only contain items of type \StructType\PAYMENT_INSTRUCTIONS, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PAYMENT_INSTRUCTIONS value
     * @throws \InvalidArgumentException
     * @param \StructType\PAYMENT_INSTRUCTIONS[] $pAYMENT_INSTRUCTIONS
     * @return \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response
     */
    public function setPAYMENT_INSTRUCTIONS(array $pAYMENT_INSTRUCTIONS = array())
    {
        // validation for constraint: array
        if ('' !== ($pAYMENT_INSTRUCTIONSArrayErrorMessage = self::validatePAYMENT_INSTRUCTIONSForArrayConstraintsFromSetPAYMENT_INSTRUCTIONS($pAYMENT_INSTRUCTIONS))) {
            throw new \InvalidArgumentException($pAYMENT_INSTRUCTIONSArrayErrorMessage, __LINE__);
        }
        $this->PAYMENT_INSTRUCTIONS = $this->{'PAYMENT-INSTRUCTIONS'} = $pAYMENT_INSTRUCTIONS;
        return $this;
    }
    /**
     * Add item to PAYMENT_INSTRUCTIONS value
     * @throws \InvalidArgumentException
     * @param \StructType\PAYMENT_INSTRUCTIONS $item
     * @return \StructType\S_ACCOUNT_PAYMENT_INSTRUCTIONS_GET_V001Response
     */
    public function addToPAYMENT_INSTRUCTIONS(\StructType\PAYMENT_INSTRUCTIONS $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PAYMENT_INSTRUCTIONS) {
            throw new \InvalidArgumentException(sprintf('The PAYMENT_INSTRUCTIONS property can only contain items of type \StructType\PAYMENT_INSTRUCTIONS, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PAYMENT_INSTRUCTIONS[] = $this->{'PAYMENT-INSTRUCTIONS'}[] = $item;
        return $this;
    }
}
