<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_ACCOUNT_PAYMENT_ADD_V001Response StructType
 * @subpackage Structs
 */
class S_ACCOUNT_PAYMENT_ADD_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Answer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Answer[]
     */
    public $Answer;
    /**
     * Constructor method for S_ACCOUNT_PAYMENT_ADD_V001Response
     * @uses S_ACCOUNT_PAYMENT_ADD_V001Response::setResult()
     * @uses S_ACCOUNT_PAYMENT_ADD_V001Response::setTransactionID()
     * @uses S_ACCOUNT_PAYMENT_ADD_V001Response::setAnswer()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\Answer[] $answer
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $answer = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setAnswer($answer);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_ACCOUNT_PAYMENT_ADD_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_ACCOUNT_PAYMENT_ADD_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Answer value
     * @return \StructType\Answer[]|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * This method is responsible for validating the values passed to the setAnswer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnswerForArrayConstraintsFromSetAnswer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_ACCOUNT_PAYMENT_ADD_V001ResponseAnswerItem) {
            // validation for constraint: itemType
            if (!$s_ACCOUNT_PAYMENT_ADD_V001ResponseAnswerItem instanceof \StructType\Answer) {
                $invalidValues[] = is_object($s_ACCOUNT_PAYMENT_ADD_V001ResponseAnswerItem) ? get_class($s_ACCOUNT_PAYMENT_ADD_V001ResponseAnswerItem) : sprintf('%s(%s)', gettype($s_ACCOUNT_PAYMENT_ADD_V001ResponseAnswerItem), var_export($s_ACCOUNT_PAYMENT_ADD_V001ResponseAnswerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Answer property can only contain items of type \StructType\Answer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Answer value
     * @throws \InvalidArgumentException
     * @param \StructType\Answer[] $answer
     * @return \StructType\S_ACCOUNT_PAYMENT_ADD_V001Response
     */
    public function setAnswer(array $answer = array())
    {
        // validation for constraint: array
        if ('' !== ($answerArrayErrorMessage = self::validateAnswerForArrayConstraintsFromSetAnswer($answer))) {
            throw new \InvalidArgumentException($answerArrayErrorMessage, __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Add item to Answer value
     * @throws \InvalidArgumentException
     * @param \StructType\Answer $item
     * @return \StructType\S_ACCOUNT_PAYMENT_ADD_V001Response
     */
    public function addToAnswer(\StructType\Answer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Answer) {
            throw new \InvalidArgumentException(sprintf('The Answer property can only contain items of type \StructType\Answer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Answer[] = $item;
        return $this;
    }
}
