<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SUMMARY StructType
 * @subpackage Structs
 */
class SUMMARY extends AbstractStructBase
{
    /**
     * The depositrequired
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $depositrequired;
    /**
     * The depositpayed
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $depositpayed;
    /**
     * The depositopen
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $depositopen;
    /**
     * The depositdue
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $depositdue;
    /**
     * The depositduedate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $depositduedate;
    /**
     * The depositpayeddate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $depositpayeddate;
    /**
     * Constructor method for SUMMARY
     * @uses SUMMARY::setDepositrequired()
     * @uses SUMMARY::setDepositpayed()
     * @uses SUMMARY::setDepositopen()
     * @uses SUMMARY::setDepositdue()
     * @uses SUMMARY::setDepositduedate()
     * @uses SUMMARY::setDepositpayeddate()
     * @param string $depositrequired
     * @param string $depositpayed
     * @param string $depositopen
     * @param string $depositdue
     * @param string $depositduedate
     * @param string $depositpayeddate
     */
    public function __construct($depositrequired = null, $depositpayed = null, $depositopen = null, $depositdue = null, $depositduedate = null, $depositpayeddate = null)
    {
        $this
            ->setDepositrequired($depositrequired)
            ->setDepositpayed($depositpayed)
            ->setDepositopen($depositopen)
            ->setDepositdue($depositdue)
            ->setDepositduedate($depositduedate)
            ->setDepositpayeddate($depositpayeddate);
    }
    /**
     * Get depositrequired value
     * @return string
     */
    public function getDepositrequired()
    {
        return $this->depositrequired;
    }
    /**
     * Set depositrequired value
     * @param string $depositrequired
     * @return \StructType\SUMMARY
     */
    public function setDepositrequired($depositrequired = null)
    {
        // validation for constraint: string
        if (!is_null($depositrequired) && !is_string($depositrequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositrequired, true), gettype($depositrequired)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($depositrequired) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $depositrequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($depositrequired, true)), __LINE__);
        }
        $this->depositrequired = $depositrequired;
        return $this;
    }
    /**
     * Get depositpayed value
     * @return string
     */
    public function getDepositpayed()
    {
        return $this->depositpayed;
    }
    /**
     * Set depositpayed value
     * @param string $depositpayed
     * @return \StructType\SUMMARY
     */
    public function setDepositpayed($depositpayed = null)
    {
        // validation for constraint: string
        if (!is_null($depositpayed) && !is_string($depositpayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositpayed, true), gettype($depositpayed)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($depositpayed) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $depositpayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($depositpayed, true)), __LINE__);
        }
        $this->depositpayed = $depositpayed;
        return $this;
    }
    /**
     * Get depositopen value
     * @return string
     */
    public function getDepositopen()
    {
        return $this->depositopen;
    }
    /**
     * Set depositopen value
     * @param string $depositopen
     * @return \StructType\SUMMARY
     */
    public function setDepositopen($depositopen = null)
    {
        // validation for constraint: string
        if (!is_null($depositopen) && !is_string($depositopen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositopen, true), gettype($depositopen)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($depositopen) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $depositopen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($depositopen, true)), __LINE__);
        }
        $this->depositopen = $depositopen;
        return $this;
    }
    /**
     * Get depositdue value
     * @return string
     */
    public function getDepositdue()
    {
        return $this->depositdue;
    }
    /**
     * Set depositdue value
     * @param string $depositdue
     * @return \StructType\SUMMARY
     */
    public function setDepositdue($depositdue = null)
    {
        // validation for constraint: string
        if (!is_null($depositdue) && !is_string($depositdue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositdue, true), gettype($depositdue)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($depositdue) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $depositdue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($depositdue, true)), __LINE__);
        }
        $this->depositdue = $depositdue;
        return $this;
    }
    /**
     * Get depositduedate value
     * @return string
     */
    public function getDepositduedate()
    {
        return $this->depositduedate;
    }
    /**
     * Set depositduedate value
     * @param string $depositduedate
     * @return \StructType\SUMMARY
     */
    public function setDepositduedate($depositduedate = null)
    {
        // validation for constraint: string
        if (!is_null($depositduedate) && !is_string($depositduedate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositduedate, true), gettype($depositduedate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($depositduedate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $depositduedate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($depositduedate, true)), __LINE__);
        }
        $this->depositduedate = $depositduedate;
        return $this;
    }
    /**
     * Get depositpayeddate value
     * @return string
     */
    public function getDepositpayeddate()
    {
        return $this->depositpayeddate;
    }
    /**
     * Set depositpayeddate value
     * @param string $depositpayeddate
     * @return \StructType\SUMMARY
     */
    public function setDepositpayeddate($depositpayeddate = null)
    {
        // validation for constraint: string
        if (!is_null($depositpayeddate) && !is_string($depositpayeddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositpayeddate, true), gettype($depositpayeddate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($depositpayeddate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $depositpayeddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($depositpayeddate, true)), __LINE__);
        }
        $this->depositpayeddate = $depositpayeddate;
        return $this;
    }
}
