<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SERVICE StructType
 * @subpackage Structs
 */
class SERVICE_1 extends AbstractStructBase
{
    /**
     * The SERVICE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $SERVICE_OBJID;
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $servicetype;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The descriptionlst
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $descriptionlst;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $quantity;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The amountnet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountnet;
    /**
     * The priceperunit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $priceperunit;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The currencyamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyamount;
    /**
     * The currencyexchangefactor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyexchangefactor;
    /**
     * The hoteldate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $hoteldate;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $packages;
    /**
     * The originalroom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $originalroom;
    /**
     * The VATS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VATS
     */
    public $VATS;
    /**
     * The TAXS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TAXS
     */
    public $TAXS;
    /**
     * The PARTLIST
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PARTLIST
     */
    public $PARTLIST;
    /**
     * Constructor method for SERVICE
     * @uses SERVICE_1::setSERVICE_OBJID()
     * @uses SERVICE_1::setServicetype()
     * @uses SERVICE_1::setService()
     * @uses SERVICE_1::setDescriptionlst()
     * @uses SERVICE_1::setArrival()
     * @uses SERVICE_1::setQuantity()
     * @uses SERVICE_1::setAmount()
     * @uses SERVICE_1::setAmountnet()
     * @uses SERVICE_1::setPriceperunit()
     * @uses SERVICE_1::setCurrency()
     * @uses SERVICE_1::setCurrencyamount()
     * @uses SERVICE_1::setCurrencyexchangefactor()
     * @uses SERVICE_1::setHoteldate()
     * @uses SERVICE_1::setPackages()
     * @uses SERVICE_1::setOriginalroom()
     * @uses SERVICE_1::setVATS()
     * @uses SERVICE_1::setTAXS()
     * @uses SERVICE_1::setPARTLIST()
     * @param string $sERVICE_OBJID
     * @param string $servicetype
     * @param string $service
     * @param string $descriptionlst
     * @param string $arrival
     * @param string $quantity
     * @param string $amount
     * @param string $amountnet
     * @param string $priceperunit
     * @param string $currency
     * @param string $currencyamount
     * @param string $currencyexchangefactor
     * @param string $hoteldate
     * @param string $packages
     * @param string $originalroom
     * @param \StructType\VATS $vATS
     * @param \StructType\TAXS $tAXS
     * @param \StructType\PARTLIST $pARTLIST
     */
    public function __construct($sERVICE_OBJID = null, $servicetype = null, $service = null, $descriptionlst = null, $arrival = null, $quantity = null, $amount = null, $amountnet = null, $priceperunit = null, $currency = null, $currencyamount = null, $currencyexchangefactor = null, $hoteldate = null, $packages = null, $originalroom = null, \StructType\VATS $vATS = null, \StructType\TAXS $tAXS = null, \StructType\PARTLIST $pARTLIST = null)
    {
        $this
            ->setSERVICE_OBJID($sERVICE_OBJID)
            ->setServicetype($servicetype)
            ->setService($service)
            ->setDescriptionlst($descriptionlst)
            ->setArrival($arrival)
            ->setQuantity($quantity)
            ->setAmount($amount)
            ->setAmountnet($amountnet)
            ->setPriceperunit($priceperunit)
            ->setCurrency($currency)
            ->setCurrencyamount($currencyamount)
            ->setCurrencyexchangefactor($currencyexchangefactor)
            ->setHoteldate($hoteldate)
            ->setPackages($packages)
            ->setOriginalroom($originalroom)
            ->setVATS($vATS)
            ->setTAXS($tAXS)
            ->setPARTLIST($pARTLIST);
    }
    /**
     * Get SERVICE_OBJID value
     * @return string
     */
    public function getSERVICE_OBJID()
    {
        return $this->{'SERVICE-OBJID'};
    }
    /**
     * Set SERVICE_OBJID value
     * @param string $sERVICE_OBJID
     * @return \StructType\SERVICE_1
     */
    public function setSERVICE_OBJID($sERVICE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICE_OBJID) && !is_string($sERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICE_OBJID, true), gettype($sERVICE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($sERVICE_OBJID) && !preg_match('/([0-9])*/', $sERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($sERVICE_OBJID, true)), __LINE__);
        }
        $this->SERVICE_OBJID = $this->{'SERVICE-OBJID'} = $sERVICE_OBJID;
        return $this;
    }
    /**
     * Get servicetype value
     * @return string
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\SERVICE_1
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($servicetype) && mb_strlen($servicetype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($servicetype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($servicetype) && mb_strlen($servicetype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\SERVICE_1
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get descriptionlst value
     * @return string
     */
    public function getDescriptionlst()
    {
        return $this->descriptionlst;
    }
    /**
     * Set descriptionlst value
     * @param string $descriptionlst
     * @return \StructType\SERVICE_1
     */
    public function setDescriptionlst($descriptionlst = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionlst) && !is_string($descriptionlst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionlst, true), gettype($descriptionlst)), __LINE__);
        }
        $this->descriptionlst = $descriptionlst;
        return $this;
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\SERVICE_1
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get quantity value
     * @return string
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\SERVICE_1
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($quantity) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($quantity, true)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\SERVICE_1
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get amountnet value
     * @return string
     */
    public function getAmountnet()
    {
        return $this->amountnet;
    }
    /**
     * Set amountnet value
     * @param string $amountnet
     * @return \StructType\SERVICE_1
     */
    public function setAmountnet($amountnet = null)
    {
        // validation for constraint: string
        if (!is_null($amountnet) && !is_string($amountnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountnet, true), gettype($amountnet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountnet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountnet, true)), __LINE__);
        }
        $this->amountnet = $amountnet;
        return $this;
    }
    /**
     * Get priceperunit value
     * @return string
     */
    public function getPriceperunit()
    {
        return $this->priceperunit;
    }
    /**
     * Set priceperunit value
     * @param string $priceperunit
     * @return \StructType\SERVICE_1
     */
    public function setPriceperunit($priceperunit = null)
    {
        // validation for constraint: string
        if (!is_null($priceperunit) && !is_string($priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceperunit, true), gettype($priceperunit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($priceperunit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($priceperunit, true)), __LINE__);
        }
        $this->priceperunit = $priceperunit;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\SERVICE_1
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get currencyamount value
     * @return string
     */
    public function getCurrencyamount()
    {
        return $this->currencyamount;
    }
    /**
     * Set currencyamount value
     * @param string $currencyamount
     * @return \StructType\SERVICE_1
     */
    public function setCurrencyamount($currencyamount = null)
    {
        // validation for constraint: string
        if (!is_null($currencyamount) && !is_string($currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyamount, true), gettype($currencyamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyamount, true)), __LINE__);
        }
        $this->currencyamount = $currencyamount;
        return $this;
    }
    /**
     * Get currencyexchangefactor value
     * @return string
     */
    public function getCurrencyexchangefactor()
    {
        return $this->currencyexchangefactor;
    }
    /**
     * Set currencyexchangefactor value
     * @param string $currencyexchangefactor
     * @return \StructType\SERVICE_1
     */
    public function setCurrencyexchangefactor($currencyexchangefactor = null)
    {
        // validation for constraint: string
        if (!is_null($currencyexchangefactor) && !is_string($currencyexchangefactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyexchangefactor, true), gettype($currencyexchangefactor)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyexchangefactor) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyexchangefactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyexchangefactor, true)), __LINE__);
        }
        $this->currencyexchangefactor = $currencyexchangefactor;
        return $this;
    }
    /**
     * Get hoteldate value
     * @return string
     */
    public function getHoteldate()
    {
        return $this->hoteldate;
    }
    /**
     * Set hoteldate value
     * @param string $hoteldate
     * @return \StructType\SERVICE_1
     */
    public function setHoteldate($hoteldate = null)
    {
        // validation for constraint: string
        if (!is_null($hoteldate) && !is_string($hoteldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoteldate, true), gettype($hoteldate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($hoteldate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $hoteldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($hoteldate, true)), __LINE__);
        }
        $this->hoteldate = $hoteldate;
        return $this;
    }
    /**
     * Get packages value
     * @return string
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * Set packages value
     * @param string $packages
     * @return \StructType\SERVICE_1
     */
    public function setPackages($packages = null)
    {
        // validation for constraint: string
        if (!is_null($packages) && !is_string($packages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packages, true), gettype($packages)), __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
    /**
     * Get originalroom value
     * @return string
     */
    public function getOriginalroom()
    {
        return $this->originalroom;
    }
    /**
     * Set originalroom value
     * @param string $originalroom
     * @return \StructType\SERVICE_1
     */
    public function setOriginalroom($originalroom = null)
    {
        // validation for constraint: string
        if (!is_null($originalroom) && !is_string($originalroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalroom, true), gettype($originalroom)), __LINE__);
        }
        $this->originalroom = $originalroom;
        return $this;
    }
    /**
     * Get VATS value
     * @return \StructType\VATS
     */
    public function getVATS()
    {
        return $this->VATS;
    }
    /**
     * Set VATS value
     * @param \StructType\VATS $vATS
     * @return \StructType\SERVICE_1
     */
    public function setVATS(\StructType\VATS $vATS = null)
    {
        $this->VATS = $vATS;
        return $this;
    }
    /**
     * Get TAXS value
     * @return \StructType\TAXS
     */
    public function getTAXS()
    {
        return $this->TAXS;
    }
    /**
     * Set TAXS value
     * @param \StructType\TAXS $tAXS
     * @return \StructType\SERVICE_1
     */
    public function setTAXS(\StructType\TAXS $tAXS = null)
    {
        $this->TAXS = $tAXS;
        return $this;
    }
    /**
     * Get PARTLIST value
     * @return \StructType\PARTLIST
     */
    public function getPARTLIST()
    {
        return $this->PARTLIST;
    }
    /**
     * Set PARTLIST value
     * @param \StructType\PARTLIST $pARTLIST
     * @return \StructType\SERVICE_1
     */
    public function setPARTLIST(\StructType\PARTLIST $pARTLIST = null)
    {
        $this->PARTLIST = $pARTLIST;
        return $this;
    }
}
