<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SALESPOTENTIAL-SEARCH StructType
 * @subpackage Structs
 */
class SALESPOTENTIAL_SEARCH extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $year;
    /**
     * The monthexecution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $monthexecution;
    /**
     * The yearplanned
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $yearplanned;
    /**
     * The monthplanning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $monthplanning;
    /**
     * The lostwon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lostwon;
    /**
     * The salesperson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesperson;
    /**
     * Constructor method for SALESPOTENTIAL-SEARCH
     * @uses SALESPOTENTIAL_SEARCH::setType()
     * @uses SALESPOTENTIAL_SEARCH::setStatus()
     * @uses SALESPOTENTIAL_SEARCH::setYear()
     * @uses SALESPOTENTIAL_SEARCH::setMonthexecution()
     * @uses SALESPOTENTIAL_SEARCH::setYearplanned()
     * @uses SALESPOTENTIAL_SEARCH::setMonthplanning()
     * @uses SALESPOTENTIAL_SEARCH::setLostwon()
     * @uses SALESPOTENTIAL_SEARCH::setSalesperson()
     * @param string $type
     * @param string $status
     * @param string $year
     * @param string $monthexecution
     * @param string $yearplanned
     * @param string $monthplanning
     * @param string $lostwon
     * @param string $salesperson
     */
    public function __construct($type = null, $status = null, $year = null, $monthexecution = null, $yearplanned = null, $monthplanning = null, $lostwon = null, $salesperson = null)
    {
        $this
            ->setType($type)
            ->setStatus($status)
            ->setYear($year)
            ->setMonthexecution($monthexecution)
            ->setYearplanned($yearplanned)
            ->setMonthplanning($monthplanning)
            ->setLostwon($lostwon)
            ->setSalesperson($salesperson);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\SALESPOTENTIAL_SEARCH
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\SALESPOTENTIAL_SEARCH
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get year value
     * @return string|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param string $year
     * @return \StructType\SALESPOTENTIAL_SEARCH
     */
    public function setYear($year = null)
    {
        // validation for constraint: string
        if (!is_null($year) && !is_string($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($year) && !preg_match('/([-+]){0,1}([0-9])*/', $year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($year, true)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get monthexecution value
     * @return string|null
     */
    public function getMonthexecution()
    {
        return $this->monthexecution;
    }
    /**
     * Set monthexecution value
     * @param string $monthexecution
     * @return \StructType\SALESPOTENTIAL_SEARCH
     */
    public function setMonthexecution($monthexecution = null)
    {
        // validation for constraint: string
        if (!is_null($monthexecution) && !is_string($monthexecution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monthexecution, true), gettype($monthexecution)), __LINE__);
        }
        $this->monthexecution = $monthexecution;
        return $this;
    }
    /**
     * Get yearplanned value
     * @return string|null
     */
    public function getYearplanned()
    {
        return $this->yearplanned;
    }
    /**
     * Set yearplanned value
     * @param string $yearplanned
     * @return \StructType\SALESPOTENTIAL_SEARCH
     */
    public function setYearplanned($yearplanned = null)
    {
        // validation for constraint: string
        if (!is_null($yearplanned) && !is_string($yearplanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yearplanned, true), gettype($yearplanned)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($yearplanned) && !preg_match('/([-+]){0,1}([0-9])*/', $yearplanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($yearplanned, true)), __LINE__);
        }
        $this->yearplanned = $yearplanned;
        return $this;
    }
    /**
     * Get monthplanning value
     * @return string|null
     */
    public function getMonthplanning()
    {
        return $this->monthplanning;
    }
    /**
     * Set monthplanning value
     * @param string $monthplanning
     * @return \StructType\SALESPOTENTIAL_SEARCH
     */
    public function setMonthplanning($monthplanning = null)
    {
        // validation for constraint: string
        if (!is_null($monthplanning) && !is_string($monthplanning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monthplanning, true), gettype($monthplanning)), __LINE__);
        }
        $this->monthplanning = $monthplanning;
        return $this;
    }
    /**
     * Get lostwon value
     * @return string|null
     */
    public function getLostwon()
    {
        return $this->lostwon;
    }
    /**
     * Set lostwon value
     * @param string $lostwon
     * @return \StructType\SALESPOTENTIAL_SEARCH
     */
    public function setLostwon($lostwon = null)
    {
        // validation for constraint: string
        if (!is_null($lostwon) && !is_string($lostwon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lostwon, true), gettype($lostwon)), __LINE__);
        }
        $this->lostwon = $lostwon;
        return $this;
    }
    /**
     * Get salesperson value
     * @return string|null
     */
    public function getSalesperson()
    {
        return $this->salesperson;
    }
    /**
     * Set salesperson value
     * @param string $salesperson
     * @return \StructType\SALESPOTENTIAL_SEARCH
     */
    public function setSalesperson($salesperson = null)
    {
        // validation for constraint: string
        if (!is_null($salesperson) && !is_string($salesperson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesperson, true), gettype($salesperson)), __LINE__);
        }
        $this->salesperson = $salesperson;
        return $this;
    }
}
