<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SALESPOTENTIAL StructType
 * @subpackage Structs
 */
class SALESPOTENTIAL extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $year;
    /**
     * The monthexecution
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $monthexecution;
    /**
     * The yearplanned
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $yearplanned;
    /**
     * The monthplanning
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $monthplanning;
    /**
     * The salesperson
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $salesperson;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The probability
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $probability;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The estimatedrevenue
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $estimatedrevenue;
    /**
     * The SALESPOTENTIAL_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $SALESPOTENTIAL_OBJID;
    /**
     * The closedreason
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $closedreason;
    /**
     * The lostwon
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $lostwon;
    /**
     * The incllogis
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $incllogis;
    /**
     * The revenueperroom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $revenueperroom;
    /**
     * The revenueamount1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $revenueamount1;
    /**
     * The revenueamount2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $revenueamount2;
    /**
     * The revenueamount3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $revenueamount3;
    /**
     * The revenueamount4
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $revenueamount4;
    /**
     * The revenueamount5
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $revenueamount5;
    /**
     * The revenueperpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $revenueperpax;
    /**
     * The extraamount1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $extraamount1;
    /**
     * The extraamount2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $extraamount2;
    /**
     * The extraamount3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $extraamount3;
    /**
     * The extraamount4
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $extraamount4;
    /**
     * The extraamount5
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $extraamount5;
    /**
     * The minnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $minnoofpax;
    /**
     * The maxnoofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxnoofpax;
    /**
     * The minstaylength
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $minstaylength;
    /**
     * The maxstaylength
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxstaylength;
    /**
     * The minnoofrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $minnoofrooms;
    /**
     * The feature1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $feature1;
    /**
     * The feature2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $feature2;
    /**
     * The feature3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $feature3;
    /**
     * The feature4
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $feature4;
    /**
     * The feature5
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $feature5;
    /**
     * The featuretext1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $featuretext1;
    /**
     * The featuretext2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $featuretext2;
    /**
     * The competitor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $competitor;
    /**
     * The competitortext
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $competitortext;
    /**
     * The specialrequest
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $specialrequest;
    /**
     * The specialrequesttext
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $specialrequesttext;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The GUEST
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUEST[]
     */
    public $GUEST;
    /**
     * The maxnoofrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $maxnoofrooms;
    /**
     * Constructor method for SALESPOTENTIAL
     * @uses SALESPOTENTIAL::setDescription()
     * @uses SALESPOTENTIAL::setYear()
     * @uses SALESPOTENTIAL::setMonthexecution()
     * @uses SALESPOTENTIAL::setYearplanned()
     * @uses SALESPOTENTIAL::setMonthplanning()
     * @uses SALESPOTENTIAL::setSalesperson()
     * @uses SALESPOTENTIAL::setHotel()
     * @uses SALESPOTENTIAL::setStatus()
     * @uses SALESPOTENTIAL::setProbability()
     * @uses SALESPOTENTIAL::setType()
     * @uses SALESPOTENTIAL::setEstimatedrevenue()
     * @uses SALESPOTENTIAL::setSALESPOTENTIAL_OBJID()
     * @uses SALESPOTENTIAL::setClosedreason()
     * @uses SALESPOTENTIAL::setLostwon()
     * @uses SALESPOTENTIAL::setIncllogis()
     * @uses SALESPOTENTIAL::setRevenueperroom()
     * @uses SALESPOTENTIAL::setRevenueamount1()
     * @uses SALESPOTENTIAL::setRevenueamount2()
     * @uses SALESPOTENTIAL::setRevenueamount3()
     * @uses SALESPOTENTIAL::setRevenueamount4()
     * @uses SALESPOTENTIAL::setRevenueamount5()
     * @uses SALESPOTENTIAL::setRevenueperpax()
     * @uses SALESPOTENTIAL::setExtraamount1()
     * @uses SALESPOTENTIAL::setExtraamount2()
     * @uses SALESPOTENTIAL::setExtraamount3()
     * @uses SALESPOTENTIAL::setExtraamount4()
     * @uses SALESPOTENTIAL::setExtraamount5()
     * @uses SALESPOTENTIAL::setMinnoofpax()
     * @uses SALESPOTENTIAL::setMaxnoofpax()
     * @uses SALESPOTENTIAL::setMinstaylength()
     * @uses SALESPOTENTIAL::setMaxstaylength()
     * @uses SALESPOTENTIAL::setMinnoofrooms()
     * @uses SALESPOTENTIAL::setFeature1()
     * @uses SALESPOTENTIAL::setFeature2()
     * @uses SALESPOTENTIAL::setFeature3()
     * @uses SALESPOTENTIAL::setFeature4()
     * @uses SALESPOTENTIAL::setFeature5()
     * @uses SALESPOTENTIAL::setFeaturetext1()
     * @uses SALESPOTENTIAL::setFeaturetext2()
     * @uses SALESPOTENTIAL::setCompetitor()
     * @uses SALESPOTENTIAL::setCompetitortext()
     * @uses SALESPOTENTIAL::setSpecialrequest()
     * @uses SALESPOTENTIAL::setSpecialrequesttext()
     * @uses SALESPOTENTIAL::setComment()
     * @uses SALESPOTENTIAL::setGUEST()
     * @uses SALESPOTENTIAL::setMaxnoofrooms()
     * @param string $description
     * @param string $year
     * @param string $monthexecution
     * @param string $yearplanned
     * @param string $monthplanning
     * @param string $salesperson
     * @param string $hotel
     * @param string $status
     * @param string $probability
     * @param string $type
     * @param string $estimatedrevenue
     * @param string $sALESPOTENTIAL_OBJID
     * @param string $closedreason
     * @param string $lostwon
     * @param string $incllogis
     * @param string $revenueperroom
     * @param string $revenueamount1
     * @param string $revenueamount2
     * @param string $revenueamount3
     * @param string $revenueamount4
     * @param string $revenueamount5
     * @param string $revenueperpax
     * @param string $extraamount1
     * @param string $extraamount2
     * @param string $extraamount3
     * @param string $extraamount4
     * @param string $extraamount5
     * @param string $minnoofpax
     * @param string $maxnoofpax
     * @param string $minstaylength
     * @param string $maxstaylength
     * @param string $minnoofrooms
     * @param string $feature1
     * @param string $feature2
     * @param string $feature3
     * @param string $feature4
     * @param string $feature5
     * @param string $featuretext1
     * @param string $featuretext2
     * @param string $competitor
     * @param string $competitortext
     * @param string $specialrequest
     * @param string $specialrequesttext
     * @param string $comment
     * @param \StructType\GUEST[] $gUEST
     * @param string $maxnoofrooms
     */
    public function __construct($description = null, $year = null, $monthexecution = null, $yearplanned = null, $monthplanning = null, $salesperson = null, $hotel = null, $status = null, $probability = null, $type = null, $estimatedrevenue = null, $sALESPOTENTIAL_OBJID = null, $closedreason = null, $lostwon = null, $incllogis = null, $revenueperroom = null, $revenueamount1 = null, $revenueamount2 = null, $revenueamount3 = null, $revenueamount4 = null, $revenueamount5 = null, $revenueperpax = null, $extraamount1 = null, $extraamount2 = null, $extraamount3 = null, $extraamount4 = null, $extraamount5 = null, $minnoofpax = null, $maxnoofpax = null, $minstaylength = null, $maxstaylength = null, $minnoofrooms = null, $feature1 = null, $feature2 = null, $feature3 = null, $feature4 = null, $feature5 = null, $featuretext1 = null, $featuretext2 = null, $competitor = null, $competitortext = null, $specialrequest = null, $specialrequesttext = null, $comment = null, array $gUEST = array(), $maxnoofrooms = null)
    {
        $this
            ->setDescription($description)
            ->setYear($year)
            ->setMonthexecution($monthexecution)
            ->setYearplanned($yearplanned)
            ->setMonthplanning($monthplanning)
            ->setSalesperson($salesperson)
            ->setHotel($hotel)
            ->setStatus($status)
            ->setProbability($probability)
            ->setType($type)
            ->setEstimatedrevenue($estimatedrevenue)
            ->setSALESPOTENTIAL_OBJID($sALESPOTENTIAL_OBJID)
            ->setClosedreason($closedreason)
            ->setLostwon($lostwon)
            ->setIncllogis($incllogis)
            ->setRevenueperroom($revenueperroom)
            ->setRevenueamount1($revenueamount1)
            ->setRevenueamount2($revenueamount2)
            ->setRevenueamount3($revenueamount3)
            ->setRevenueamount4($revenueamount4)
            ->setRevenueamount5($revenueamount5)
            ->setRevenueperpax($revenueperpax)
            ->setExtraamount1($extraamount1)
            ->setExtraamount2($extraamount2)
            ->setExtraamount3($extraamount3)
            ->setExtraamount4($extraamount4)
            ->setExtraamount5($extraamount5)
            ->setMinnoofpax($minnoofpax)
            ->setMaxnoofpax($maxnoofpax)
            ->setMinstaylength($minstaylength)
            ->setMaxstaylength($maxstaylength)
            ->setMinnoofrooms($minnoofrooms)
            ->setFeature1($feature1)
            ->setFeature2($feature2)
            ->setFeature3($feature3)
            ->setFeature4($feature4)
            ->setFeature5($feature5)
            ->setFeaturetext1($featuretext1)
            ->setFeaturetext2($featuretext2)
            ->setCompetitor($competitor)
            ->setCompetitortext($competitortext)
            ->setSpecialrequest($specialrequest)
            ->setSpecialrequesttext($specialrequesttext)
            ->setComment($comment)
            ->setGUEST($gUEST)
            ->setMaxnoofrooms($maxnoofrooms);
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SALESPOTENTIAL
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($description) && mb_strlen($description) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get year value
     * @return string
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param string $year
     * @return \StructType\SALESPOTENTIAL
     */
    public function setYear($year = null)
    {
        // validation for constraint: string
        if (!is_null($year) && !is_string($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($year) && !preg_match('/([-+]){0,1}([0-9])*/', $year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($year, true)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get monthexecution value
     * @return string
     */
    public function getMonthexecution()
    {
        return $this->monthexecution;
    }
    /**
     * Set monthexecution value
     * @param string $monthexecution
     * @return \StructType\SALESPOTENTIAL
     */
    public function setMonthexecution($monthexecution = null)
    {
        // validation for constraint: string
        if (!is_null($monthexecution) && !is_string($monthexecution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monthexecution, true), gettype($monthexecution)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($monthexecution) && mb_strlen($monthexecution) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($monthexecution)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($monthexecution) && mb_strlen($monthexecution) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($monthexecution)), __LINE__);
        }
        $this->monthexecution = $monthexecution;
        return $this;
    }
    /**
     * Get yearplanned value
     * @return string
     */
    public function getYearplanned()
    {
        return $this->yearplanned;
    }
    /**
     * Set yearplanned value
     * @param string $yearplanned
     * @return \StructType\SALESPOTENTIAL
     */
    public function setYearplanned($yearplanned = null)
    {
        // validation for constraint: string
        if (!is_null($yearplanned) && !is_string($yearplanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yearplanned, true), gettype($yearplanned)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($yearplanned) && !preg_match('/([-+]){0,1}([0-9])*/', $yearplanned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($yearplanned, true)), __LINE__);
        }
        $this->yearplanned = $yearplanned;
        return $this;
    }
    /**
     * Get monthplanning value
     * @return string
     */
    public function getMonthplanning()
    {
        return $this->monthplanning;
    }
    /**
     * Set monthplanning value
     * @param string $monthplanning
     * @return \StructType\SALESPOTENTIAL
     */
    public function setMonthplanning($monthplanning = null)
    {
        // validation for constraint: string
        if (!is_null($monthplanning) && !is_string($monthplanning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monthplanning, true), gettype($monthplanning)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($monthplanning) && mb_strlen($monthplanning) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($monthplanning)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($monthplanning) && mb_strlen($monthplanning) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($monthplanning)), __LINE__);
        }
        $this->monthplanning = $monthplanning;
        return $this;
    }
    /**
     * Get salesperson value
     * @return string
     */
    public function getSalesperson()
    {
        return $this->salesperson;
    }
    /**
     * Set salesperson value
     * @param string $salesperson
     * @return \StructType\SALESPOTENTIAL
     */
    public function setSalesperson($salesperson = null)
    {
        // validation for constraint: string
        if (!is_null($salesperson) && !is_string($salesperson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesperson, true), gettype($salesperson)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($salesperson) && mb_strlen($salesperson) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($salesperson)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($salesperson) && mb_strlen($salesperson) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($salesperson)), __LINE__);
        }
        $this->salesperson = $salesperson;
        return $this;
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\SALESPOTENTIAL
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\SALESPOTENTIAL
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($status) && mb_strlen($status) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($status)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($status) && mb_strlen($status) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get probability value
     * @return string
     */
    public function getProbability()
    {
        return $this->probability;
    }
    /**
     * Set probability value
     * @param string $probability
     * @return \StructType\SALESPOTENTIAL
     */
    public function setProbability($probability = null)
    {
        // validation for constraint: string
        if (!is_null($probability) && !is_string($probability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($probability, true), gettype($probability)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($probability) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $probability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($probability, true)), __LINE__);
        }
        $this->probability = $probability;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\SALESPOTENTIAL
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get estimatedrevenue value
     * @return string
     */
    public function getEstimatedrevenue()
    {
        return $this->estimatedrevenue;
    }
    /**
     * Set estimatedrevenue value
     * @param string $estimatedrevenue
     * @return \StructType\SALESPOTENTIAL
     */
    public function setEstimatedrevenue($estimatedrevenue = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedrevenue) && !is_string($estimatedrevenue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedrevenue, true), gettype($estimatedrevenue)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($estimatedrevenue) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $estimatedrevenue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($estimatedrevenue, true)), __LINE__);
        }
        $this->estimatedrevenue = $estimatedrevenue;
        return $this;
    }
    /**
     * Get SALESPOTENTIAL_OBJID value
     * @return string
     */
    public function getSALESPOTENTIAL_OBJID()
    {
        return $this->{'SALESPOTENTIAL-OBJID'};
    }
    /**
     * Set SALESPOTENTIAL_OBJID value
     * @param string $sALESPOTENTIAL_OBJID
     * @return \StructType\SALESPOTENTIAL
     */
    public function setSALESPOTENTIAL_OBJID($sALESPOTENTIAL_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sALESPOTENTIAL_OBJID) && !is_string($sALESPOTENTIAL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sALESPOTENTIAL_OBJID, true), gettype($sALESPOTENTIAL_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($sALESPOTENTIAL_OBJID) && !preg_match('/([0-9])*/', $sALESPOTENTIAL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($sALESPOTENTIAL_OBJID, true)), __LINE__);
        }
        $this->SALESPOTENTIAL_OBJID = $this->{'SALESPOTENTIAL-OBJID'} = $sALESPOTENTIAL_OBJID;
        return $this;
    }
    /**
     * Get closedreason value
     * @return string
     */
    public function getClosedreason()
    {
        return $this->closedreason;
    }
    /**
     * Set closedreason value
     * @param string $closedreason
     * @return \StructType\SALESPOTENTIAL
     */
    public function setClosedreason($closedreason = null)
    {
        // validation for constraint: string
        if (!is_null($closedreason) && !is_string($closedreason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closedreason, true), gettype($closedreason)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($closedreason) && mb_strlen($closedreason) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($closedreason)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($closedreason) && mb_strlen($closedreason) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($closedreason)), __LINE__);
        }
        $this->closedreason = $closedreason;
        return $this;
    }
    /**
     * Get lostwon value
     * @return string
     */
    public function getLostwon()
    {
        return $this->lostwon;
    }
    /**
     * Set lostwon value
     * @param string $lostwon
     * @return \StructType\SALESPOTENTIAL
     */
    public function setLostwon($lostwon = null)
    {
        // validation for constraint: string
        if (!is_null($lostwon) && !is_string($lostwon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lostwon, true), gettype($lostwon)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($lostwon) && mb_strlen($lostwon) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($lostwon)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($lostwon) && mb_strlen($lostwon) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($lostwon)), __LINE__);
        }
        $this->lostwon = $lostwon;
        return $this;
    }
    /**
     * Get incllogis value
     * @return string|null
     */
    public function getIncllogis()
    {
        return $this->incllogis;
    }
    /**
     * Set incllogis value
     * @param string $incllogis
     * @return \StructType\SALESPOTENTIAL
     */
    public function setIncllogis($incllogis = null)
    {
        // validation for constraint: string
        if (!is_null($incllogis) && !is_string($incllogis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incllogis, true), gettype($incllogis)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($incllogis) && !preg_match('/([-+]){0,1}([0-9])*/', $incllogis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($incllogis, true)), __LINE__);
        }
        $this->incllogis = $incllogis;
        return $this;
    }
    /**
     * Get revenueperroom value
     * @return string|null
     */
    public function getRevenueperroom()
    {
        return $this->revenueperroom;
    }
    /**
     * Set revenueperroom value
     * @param string $revenueperroom
     * @return \StructType\SALESPOTENTIAL
     */
    public function setRevenueperroom($revenueperroom = null)
    {
        // validation for constraint: string
        if (!is_null($revenueperroom) && !is_string($revenueperroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueperroom, true), gettype($revenueperroom)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($revenueperroom) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $revenueperroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($revenueperroom, true)), __LINE__);
        }
        $this->revenueperroom = $revenueperroom;
        return $this;
    }
    /**
     * Get revenueamount1 value
     * @return string|null
     */
    public function getRevenueamount1()
    {
        return $this->revenueamount1;
    }
    /**
     * Set revenueamount1 value
     * @param string $revenueamount1
     * @return \StructType\SALESPOTENTIAL
     */
    public function setRevenueamount1($revenueamount1 = null)
    {
        // validation for constraint: string
        if (!is_null($revenueamount1) && !is_string($revenueamount1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueamount1, true), gettype($revenueamount1)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($revenueamount1) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $revenueamount1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($revenueamount1, true)), __LINE__);
        }
        $this->revenueamount1 = $revenueamount1;
        return $this;
    }
    /**
     * Get revenueamount2 value
     * @return string|null
     */
    public function getRevenueamount2()
    {
        return $this->revenueamount2;
    }
    /**
     * Set revenueamount2 value
     * @param string $revenueamount2
     * @return \StructType\SALESPOTENTIAL
     */
    public function setRevenueamount2($revenueamount2 = null)
    {
        // validation for constraint: string
        if (!is_null($revenueamount2) && !is_string($revenueamount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueamount2, true), gettype($revenueamount2)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($revenueamount2) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $revenueamount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($revenueamount2, true)), __LINE__);
        }
        $this->revenueamount2 = $revenueamount2;
        return $this;
    }
    /**
     * Get revenueamount3 value
     * @return string|null
     */
    public function getRevenueamount3()
    {
        return $this->revenueamount3;
    }
    /**
     * Set revenueamount3 value
     * @param string $revenueamount3
     * @return \StructType\SALESPOTENTIAL
     */
    public function setRevenueamount3($revenueamount3 = null)
    {
        // validation for constraint: string
        if (!is_null($revenueamount3) && !is_string($revenueamount3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueamount3, true), gettype($revenueamount3)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($revenueamount3) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $revenueamount3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($revenueamount3, true)), __LINE__);
        }
        $this->revenueamount3 = $revenueamount3;
        return $this;
    }
    /**
     * Get revenueamount4 value
     * @return string|null
     */
    public function getRevenueamount4()
    {
        return $this->revenueamount4;
    }
    /**
     * Set revenueamount4 value
     * @param string $revenueamount4
     * @return \StructType\SALESPOTENTIAL
     */
    public function setRevenueamount4($revenueamount4 = null)
    {
        // validation for constraint: string
        if (!is_null($revenueamount4) && !is_string($revenueamount4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueamount4, true), gettype($revenueamount4)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($revenueamount4) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $revenueamount4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($revenueamount4, true)), __LINE__);
        }
        $this->revenueamount4 = $revenueamount4;
        return $this;
    }
    /**
     * Get revenueamount5 value
     * @return string|null
     */
    public function getRevenueamount5()
    {
        return $this->revenueamount5;
    }
    /**
     * Set revenueamount5 value
     * @param string $revenueamount5
     * @return \StructType\SALESPOTENTIAL
     */
    public function setRevenueamount5($revenueamount5 = null)
    {
        // validation for constraint: string
        if (!is_null($revenueamount5) && !is_string($revenueamount5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueamount5, true), gettype($revenueamount5)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($revenueamount5) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $revenueamount5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($revenueamount5, true)), __LINE__);
        }
        $this->revenueamount5 = $revenueamount5;
        return $this;
    }
    /**
     * Get revenueperpax value
     * @return string|null
     */
    public function getRevenueperpax()
    {
        return $this->revenueperpax;
    }
    /**
     * Set revenueperpax value
     * @param string $revenueperpax
     * @return \StructType\SALESPOTENTIAL
     */
    public function setRevenueperpax($revenueperpax = null)
    {
        // validation for constraint: string
        if (!is_null($revenueperpax) && !is_string($revenueperpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueperpax, true), gettype($revenueperpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($revenueperpax) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $revenueperpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($revenueperpax, true)), __LINE__);
        }
        $this->revenueperpax = $revenueperpax;
        return $this;
    }
    /**
     * Get extraamount1 value
     * @return string|null
     */
    public function getExtraamount1()
    {
        return $this->extraamount1;
    }
    /**
     * Set extraamount1 value
     * @param string $extraamount1
     * @return \StructType\SALESPOTENTIAL
     */
    public function setExtraamount1($extraamount1 = null)
    {
        // validation for constraint: string
        if (!is_null($extraamount1) && !is_string($extraamount1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraamount1, true), gettype($extraamount1)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($extraamount1) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $extraamount1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($extraamount1, true)), __LINE__);
        }
        $this->extraamount1 = $extraamount1;
        return $this;
    }
    /**
     * Get extraamount2 value
     * @return string|null
     */
    public function getExtraamount2()
    {
        return $this->extraamount2;
    }
    /**
     * Set extraamount2 value
     * @param string $extraamount2
     * @return \StructType\SALESPOTENTIAL
     */
    public function setExtraamount2($extraamount2 = null)
    {
        // validation for constraint: string
        if (!is_null($extraamount2) && !is_string($extraamount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraamount2, true), gettype($extraamount2)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($extraamount2) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $extraamount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($extraamount2, true)), __LINE__);
        }
        $this->extraamount2 = $extraamount2;
        return $this;
    }
    /**
     * Get extraamount3 value
     * @return string|null
     */
    public function getExtraamount3()
    {
        return $this->extraamount3;
    }
    /**
     * Set extraamount3 value
     * @param string $extraamount3
     * @return \StructType\SALESPOTENTIAL
     */
    public function setExtraamount3($extraamount3 = null)
    {
        // validation for constraint: string
        if (!is_null($extraamount3) && !is_string($extraamount3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraamount3, true), gettype($extraamount3)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($extraamount3) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $extraamount3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($extraamount3, true)), __LINE__);
        }
        $this->extraamount3 = $extraamount3;
        return $this;
    }
    /**
     * Get extraamount4 value
     * @return string|null
     */
    public function getExtraamount4()
    {
        return $this->extraamount4;
    }
    /**
     * Set extraamount4 value
     * @param string $extraamount4
     * @return \StructType\SALESPOTENTIAL
     */
    public function setExtraamount4($extraamount4 = null)
    {
        // validation for constraint: string
        if (!is_null($extraamount4) && !is_string($extraamount4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraamount4, true), gettype($extraamount4)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($extraamount4) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $extraamount4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($extraamount4, true)), __LINE__);
        }
        $this->extraamount4 = $extraamount4;
        return $this;
    }
    /**
     * Get extraamount5 value
     * @return string|null
     */
    public function getExtraamount5()
    {
        return $this->extraamount5;
    }
    /**
     * Set extraamount5 value
     * @param string $extraamount5
     * @return \StructType\SALESPOTENTIAL
     */
    public function setExtraamount5($extraamount5 = null)
    {
        // validation for constraint: string
        if (!is_null($extraamount5) && !is_string($extraamount5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraamount5, true), gettype($extraamount5)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($extraamount5) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $extraamount5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($extraamount5, true)), __LINE__);
        }
        $this->extraamount5 = $extraamount5;
        return $this;
    }
    /**
     * Get minnoofpax value
     * @return string|null
     */
    public function getMinnoofpax()
    {
        return $this->minnoofpax;
    }
    /**
     * Set minnoofpax value
     * @param string $minnoofpax
     * @return \StructType\SALESPOTENTIAL
     */
    public function setMinnoofpax($minnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($minnoofpax) && !is_string($minnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minnoofpax, true), gettype($minnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($minnoofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $minnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($minnoofpax, true)), __LINE__);
        }
        $this->minnoofpax = $minnoofpax;
        return $this;
    }
    /**
     * Get maxnoofpax value
     * @return string|null
     */
    public function getMaxnoofpax()
    {
        return $this->maxnoofpax;
    }
    /**
     * Set maxnoofpax value
     * @param string $maxnoofpax
     * @return \StructType\SALESPOTENTIAL
     */
    public function setMaxnoofpax($maxnoofpax = null)
    {
        // validation for constraint: string
        if (!is_null($maxnoofpax) && !is_string($maxnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxnoofpax, true), gettype($maxnoofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxnoofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $maxnoofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxnoofpax, true)), __LINE__);
        }
        $this->maxnoofpax = $maxnoofpax;
        return $this;
    }
    /**
     * Get minstaylength value
     * @return string|null
     */
    public function getMinstaylength()
    {
        return $this->minstaylength;
    }
    /**
     * Set minstaylength value
     * @param string $minstaylength
     * @return \StructType\SALESPOTENTIAL
     */
    public function setMinstaylength($minstaylength = null)
    {
        // validation for constraint: string
        if (!is_null($minstaylength) && !is_string($minstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minstaylength, true), gettype($minstaylength)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($minstaylength) && !preg_match('/([-+]){0,1}([0-9])*/', $minstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($minstaylength, true)), __LINE__);
        }
        $this->minstaylength = $minstaylength;
        return $this;
    }
    /**
     * Get maxstaylength value
     * @return string|null
     */
    public function getMaxstaylength()
    {
        return $this->maxstaylength;
    }
    /**
     * Set maxstaylength value
     * @param string $maxstaylength
     * @return \StructType\SALESPOTENTIAL
     */
    public function setMaxstaylength($maxstaylength = null)
    {
        // validation for constraint: string
        if (!is_null($maxstaylength) && !is_string($maxstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxstaylength, true), gettype($maxstaylength)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxstaylength) && !preg_match('/([-+]){0,1}([0-9])*/', $maxstaylength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxstaylength, true)), __LINE__);
        }
        $this->maxstaylength = $maxstaylength;
        return $this;
    }
    /**
     * Get minnoofrooms value
     * @return string|null
     */
    public function getMinnoofrooms()
    {
        return $this->minnoofrooms;
    }
    /**
     * Set minnoofrooms value
     * @param string $minnoofrooms
     * @return \StructType\SALESPOTENTIAL
     */
    public function setMinnoofrooms($minnoofrooms = null)
    {
        // validation for constraint: string
        if (!is_null($minnoofrooms) && !is_string($minnoofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minnoofrooms, true), gettype($minnoofrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($minnoofrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $minnoofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($minnoofrooms, true)), __LINE__);
        }
        $this->minnoofrooms = $minnoofrooms;
        return $this;
    }
    /**
     * Get feature1 value
     * @return string|null
     */
    public function getFeature1()
    {
        return $this->feature1;
    }
    /**
     * Set feature1 value
     * @param string $feature1
     * @return \StructType\SALESPOTENTIAL
     */
    public function setFeature1($feature1 = null)
    {
        // validation for constraint: string
        if (!is_null($feature1) && !is_string($feature1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature1, true), gettype($feature1)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($feature1) && mb_strlen($feature1) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($feature1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($feature1) && mb_strlen($feature1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($feature1)), __LINE__);
        }
        $this->feature1 = $feature1;
        return $this;
    }
    /**
     * Get feature2 value
     * @return string|null
     */
    public function getFeature2()
    {
        return $this->feature2;
    }
    /**
     * Set feature2 value
     * @param string $feature2
     * @return \StructType\SALESPOTENTIAL
     */
    public function setFeature2($feature2 = null)
    {
        // validation for constraint: string
        if (!is_null($feature2) && !is_string($feature2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature2, true), gettype($feature2)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($feature2) && mb_strlen($feature2) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($feature2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($feature2) && mb_strlen($feature2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($feature2)), __LINE__);
        }
        $this->feature2 = $feature2;
        return $this;
    }
    /**
     * Get feature3 value
     * @return string|null
     */
    public function getFeature3()
    {
        return $this->feature3;
    }
    /**
     * Set feature3 value
     * @param string $feature3
     * @return \StructType\SALESPOTENTIAL
     */
    public function setFeature3($feature3 = null)
    {
        // validation for constraint: string
        if (!is_null($feature3) && !is_string($feature3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature3, true), gettype($feature3)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($feature3) && mb_strlen($feature3) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($feature3)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($feature3) && mb_strlen($feature3) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($feature3)), __LINE__);
        }
        $this->feature3 = $feature3;
        return $this;
    }
    /**
     * Get feature4 value
     * @return string|null
     */
    public function getFeature4()
    {
        return $this->feature4;
    }
    /**
     * Set feature4 value
     * @param string $feature4
     * @return \StructType\SALESPOTENTIAL
     */
    public function setFeature4($feature4 = null)
    {
        // validation for constraint: string
        if (!is_null($feature4) && !is_string($feature4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature4, true), gettype($feature4)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($feature4) && mb_strlen($feature4) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($feature4)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($feature4) && mb_strlen($feature4) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($feature4)), __LINE__);
        }
        $this->feature4 = $feature4;
        return $this;
    }
    /**
     * Get feature5 value
     * @return string|null
     */
    public function getFeature5()
    {
        return $this->feature5;
    }
    /**
     * Set feature5 value
     * @param string $feature5
     * @return \StructType\SALESPOTENTIAL
     */
    public function setFeature5($feature5 = null)
    {
        // validation for constraint: string
        if (!is_null($feature5) && !is_string($feature5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature5, true), gettype($feature5)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($feature5) && mb_strlen($feature5) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($feature5)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($feature5) && mb_strlen($feature5) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($feature5)), __LINE__);
        }
        $this->feature5 = $feature5;
        return $this;
    }
    /**
     * Get featuretext1 value
     * @return string|null
     */
    public function getFeaturetext1()
    {
        return $this->featuretext1;
    }
    /**
     * Set featuretext1 value
     * @param string $featuretext1
     * @return \StructType\SALESPOTENTIAL
     */
    public function setFeaturetext1($featuretext1 = null)
    {
        // validation for constraint: string
        if (!is_null($featuretext1) && !is_string($featuretext1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featuretext1, true), gettype($featuretext1)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($featuretext1) && mb_strlen($featuretext1) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($featuretext1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($featuretext1) && mb_strlen($featuretext1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($featuretext1)), __LINE__);
        }
        $this->featuretext1 = $featuretext1;
        return $this;
    }
    /**
     * Get featuretext2 value
     * @return string|null
     */
    public function getFeaturetext2()
    {
        return $this->featuretext2;
    }
    /**
     * Set featuretext2 value
     * @param string $featuretext2
     * @return \StructType\SALESPOTENTIAL
     */
    public function setFeaturetext2($featuretext2 = null)
    {
        // validation for constraint: string
        if (!is_null($featuretext2) && !is_string($featuretext2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featuretext2, true), gettype($featuretext2)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($featuretext2) && mb_strlen($featuretext2) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($featuretext2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($featuretext2) && mb_strlen($featuretext2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($featuretext2)), __LINE__);
        }
        $this->featuretext2 = $featuretext2;
        return $this;
    }
    /**
     * Get competitor value
     * @return string|null
     */
    public function getCompetitor()
    {
        return $this->competitor;
    }
    /**
     * Set competitor value
     * @param string $competitor
     * @return \StructType\SALESPOTENTIAL
     */
    public function setCompetitor($competitor = null)
    {
        // validation for constraint: string
        if (!is_null($competitor) && !is_string($competitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($competitor, true), gettype($competitor)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($competitor) && mb_strlen($competitor) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($competitor)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($competitor) && mb_strlen($competitor) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($competitor)), __LINE__);
        }
        $this->competitor = $competitor;
        return $this;
    }
    /**
     * Get competitortext value
     * @return string|null
     */
    public function getCompetitortext()
    {
        return $this->competitortext;
    }
    /**
     * Set competitortext value
     * @param string $competitortext
     * @return \StructType\SALESPOTENTIAL
     */
    public function setCompetitortext($competitortext = null)
    {
        // validation for constraint: string
        if (!is_null($competitortext) && !is_string($competitortext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($competitortext, true), gettype($competitortext)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($competitortext) && mb_strlen($competitortext) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($competitortext)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($competitortext) && mb_strlen($competitortext) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($competitortext)), __LINE__);
        }
        $this->competitortext = $competitortext;
        return $this;
    }
    /**
     * Get specialrequest value
     * @return string|null
     */
    public function getSpecialrequest()
    {
        return $this->specialrequest;
    }
    /**
     * Set specialrequest value
     * @param string $specialrequest
     * @return \StructType\SALESPOTENTIAL
     */
    public function setSpecialrequest($specialrequest = null)
    {
        // validation for constraint: string
        if (!is_null($specialrequest) && !is_string($specialrequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialrequest, true), gettype($specialrequest)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($specialrequest) && mb_strlen($specialrequest) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($specialrequest)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($specialrequest) && mb_strlen($specialrequest) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($specialrequest)), __LINE__);
        }
        $this->specialrequest = $specialrequest;
        return $this;
    }
    /**
     * Get specialrequesttext value
     * @return string|null
     */
    public function getSpecialrequesttext()
    {
        return $this->specialrequesttext;
    }
    /**
     * Set specialrequesttext value
     * @param string $specialrequesttext
     * @return \StructType\SALESPOTENTIAL
     */
    public function setSpecialrequesttext($specialrequesttext = null)
    {
        // validation for constraint: string
        if (!is_null($specialrequesttext) && !is_string($specialrequesttext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialrequesttext, true), gettype($specialrequesttext)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($specialrequesttext) && mb_strlen($specialrequesttext) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($specialrequesttext)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($specialrequesttext) && mb_strlen($specialrequesttext) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($specialrequesttext)), __LINE__);
        }
        $this->specialrequesttext = $specialrequesttext;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\SALESPOTENTIAL
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get GUEST value
     * @return \StructType\GUEST[]|null
     */
    public function getGUEST()
    {
        return $this->GUEST;
    }
    /**
     * This method is responsible for validating the values passed to the setGUEST method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUEST method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTForArrayConstraintsFromSetGUEST(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sALESPOTENTIALGUESTItem) {
            // validation for constraint: itemType
            if (!$sALESPOTENTIALGUESTItem instanceof \StructType\GUEST) {
                $invalidValues[] = is_object($sALESPOTENTIALGUESTItem) ? get_class($sALESPOTENTIALGUESTItem) : sprintf('%s(%s)', gettype($sALESPOTENTIALGUESTItem), var_export($sALESPOTENTIALGUESTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST[] $gUEST
     * @return \StructType\SALESPOTENTIAL
     */
    public function setGUEST(array $gUEST = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTArrayErrorMessage = self::validateGUESTForArrayConstraintsFromSetGUEST($gUEST))) {
            throw new \InvalidArgumentException($gUESTArrayErrorMessage, __LINE__);
        }
        $this->GUEST = $gUEST;
        return $this;
    }
    /**
     * Add item to GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST $item
     * @return \StructType\SALESPOTENTIAL
     */
    public function addToGUEST(\StructType\GUEST $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUEST) {
            throw new \InvalidArgumentException(sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUEST[] = $item;
        return $this;
    }
    /**
     * Get maxnoofrooms value
     * @return string|null
     */
    public function getMaxnoofrooms()
    {
        return $this->maxnoofrooms;
    }
    /**
     * Set maxnoofrooms value
     * @param string $maxnoofrooms
     * @return \StructType\SALESPOTENTIAL
     */
    public function setMaxnoofrooms($maxnoofrooms = null)
    {
        // validation for constraint: string
        if (!is_null($maxnoofrooms) && !is_string($maxnoofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxnoofrooms, true), gettype($maxnoofrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($maxnoofrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $maxnoofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($maxnoofrooms, true)), __LINE__);
        }
        $this->maxnoofrooms = $maxnoofrooms;
        return $this;
    }
}
