<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for room StructType
 * @subpackage Structs
 */
class Room_1 extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The subno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $subno;
    /**
     * The centralid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $centralid;
    /**
     * The gdsresnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $gdsresnumber;
    /**
     * The paymentinstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentinstructions;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The noofnights
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofnights;
    /**
     * The ROOMINGLIST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMINGLIST_OBJID;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The person
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Person_1[]
     */
    public $person;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Person[]
     */
    public $Person;
    /**
     * The roomState
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomState[]
     */
    public $roomState;
    /**
     * Constructor method for room
     * @uses Room_1::setRESERVATION_OBJID()
     * @uses Room_1::setHotel()
     * @uses Room_1::setResno()
     * @uses Room_1::setSubno()
     * @uses Room_1::setCentralid()
     * @uses Room_1::setGdsresnumber()
     * @uses Room_1::setPaymentinstructions()
     * @uses Room_1::setCategory()
     * @uses Room_1::setDatefrom()
     * @uses Room_1::setDateto()
     * @uses Room_1::setNoofpax()
     * @uses Room_1::setNoofnights()
     * @uses Room_1::setROOMINGLIST_OBJID()
     * @uses Room_1::setRoom()
     * @uses Room_1::setPersoo()
     * @uses Room_1::setPerson_persoo()
     * @uses Room_1::setRoomState()
     * @param string $rESERVATION_OBJID
     * @param string $hotel
     * @param string $resno
     * @param string $subno
     * @param string $centralid
     * @param string $gdsresnumber
     * @param string $paymentinstructions
     * @param string $category
     * @param string $datefrom
     * @param string $dateto
     * @param string $noofpax
     * @param string $noofnights
     * @param string $rOOMINGLIST_OBJID
     * @param string $room
     * @param \StructType\Person_1[] $person
     * @param \StructType\Person[] $person
     * @param \StructType\RoomState[] $roomState
     */
    public function __construct($rESERVATION_OBJID = null, $hotel = null, $resno = null, $subno = null, $centralid = null, $gdsresnumber = null, $paymentinstructions = null, $category = null, $datefrom = null, $dateto = null, $noofpax = null, $noofnights = null, $rOOMINGLIST_OBJID = null, $room = null, array $person = array(), array $person_persoo = array(), array $roomState = array())
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setHotel($hotel)
            ->setResno($resno)
            ->setSubno($subno)
            ->setCentralid($centralid)
            ->setGdsresnumber($gdsresnumber)
            ->setPaymentinstructions($paymentinstructions)
            ->setCategory($category)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setNoofpax($noofpax)
            ->setNoofnights($noofnights)
            ->setROOMINGLIST_OBJID($rOOMINGLIST_OBJID)
            ->setRoom($room)
            ->setPerson($persoo)
            ->setPerson_persoo($person_persoo)
            ->setRoomState($roomState);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\Room_1
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\Room_1
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\Room_1
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get subno value
     * @return string
     */
    public function getSubno()
    {
        return $this->subno;
    }
    /**
     * Set subno value
     * @param string $subno
     * @return \StructType\Room_1
     */
    public function setSubno($subno = null)
    {
        // validation for constraint: string
        if (!is_null($subno) && !is_string($subno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subno, true), gettype($subno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($subno) && !preg_match('/([-+]){0,1}([0-9])*/', $subno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($subno, true)), __LINE__);
        }
        $this->subno = $subno;
        return $this;
    }
    /**
     * Get centralid value
     * @return string
     */
    public function getCentralid()
    {
        return $this->centralid;
    }
    /**
     * Set centralid value
     * @param string $centralid
     * @return \StructType\Room_1
     */
    public function setCentralid($centralid = null)
    {
        // validation for constraint: string
        if (!is_null($centralid) && !is_string($centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralid, true), gettype($centralid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($centralid) && !preg_match('/([0-9])*/', $centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($centralid, true)), __LINE__);
        }
        $this->centralid = $centralid;
        return $this;
    }
    /**
     * Get gdsresnumber value
     * @return string
     */
    public function getGdsresnumber()
    {
        return $this->gdsresnumber;
    }
    /**
     * Set gdsresnumber value
     * @param string $gdsresnumber
     * @return \StructType\Room_1
     */
    public function setGdsresnumber($gdsresnumber = null)
    {
        // validation for constraint: string
        if (!is_null($gdsresnumber) && !is_string($gdsresnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gdsresnumber, true), gettype($gdsresnumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($gdsresnumber) && mb_strlen($gdsresnumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($gdsresnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($gdsresnumber) && mb_strlen($gdsresnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($gdsresnumber)), __LINE__);
        }
        $this->gdsresnumber = $gdsresnumber;
        return $this;
    }
    /**
     * Get paymentinstructions value
     * @return string
     */
    public function getPaymentinstructions()
    {
        return $this->paymentinstructions;
    }
    /**
     * Set paymentinstructions value
     * @param string $paymentinstructions
     * @return \StructType\Room_1
     */
    public function setPaymentinstructions($paymentinstructions = null)
    {
        // validation for constraint: string
        if (!is_null($paymentinstructions) && !is_string($paymentinstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentinstructions, true), gettype($paymentinstructions)), __LINE__);
        }
        $this->paymentinstructions = $paymentinstructions;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\Room_1
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\Room_1
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\Room_1
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\Room_1
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get noofnights value
     * @return string
     */
    public function getNoofnights()
    {
        return $this->noofnights;
    }
    /**
     * Set noofnights value
     * @param string $noofnights
     * @return \StructType\Room_1
     */
    public function setNoofnights($noofnights = null)
    {
        // validation for constraint: string
        if (!is_null($noofnights) && !is_string($noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofnights, true), gettype($noofnights)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofnights) && !preg_match('/([-+]){0,1}([0-9])*/', $noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofnights, true)), __LINE__);
        }
        $this->noofnights = $noofnights;
        return $this;
    }
    /**
     * Get ROOMINGLIST_OBJID value
     * @return string
     */
    public function getROOMINGLIST_OBJID()
    {
        return $this->{'ROOMINGLIST-OBJID'};
    }
    /**
     * Set ROOMINGLIST_OBJID value
     * @param string $rOOMINGLIST_OBJID
     * @return \StructType\Room_1
     */
    public function setROOMINGLIST_OBJID($rOOMINGLIST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMINGLIST_OBJID) && !is_string($rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMINGLIST_OBJID, true), gettype($rOOMINGLIST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMINGLIST_OBJID) && !preg_match('/([0-9])*/', $rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMINGLIST_OBJID, true)), __LINE__);
        }
        $this->ROOMINGLIST_OBJID = $this->{'ROOMINGLIST-OBJID'} = $rOOMINGLIST_OBJID;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\Room_1
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person[]|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * This method is responsible for validating the values passed to the setPersoo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersoo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersooForArrayConstraintsFromSetPersoo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomPersonItem) {
            // validation for constraint: itemType
            if (!$roomPersonItem instanceof \StructType\Person_1) {
                $invalidValues[] = is_object($roomPersonItem) ? get_class($roomPersonItem) : sprintf('%s(%s)', gettype($roomPersonItem), var_export($roomPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The person property can only contain items of type \StructType\Person_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set persoo value
     * @param persoo $persoo
     * @return \StructType\Room_1
     */
    public function setPersoo(array $persoo = array())
    {
        // validation for constraint: array
        if ('' !== ($persooArrayErrorMessage = self::validatePersooForArrayConstraintsFromSetPersoo($persoo))) {
            throw new \InvalidArgumentException($persooArrayErrorMessage, __LINE__);
        }
        $this->person = $persoo;
        return $this;
    }
    /**
     * Add item to Person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person $item
     * @return \StructType\Room_1
     */
    public function addToPerson(\StructType\Person $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Person) {
            throw new \InvalidArgumentException(sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Person[] = $item;
        return $this;
    }
    /**
     * Get person_persoo value
     * @return person_persoo
     */
    public function getPerson_persoo()
    {
        return $this->Person;
    }
    /**
     * This method is responsible for validating the values passed to the setPerson_persoo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPerson_persoo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePerson_persooForArrayConstraintsFromSetPerson_persoo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomPersonItem) {
            // validation for constraint: itemType
            if (!$roomPersonItem instanceof \StructType\Person) {
                $invalidValues[] = is_object($roomPersonItem) ? get_class($roomPersonItem) : sprintf('%s(%s)', gettype($roomPersonItem), var_export($roomPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set person_persoo value
     * @param person_persoo $person_persoo
     * @return \StructType\Room_1
     */
    public function setPerson_persoo(array $person_persoo = array())
    {
        // validation for constraint: array
        if ('' !== ($person_persooArrayErrorMessage = self::validatePerson_persooForArrayConstraintsFromSetPerson_persoo($person_persoo))) {
            throw new \InvalidArgumentException($person_persooArrayErrorMessage, __LINE__);
        }
        $this->Person = $person_persoo;
        return $this;
    }
    /**
     * Get roomState value
     * @return \StructType\RoomState[]|null
     */
    public function getRoomState()
    {
        return $this->roomState;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomStateForArrayConstraintsFromSetRoomState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRoomStateItem) {
            // validation for constraint: itemType
            if (!$roomRoomStateItem instanceof \StructType\RoomState) {
                $invalidValues[] = is_object($roomRoomStateItem) ? get_class($roomRoomStateItem) : sprintf('%s(%s)', gettype($roomRoomStateItem), var_export($roomRoomStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The roomState property can only contain items of type \StructType\RoomState, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set roomState value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomState[] $roomState
     * @return \StructType\Room_1
     */
    public function setRoomState(array $roomState = array())
    {
        // validation for constraint: array
        if ('' !== ($roomStateArrayErrorMessage = self::validateRoomStateForArrayConstraintsFromSetRoomState($roomState))) {
            throw new \InvalidArgumentException($roomStateArrayErrorMessage, __LINE__);
        }
        $this->roomState = $roomState;
        return $this;
    }
    /**
     * Add item to roomState value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomState $item
     * @return \StructType\Room_1
     */
    public function addToRoomState(\StructType\RoomState $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomState) {
            throw new \InvalidArgumentException(sprintf('The roomState property can only contain items of type \StructType\RoomState, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->roomState[] = $item;
        return $this;
    }
}
