<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomSateModifyData StructType
 * @subpackage Structs
 */
class RoomSateModifyData extends AbstractStructBase
{
    /**
     * The housekeeping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $housekeeping;
    /**
     * The maintenance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maintenance;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $priority;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for RoomSateModifyData
     * @uses RoomSateModifyData::setHousekeeping()
     * @uses RoomSateModifyData::setMaintenance()
     * @uses RoomSateModifyData::setPriority()
     * @uses RoomSateModifyData::setComment()
     * @param string $housekeeping
     * @param string $maintenance
     * @param string $priority
     * @param string $comment
     */
    public function __construct($housekeeping = null, $maintenance = null, $priority = null, $comment = null)
    {
        $this
            ->setHousekeeping($housekeeping)
            ->setMaintenance($maintenance)
            ->setPriority($priority)
            ->setComment($comment);
    }
    /**
     * Get housekeeping value
     * @return string|null
     */
    public function getHousekeeping()
    {
        return $this->housekeeping;
    }
    /**
     * Set housekeeping value
     * @param string $housekeeping
     * @return \StructType\RoomSateModifyData
     */
    public function setHousekeeping($housekeeping = null)
    {
        // validation for constraint: string
        if (!is_null($housekeeping) && !is_string($housekeeping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeeping, true), gettype($housekeeping)), __LINE__);
        }
        $this->housekeeping = $housekeeping;
        return $this;
    }
    /**
     * Get maintenance value
     * @return string|null
     */
    public function getMaintenance()
    {
        return $this->maintenance;
    }
    /**
     * Set maintenance value
     * @param string $maintenance
     * @return \StructType\RoomSateModifyData
     */
    public function setMaintenance($maintenance = null)
    {
        // validation for constraint: string
        if (!is_null($maintenance) && !is_string($maintenance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenance, true), gettype($maintenance)), __LINE__);
        }
        $this->maintenance = $maintenance;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param string $priority
     * @return \StructType\RoomSateModifyData
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($priority) && !preg_match('/([-+]){0,1}([0-9])*/', $priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($priority, true)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\RoomSateModifyData
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
