<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomOject StructType
 * @subpackage Structs
 */
class RoomOject extends AbstractStructBase
{
    /**
     * The room_number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room_number;
    /**
     * The cleaning_status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cleaning_status;
    /**
     * Constructor method for RoomOject
     * @uses RoomOject::setRoom_number()
     * @uses RoomOject::setCleaning_status()
     * @param string $room_number
     * @param string $cleaning_status
     */
    public function __construct($room_number = null, $cleaning_status = null)
    {
        $this
            ->setRoom_number($room_number)
            ->setCleaning_status($cleaning_status);
    }
    /**
     * Get room_number value
     * @return string
     */
    public function getRoom_number()
    {
        return $this->room_number;
    }
    /**
     * Set room_number value
     * @param string $room_number
     * @return \StructType\RoomOject
     */
    public function setRoom_number($room_number = null)
    {
        // validation for constraint: string
        if (!is_null($room_number) && !is_string($room_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room_number, true), gettype($room_number)), __LINE__);
        }
        $this->room_number = $room_number;
        return $this;
    }
    /**
     * Get cleaning_status value
     * @return string
     */
    public function getCleaning_status()
    {
        return $this->cleaning_status;
    }
    /**
     * Set cleaning_status value
     * @param string $cleaning_status
     * @return \StructType\RoomOject
     */
    public function setCleaning_status($cleaning_status = null)
    {
        // validation for constraint: string
        if (!is_null($cleaning_status) && !is_string($cleaning_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cleaning_status, true), gettype($cleaning_status)), __LINE__);
        }
        $this->cleaning_status = $cleaning_status;
        return $this;
    }
}
