<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomAdd StructType
 * @subpackage Structs
 */
class RoomAdd extends AbstractStructBase
{
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The noofrooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofrooms;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratecategory;
    /**
     * Constructor method for RoomAdd
     * @uses RoomAdd::setCategory()
     * @uses RoomAdd::setNoofpax()
     * @uses RoomAdd::setNoofrooms()
     * @uses RoomAdd::setRatecategory()
     * @param string $category
     * @param string $noofpax
     * @param string $noofrooms
     * @param string $ratecategory
     */
    public function __construct($category = null, $noofpax = null, $noofrooms = null, $ratecategory = null)
    {
        $this
            ->setCategory($category)
            ->setNoofpax($noofpax)
            ->setNoofrooms($noofrooms)
            ->setRatecategory($ratecategory);
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\RoomAdd
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\RoomAdd
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get noofrooms value
     * @return string
     */
    public function getNoofrooms()
    {
        return $this->noofrooms;
    }
    /**
     * Set noofrooms value
     * @param string $noofrooms
     * @return \StructType\RoomAdd
     */
    public function setNoofrooms($noofrooms = null)
    {
        // validation for constraint: string
        if (!is_null($noofrooms) && !is_string($noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofrooms, true), gettype($noofrooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofrooms) && !preg_match('/([-+]){0,1}([0-9])*/', $noofrooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofrooms, true)), __LINE__);
        }
        $this->noofrooms = $noofrooms;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string|null
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\RoomAdd
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
}
