<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Room StructType
 * @subpackage Structs
 */
class Room extends AbstractStructBase
{
    /**
     * The roomNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $roomNumber;
    /**
     * The ROOM_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOM_OBJID;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The roomlocation
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $roomlocation;
    /**
     * The floor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $floor;
    /**
     * The changesupplies
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $changesupplies;
    /**
     * The maintenance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $maintenance;
    /**
     * The heatingstatus
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $heatingstatus;
    /**
     * The feature1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $feature1;
    /**
     * The feature2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $feature2;
    /**
     * The feature3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $feature3;
    /**
     * The ROOMINGLIST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMINGLIST_OBJID;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The noofpax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofpax;
    /**
     * The noofchildren
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofchildren;
    /**
     * The noofadults
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofadults;
    /**
     * The noofnights
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $noofnights;
    /**
     * The RoomSateModifyData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomSateModifyData
     */
    public $RoomSateModifyData;
    /**
     * The housekeeping
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $housekeeping;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Person[]
     */
    public $Person;
    /**
     * The RoomHousekeepingStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomHousekeepingStatus[]
     */
    public $RoomHousekeepingStatus;
    /**
     * The RoomMaintenanceStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomMaintenanceStatus[]
     */
    public $RoomMaintenanceStatus;
    /**
     * The maintenancestatusfrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $maintenancestatusfrom;
    /**
     * Constructor method for Room
     * @uses Room::setRoomNumber()
     * @uses Room::setROOM_OBJID()
     * @uses Room::setRoom()
     * @uses Room::setRoomlocation()
     * @uses Room::setFloor()
     * @uses Room::setChangesupplies()
     * @uses Room::setMaintenance()
     * @uses Room::setHeatingstatus()
     * @uses Room::setFeature1()
     * @uses Room::setFeature2()
     * @uses Room::setFeature3()
     * @uses Room::setROOMINGLIST_OBJID()
     * @uses Room::setCategory()
     * @uses Room::setDatefrom()
     * @uses Room::setDateto()
     * @uses Room::setNoofpax()
     * @uses Room::setNoofchildren()
     * @uses Room::setNoofadults()
     * @uses Room::setNoofnights()
     * @uses Room::setRoomSateModifyData()
     * @uses Room::setHousekeeping()
     * @uses Room::setPerson()
     * @uses Room::setRoomHousekeepingStatus()
     * @uses Room::setRoomMaintenanceStatus()
     * @uses Room::setMaintenancestatusfrom()
     * @param string $roomNumber
     * @param string $rOOM_OBJID
     * @param string $room
     * @param string $roomlocation
     * @param string $floor
     * @param string $changesupplies
     * @param string $maintenance
     * @param string $heatingstatus
     * @param string $feature1
     * @param string $feature2
     * @param string $feature3
     * @param string $rOOMINGLIST_OBJID
     * @param string $category
     * @param string $datefrom
     * @param string $dateto
     * @param string $noofpax
     * @param string $noofchildren
     * @param string $noofadults
     * @param string $noofnights
     * @param \StructType\RoomSateModifyData $roomSateModifyData
     * @param string $housekeeping
     * @param \StructType\Person[] $person
     * @param \StructType\RoomHousekeepingStatus[] $roomHousekeepingStatus
     * @param \StructType\RoomMaintenanceStatus[] $roomMaintenanceStatus
     * @param string $maintenancestatusfrom
     */
    public function __construct($roomNumber = null, $rOOM_OBJID = null, $room = null, $roomlocation = null, $floor = null, $changesupplies = null, $maintenance = null, $heatingstatus = null, $feature1 = null, $feature2 = null, $feature3 = null, $rOOMINGLIST_OBJID = null, $category = null, $datefrom = null, $dateto = null, $noofpax = null, $noofchildren = null, $noofadults = null, $noofnights = null, \StructType\RoomSateModifyData $roomSateModifyData = null, $housekeeping = null, array $person = array(), array $roomHousekeepingStatus = array(), array $roomMaintenanceStatus = array(), $maintenancestatusfrom = null)
    {
        $this
            ->setRoomNumber($roomNumber)
            ->setROOM_OBJID($rOOM_OBJID)
            ->setRoom($room)
            ->setRoomlocation($roomlocation)
            ->setFloor($floor)
            ->setChangesupplies($changesupplies)
            ->setMaintenance($maintenance)
            ->setHeatingstatus($heatingstatus)
            ->setFeature1($feature1)
            ->setFeature2($feature2)
            ->setFeature3($feature3)
            ->setROOMINGLIST_OBJID($rOOMINGLIST_OBJID)
            ->setCategory($category)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setNoofpax($noofpax)
            ->setNoofchildren($noofchildren)
            ->setNoofadults($noofadults)
            ->setNoofnights($noofnights)
            ->setRoomSateModifyData($roomSateModifyData)
            ->setHousekeeping($housekeeping)
            ->setPerson($person)
            ->setRoomHousekeepingStatus($roomHousekeepingStatus)
            ->setRoomMaintenanceStatus($roomMaintenanceStatus)
            ->setMaintenancestatusfrom($maintenancestatusfrom);
    }
    /**
     * Get roomNumber value
     * @return string
     */
    public function getRoomNumber()
    {
        return $this->roomNumber;
    }
    /**
     * Set roomNumber value
     * @param string $roomNumber
     * @return \StructType\Room
     */
    public function setRoomNumber($roomNumber = null)
    {
        // validation for constraint: string
        if (!is_null($roomNumber) && !is_string($roomNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomNumber, true), gettype($roomNumber)), __LINE__);
        }
        $this->roomNumber = $roomNumber;
        return $this;
    }
    /**
     * Get ROOM_OBJID value
     * @return string
     */
    public function getROOM_OBJID()
    {
        return $this->{'ROOM-OBJID'};
    }
    /**
     * Set ROOM_OBJID value
     * @param string $rOOM_OBJID
     * @return \StructType\Room
     */
    public function setROOM_OBJID($rOOM_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOM_OBJID) && !is_string($rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOM_OBJID, true), gettype($rOOM_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOM_OBJID) && !preg_match('/([0-9])*/', $rOOM_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOM_OBJID, true)), __LINE__);
        }
        $this->ROOM_OBJID = $this->{'ROOM-OBJID'} = $rOOM_OBJID;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\Room
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get roomlocation value
     * @return string
     */
    public function getRoomlocation()
    {
        return $this->roomlocation;
    }
    /**
     * Set roomlocation value
     * @param string $roomlocation
     * @return \StructType\Room
     */
    public function setRoomlocation($roomlocation = null)
    {
        // validation for constraint: string
        if (!is_null($roomlocation) && !is_string($roomlocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomlocation, true), gettype($roomlocation)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($roomlocation) && mb_strlen($roomlocation) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($roomlocation)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($roomlocation) && mb_strlen($roomlocation) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($roomlocation)), __LINE__);
        }
        $this->roomlocation = $roomlocation;
        return $this;
    }
    /**
     * Get floor value
     * @return string
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \StructType\Room
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($floor) && mb_strlen($floor) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($floor)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($floor) && mb_strlen($floor) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get changesupplies value
     * @return string
     */
    public function getChangesupplies()
    {
        return $this->changesupplies;
    }
    /**
     * Set changesupplies value
     * @param string $changesupplies
     * @return \StructType\Room
     */
    public function setChangesupplies($changesupplies = null)
    {
        // validation for constraint: string
        if (!is_null($changesupplies) && !is_string($changesupplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changesupplies, true), gettype($changesupplies)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($changesupplies) && mb_strlen($changesupplies) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($changesupplies)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($changesupplies) && mb_strlen($changesupplies) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($changesupplies)), __LINE__);
        }
        $this->changesupplies = $changesupplies;
        return $this;
    }
    /**
     * Get maintenance value
     * @return string
     */
    public function getMaintenance()
    {
        return $this->maintenance;
    }
    /**
     * Set maintenance value
     * @param string $maintenance
     * @return \StructType\Room
     */
    public function setMaintenance($maintenance = null)
    {
        // validation for constraint: string
        if (!is_null($maintenance) && !is_string($maintenance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenance, true), gettype($maintenance)), __LINE__);
        }
        $this->maintenance = $maintenance;
        return $this;
    }
    /**
     * Get heatingstatus value
     * @return string
     */
    public function getHeatingstatus()
    {
        return $this->heatingstatus;
    }
    /**
     * Set heatingstatus value
     * @param string $heatingstatus
     * @return \StructType\Room
     */
    public function setHeatingstatus($heatingstatus = null)
    {
        // validation for constraint: string
        if (!is_null($heatingstatus) && !is_string($heatingstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($heatingstatus, true), gettype($heatingstatus)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($heatingstatus) && mb_strlen($heatingstatus) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($heatingstatus)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($heatingstatus) && mb_strlen($heatingstatus) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($heatingstatus)), __LINE__);
        }
        $this->heatingstatus = $heatingstatus;
        return $this;
    }
    /**
     * Get feature1 value
     * @return string
     */
    public function getFeature1()
    {
        return $this->feature1;
    }
    /**
     * Set feature1 value
     * @param string $feature1
     * @return \StructType\Room
     */
    public function setFeature1($feature1 = null)
    {
        // validation for constraint: string
        if (!is_null($feature1) && !is_string($feature1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature1, true), gettype($feature1)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($feature1) && mb_strlen($feature1) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($feature1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($feature1) && mb_strlen($feature1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($feature1)), __LINE__);
        }
        $this->feature1 = $feature1;
        return $this;
    }
    /**
     * Get feature2 value
     * @return string
     */
    public function getFeature2()
    {
        return $this->feature2;
    }
    /**
     * Set feature2 value
     * @param string $feature2
     * @return \StructType\Room
     */
    public function setFeature2($feature2 = null)
    {
        // validation for constraint: string
        if (!is_null($feature2) && !is_string($feature2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature2, true), gettype($feature2)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($feature2) && mb_strlen($feature2) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($feature2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($feature2) && mb_strlen($feature2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($feature2)), __LINE__);
        }
        $this->feature2 = $feature2;
        return $this;
    }
    /**
     * Get feature3 value
     * @return string
     */
    public function getFeature3()
    {
        return $this->feature3;
    }
    /**
     * Set feature3 value
     * @param string $feature3
     * @return \StructType\Room
     */
    public function setFeature3($feature3 = null)
    {
        // validation for constraint: string
        if (!is_null($feature3) && !is_string($feature3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature3, true), gettype($feature3)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($feature3) && mb_strlen($feature3) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($feature3)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($feature3) && mb_strlen($feature3) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($feature3)), __LINE__);
        }
        $this->feature3 = $feature3;
        return $this;
    }
    /**
     * Get ROOMINGLIST_OBJID value
     * @return string
     */
    public function getROOMINGLIST_OBJID()
    {
        return $this->{'ROOMINGLIST-OBJID'};
    }
    /**
     * Set ROOMINGLIST_OBJID value
     * @param string $rOOMINGLIST_OBJID
     * @return \StructType\Room
     */
    public function setROOMINGLIST_OBJID($rOOMINGLIST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMINGLIST_OBJID) && !is_string($rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMINGLIST_OBJID, true), gettype($rOOMINGLIST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMINGLIST_OBJID) && !preg_match('/([0-9])*/', $rOOMINGLIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMINGLIST_OBJID, true)), __LINE__);
        }
        $this->ROOMINGLIST_OBJID = $this->{'ROOMINGLIST-OBJID'} = $rOOMINGLIST_OBJID;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\Room
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($category) && mb_strlen($category) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($category)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($category) && mb_strlen($category) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\Room
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\Room
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get noofpax value
     * @return string
     */
    public function getNoofpax()
    {
        return $this->noofpax;
    }
    /**
     * Set noofpax value
     * @param string $noofpax
     * @return \StructType\Room
     */
    public function setNoofpax($noofpax = null)
    {
        // validation for constraint: string
        if (!is_null($noofpax) && !is_string($noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofpax, true), gettype($noofpax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofpax) && !preg_match('/([-+]){0,1}([0-9])*/', $noofpax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofpax, true)), __LINE__);
        }
        $this->noofpax = $noofpax;
        return $this;
    }
    /**
     * Get noofchildren value
     * @return string
     */
    public function getNoofchildren()
    {
        return $this->noofchildren;
    }
    /**
     * Set noofchildren value
     * @param string $noofchildren
     * @return \StructType\Room
     */
    public function setNoofchildren($noofchildren = null)
    {
        // validation for constraint: string
        if (!is_null($noofchildren) && !is_string($noofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofchildren, true), gettype($noofchildren)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofchildren) && !preg_match('/([-+]){0,1}([0-9])*/', $noofchildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofchildren, true)), __LINE__);
        }
        $this->noofchildren = $noofchildren;
        return $this;
    }
    /**
     * Get noofadults value
     * @return string
     */
    public function getNoofadults()
    {
        return $this->noofadults;
    }
    /**
     * Set noofadults value
     * @param string $noofadults
     * @return \StructType\Room
     */
    public function setNoofadults($noofadults = null)
    {
        // validation for constraint: string
        if (!is_null($noofadults) && !is_string($noofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofadults, true), gettype($noofadults)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofadults) && !preg_match('/([-+]){0,1}([0-9])*/', $noofadults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofadults, true)), __LINE__);
        }
        $this->noofadults = $noofadults;
        return $this;
    }
    /**
     * Get noofnights value
     * @return string
     */
    public function getNoofnights()
    {
        return $this->noofnights;
    }
    /**
     * Set noofnights value
     * @param string $noofnights
     * @return \StructType\Room
     */
    public function setNoofnights($noofnights = null)
    {
        // validation for constraint: string
        if (!is_null($noofnights) && !is_string($noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noofnights, true), gettype($noofnights)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($noofnights) && !preg_match('/([-+]){0,1}([0-9])*/', $noofnights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($noofnights, true)), __LINE__);
        }
        $this->noofnights = $noofnights;
        return $this;
    }
    /**
     * Get RoomSateModifyData value
     * @return \StructType\RoomSateModifyData
     */
    public function getRoomSateModifyData()
    {
        return $this->RoomSateModifyData;
    }
    /**
     * Set RoomSateModifyData value
     * @param \StructType\RoomSateModifyData $roomSateModifyData
     * @return \StructType\Room
     */
    public function setRoomSateModifyData(\StructType\RoomSateModifyData $roomSateModifyData = null)
    {
        $this->RoomSateModifyData = $roomSateModifyData;
        return $this;
    }
    /**
     * Get housekeeping value
     * @return string
     */
    public function getHousekeeping()
    {
        return $this->housekeeping;
    }
    /**
     * Set housekeeping value
     * @param string $housekeeping
     * @return \StructType\Room
     */
    public function setHousekeeping($housekeeping = null)
    {
        // validation for constraint: string
        if (!is_null($housekeeping) && !is_string($housekeeping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeeping, true), gettype($housekeeping)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($housekeeping) && mb_strlen($housekeeping) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($housekeeping)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($housekeeping) && mb_strlen($housekeeping) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($housekeeping)), __LINE__);
        }
        $this->housekeeping = $housekeeping;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person[]|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * This method is responsible for validating the values passed to the setPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonForArrayConstraintsFromSetPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomPersonItem) {
            // validation for constraint: itemType
            if (!$roomPersonItem instanceof \StructType\Person) {
                $invalidValues[] = is_object($roomPersonItem) ? get_class($roomPersonItem) : sprintf('%s(%s)', gettype($roomPersonItem), var_export($roomPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person[] $person
     * @return \StructType\Room
     */
    public function setPerson(array $person = array())
    {
        // validation for constraint: array
        if ('' !== ($personArrayErrorMessage = self::validatePersonForArrayConstraintsFromSetPerson($person))) {
            throw new \InvalidArgumentException($personArrayErrorMessage, __LINE__);
        }
        $this->Person = $person;
        return $this;
    }
    /**
     * Add item to Person value
     * @throws \InvalidArgumentException
     * @param \StructType\Person $item
     * @return \StructType\Room
     */
    public function addToPerson(\StructType\Person $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Person) {
            throw new \InvalidArgumentException(sprintf('The Person property can only contain items of type \StructType\Person, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Person[] = $item;
        return $this;
    }
    /**
     * Get RoomHousekeepingStatus value
     * @return \StructType\RoomHousekeepingStatus[]|null
     */
    public function getRoomHousekeepingStatus()
    {
        return $this->RoomHousekeepingStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomHousekeepingStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomHousekeepingStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomHousekeepingStatusForArrayConstraintsFromSetRoomHousekeepingStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRoomHousekeepingStatusItem) {
            // validation for constraint: itemType
            if (!$roomRoomHousekeepingStatusItem instanceof \StructType\RoomHousekeepingStatus) {
                $invalidValues[] = is_object($roomRoomHousekeepingStatusItem) ? get_class($roomRoomHousekeepingStatusItem) : sprintf('%s(%s)', gettype($roomRoomHousekeepingStatusItem), var_export($roomRoomHousekeepingStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomHousekeepingStatus property can only contain items of type \StructType\RoomHousekeepingStatus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomHousekeepingStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomHousekeepingStatus[] $roomHousekeepingStatus
     * @return \StructType\Room
     */
    public function setRoomHousekeepingStatus(array $roomHousekeepingStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($roomHousekeepingStatusArrayErrorMessage = self::validateRoomHousekeepingStatusForArrayConstraintsFromSetRoomHousekeepingStatus($roomHousekeepingStatus))) {
            throw new \InvalidArgumentException($roomHousekeepingStatusArrayErrorMessage, __LINE__);
        }
        $this->RoomHousekeepingStatus = $roomHousekeepingStatus;
        return $this;
    }
    /**
     * Add item to RoomHousekeepingStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomHousekeepingStatus $item
     * @return \StructType\Room
     */
    public function addToRoomHousekeepingStatus(\StructType\RoomHousekeepingStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomHousekeepingStatus) {
            throw new \InvalidArgumentException(sprintf('The RoomHousekeepingStatus property can only contain items of type \StructType\RoomHousekeepingStatus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomHousekeepingStatus[] = $item;
        return $this;
    }
    /**
     * Get RoomMaintenanceStatus value
     * @return \StructType\RoomMaintenanceStatus[]|null
     */
    public function getRoomMaintenanceStatus()
    {
        return $this->RoomMaintenanceStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomMaintenanceStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomMaintenanceStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomMaintenanceStatusForArrayConstraintsFromSetRoomMaintenanceStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRoomMaintenanceStatusItem) {
            // validation for constraint: itemType
            if (!$roomRoomMaintenanceStatusItem instanceof \StructType\RoomMaintenanceStatus) {
                $invalidValues[] = is_object($roomRoomMaintenanceStatusItem) ? get_class($roomRoomMaintenanceStatusItem) : sprintf('%s(%s)', gettype($roomRoomMaintenanceStatusItem), var_export($roomRoomMaintenanceStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomMaintenanceStatus property can only contain items of type \StructType\RoomMaintenanceStatus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomMaintenanceStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomMaintenanceStatus[] $roomMaintenanceStatus
     * @return \StructType\Room
     */
    public function setRoomMaintenanceStatus(array $roomMaintenanceStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($roomMaintenanceStatusArrayErrorMessage = self::validateRoomMaintenanceStatusForArrayConstraintsFromSetRoomMaintenanceStatus($roomMaintenanceStatus))) {
            throw new \InvalidArgumentException($roomMaintenanceStatusArrayErrorMessage, __LINE__);
        }
        $this->RoomMaintenanceStatus = $roomMaintenanceStatus;
        return $this;
    }
    /**
     * Add item to RoomMaintenanceStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomMaintenanceStatus $item
     * @return \StructType\Room
     */
    public function addToRoomMaintenanceStatus(\StructType\RoomMaintenanceStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomMaintenanceStatus) {
            throw new \InvalidArgumentException(sprintf('The RoomMaintenanceStatus property can only contain items of type \StructType\RoomMaintenanceStatus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomMaintenanceStatus[] = $item;
        return $this;
    }
    /**
     * Get maintenancestatusfrom value
     * @return string|null
     */
    public function getMaintenancestatusfrom()
    {
        return $this->maintenancestatusfrom;
    }
    /**
     * Set maintenancestatusfrom value
     * @param string $maintenancestatusfrom
     * @return \StructType\Room
     */
    public function setMaintenancestatusfrom($maintenancestatusfrom = null)
    {
        // validation for constraint: string
        if (!is_null($maintenancestatusfrom) && !is_string($maintenancestatusfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenancestatusfrom, true), gettype($maintenancestatusfrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($maintenancestatusfrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $maintenancestatusfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($maintenancestatusfrom, true)), __LINE__);
        }
        $this->maintenancestatusfrom = $maintenancestatusfrom;
        return $this;
    }
}
