<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResForecast StructType
 * @subpackage Structs
 */
class ResForecast extends AbstractStructBase
{
    /**
     * The RESERVATION_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_CENTRALID;
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The ReservationPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ReservationPackage[]
     */
    public $ReservationPackage;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Room[]
     */
    public $Room;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $total;
    /**
     * The DEPOSIT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DEPOSIT
     */
    public $DEPOSIT;
    /**
     * The FORECAST
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FORECAST
     */
    public $FORECAST;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratesegment;
    /**
     * Constructor method for ResForecast
     * @uses ResForecast::setRESERVATION_CENTRALID()
     * @uses ResForecast::setRESERVATION_OBJID()
     * @uses ResForecast::setArrival()
     * @uses ResForecast::setDeparture()
     * @uses ResForecast::setCategory()
     * @uses ResForecast::setRatecategory()
     * @uses ResForecast::setReservationPackage()
     * @uses ResForecast::setRoom()
     * @uses ResForecast::setTotal()
     * @uses ResForecast::setDEPOSIT()
     * @uses ResForecast::setFORECAST()
     * @uses ResForecast::setRatesegment()
     * @param string $rESERVATION_CENTRALID
     * @param string $rESERVATION_OBJID
     * @param string $arrival
     * @param string $departure
     * @param string $category
     * @param string $ratecategory
     * @param \StructType\ReservationPackage[] $reservationPackage
     * @param \StructType\Room[] $room
     * @param string $total
     * @param \StructType\DEPOSIT $dEPOSIT
     * @param \StructType\FORECAST $fORECAST
     * @param string $ratesegment
     */
    public function __construct($rESERVATION_CENTRALID = null, $rESERVATION_OBJID = null, $arrival = null, $departure = null, $category = null, $ratecategory = null, array $reservationPackage = array(), array $room = array(), $total = null, \StructType\DEPOSIT $dEPOSIT = null, \StructType\FORECAST $fORECAST = null, $ratesegment = null)
    {
        $this
            ->setRESERVATION_CENTRALID($rESERVATION_CENTRALID)
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setCategory($category)
            ->setRatecategory($ratecategory)
            ->setReservationPackage($reservationPackage)
            ->setRoom($room)
            ->setTotal($total)
            ->setDEPOSIT($dEPOSIT)
            ->setFORECAST($fORECAST)
            ->setRatesegment($ratesegment);
    }
    /**
     * Get RESERVATION_CENTRALID value
     * @return string
     */
    public function getRESERVATION_CENTRALID()
    {
        return $this->{'RESERVATION-CENTRALID'};
    }
    /**
     * Set RESERVATION_CENTRALID value
     * @param string $rESERVATION_CENTRALID
     * @return \StructType\ResForecast
     */
    public function setRESERVATION_CENTRALID($rESERVATION_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_CENTRALID) && !is_string($rESERVATION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_CENTRALID, true), gettype($rESERVATION_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_CENTRALID) && !preg_match('/([0-9])*/', $rESERVATION_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_CENTRALID, true)), __LINE__);
        }
        $this->RESERVATION_CENTRALID = $this->{'RESERVATION-CENTRALID'} = $rESERVATION_CENTRALID;
        return $this;
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\ResForecast
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\ResForecast
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\ResForecast
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ResForecast
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\ResForecast
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get ReservationPackage value
     * @return \StructType\ReservationPackage[]
     */
    public function getReservationPackage()
    {
        return $this->ReservationPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setReservationPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservationPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationPackageForArrayConstraintsFromSetReservationPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resForecastReservationPackageItem) {
            // validation for constraint: itemType
            if (!$resForecastReservationPackageItem instanceof \StructType\ReservationPackage) {
                $invalidValues[] = is_object($resForecastReservationPackageItem) ? get_class($resForecastReservationPackageItem) : sprintf('%s(%s)', gettype($resForecastReservationPackageItem), var_export($resForecastReservationPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReservationPackage property can only contain items of type \StructType\ReservationPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReservationPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\ReservationPackage[] $reservationPackage
     * @return \StructType\ResForecast
     */
    public function setReservationPackage(array $reservationPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationPackageArrayErrorMessage = self::validateReservationPackageForArrayConstraintsFromSetReservationPackage($reservationPackage))) {
            throw new \InvalidArgumentException($reservationPackageArrayErrorMessage, __LINE__);
        }
        $this->ReservationPackage = $reservationPackage;
        return $this;
    }
    /**
     * Add item to ReservationPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\ReservationPackage $item
     * @return \StructType\ResForecast
     */
    public function addToReservationPackage(\StructType\ReservationPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReservationPackage) {
            throw new \InvalidArgumentException(sprintf('The ReservationPackage property can only contain items of type \StructType\ReservationPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReservationPackage[] = $item;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room[]
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resForecastRoomItem) {
            // validation for constraint: itemType
            if (!$resForecastRoomItem instanceof \StructType\Room) {
                $invalidValues[] = is_object($resForecastRoomItem) ? get_class($resForecastRoomItem) : sprintf('%s(%s)', gettype($resForecastRoomItem), var_export($resForecastRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room[] $room
     * @return \StructType\ResForecast
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room $item
     * @return \StructType\ResForecast
     */
    public function addToRoom(\StructType\Room $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Room) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return string
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param string $total
     * @return \StructType\ResForecast
     */
    public function setTotal($total = null)
    {
        // validation for constraint: string
        if (!is_null($total) && !is_string($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($total) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($total, true)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get DEPOSIT value
     * @return \StructType\DEPOSIT
     */
    public function getDEPOSIT()
    {
        return $this->DEPOSIT;
    }
    /**
     * Set DEPOSIT value
     * @param \StructType\DEPOSIT $dEPOSIT
     * @return \StructType\ResForecast
     */
    public function setDEPOSIT(\StructType\DEPOSIT $dEPOSIT = null)
    {
        $this->DEPOSIT = $dEPOSIT;
        return $this;
    }
    /**
     * Get FORECAST value
     * @return \StructType\FORECAST
     */
    public function getFORECAST()
    {
        return $this->FORECAST;
    }
    /**
     * Set FORECAST value
     * @param \StructType\FORECAST $fORECAST
     * @return \StructType\ResForecast
     */
    public function setFORECAST(\StructType\FORECAST $fORECAST = null)
    {
        $this->FORECAST = $fORECAST;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string|null
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\ResForecast
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
}
