<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveActivity StructType
 * @subpackage Structs
 */
class RemoveActivity extends AbstractStructBase
{
    /**
     * The ACTIVITY_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACTIVITY_OBJID;
    /**
     * Constructor method for RemoveActivity
     * @uses RemoveActivity::setACTIVITY_OBJID()
     * @param string $aCTIVITY_OBJID
     */
    public function __construct($aCTIVITY_OBJID = null)
    {
        $this
            ->setACTIVITY_OBJID($aCTIVITY_OBJID);
    }
    /**
     * Get ACTIVITY_OBJID value
     * @return string
     */
    public function getACTIVITY_OBJID()
    {
        return $this->{'ACTIVITY-OBJID'};
    }
    /**
     * Set ACTIVITY_OBJID value
     * @param string $aCTIVITY_OBJID
     * @return \StructType\RemoveActivity
     */
    public function setACTIVITY_OBJID($aCTIVITY_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCTIVITY_OBJID) && !is_string($aCTIVITY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCTIVITY_OBJID, true), gettype($aCTIVITY_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCTIVITY_OBJID) && !preg_match('/([0-9])*/', $aCTIVITY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCTIVITY_OBJID, true)), __LINE__);
        }
        $this->ACTIVITY_OBJID = $this->{'ACTIVITY-OBJID'} = $aCTIVITY_OBJID;
        return $this;
    }
}
