<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rates StructType
 * @subpackage Structs
 */
class Rates extends AbstractStructBase
{
    /**
     * The StandardRateByCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StandardRateByCategory[]
     */
    public $StandardRateByCategory;
    /**
     * The SeasonalRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeasonalRate[]
     */
    public $SeasonalRate;
    /**
     * Constructor method for Rates
     * @uses Rates::setStandardRateByCategory()
     * @uses Rates::setSeasonalRate()
     * @param \StructType\StandardRateByCategory[] $standardRateByCategory
     * @param \StructType\SeasonalRate[] $seasonalRate
     */
    public function __construct(array $standardRateByCategory = array(), array $seasonalRate = array())
    {
        $this
            ->setStandardRateByCategory($standardRateByCategory)
            ->setSeasonalRate($seasonalRate);
    }
    /**
     * Get StandardRateByCategory value
     * @return \StructType\StandardRateByCategory[]|null
     */
    public function getStandardRateByCategory()
    {
        return $this->StandardRateByCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setStandardRateByCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandardRateByCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStandardRateByCategoryForArrayConstraintsFromSetStandardRateByCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratesStandardRateByCategoryItem) {
            // validation for constraint: itemType
            if (!$ratesStandardRateByCategoryItem instanceof \StructType\StandardRateByCategory) {
                $invalidValues[] = is_object($ratesStandardRateByCategoryItem) ? get_class($ratesStandardRateByCategoryItem) : sprintf('%s(%s)', gettype($ratesStandardRateByCategoryItem), var_export($ratesStandardRateByCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StandardRateByCategory property can only contain items of type \StructType\StandardRateByCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StandardRateByCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\StandardRateByCategory[] $standardRateByCategory
     * @return \StructType\Rates
     */
    public function setStandardRateByCategory(array $standardRateByCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($standardRateByCategoryArrayErrorMessage = self::validateStandardRateByCategoryForArrayConstraintsFromSetStandardRateByCategory($standardRateByCategory))) {
            throw new \InvalidArgumentException($standardRateByCategoryArrayErrorMessage, __LINE__);
        }
        $this->StandardRateByCategory = $standardRateByCategory;
        return $this;
    }
    /**
     * Add item to StandardRateByCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\StandardRateByCategory $item
     * @return \StructType\Rates
     */
    public function addToStandardRateByCategory(\StructType\StandardRateByCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StandardRateByCategory) {
            throw new \InvalidArgumentException(sprintf('The StandardRateByCategory property can only contain items of type \StructType\StandardRateByCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StandardRateByCategory[] = $item;
        return $this;
    }
    /**
     * Get SeasonalRate value
     * @return \StructType\SeasonalRate[]|null
     */
    public function getSeasonalRate()
    {
        return $this->SeasonalRate;
    }
    /**
     * This method is responsible for validating the values passed to the setSeasonalRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeasonalRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeasonalRateForArrayConstraintsFromSetSeasonalRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratesSeasonalRateItem) {
            // validation for constraint: itemType
            if (!$ratesSeasonalRateItem instanceof \StructType\SeasonalRate) {
                $invalidValues[] = is_object($ratesSeasonalRateItem) ? get_class($ratesSeasonalRateItem) : sprintf('%s(%s)', gettype($ratesSeasonalRateItem), var_export($ratesSeasonalRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeasonalRate property can only contain items of type \StructType\SeasonalRate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeasonalRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SeasonalRate[] $seasonalRate
     * @return \StructType\Rates
     */
    public function setSeasonalRate(array $seasonalRate = array())
    {
        // validation for constraint: array
        if ('' !== ($seasonalRateArrayErrorMessage = self::validateSeasonalRateForArrayConstraintsFromSetSeasonalRate($seasonalRate))) {
            throw new \InvalidArgumentException($seasonalRateArrayErrorMessage, __LINE__);
        }
        $this->SeasonalRate = $seasonalRate;
        return $this;
    }
    /**
     * Add item to SeasonalRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SeasonalRate $item
     * @return \StructType\Rates
     */
    public function addToSeasonalRate(\StructType\SeasonalRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeasonalRate) {
            throw new \InvalidArgumentException(sprintf('The SeasonalRate property can only contain items of type \StructType\SeasonalRate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeasonalRate[] = $item;
        return $this;
    }
}
