<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RESULTSET StructType
 * @subpackage Structs
 */
class RESULTSET extends AbstractStructBase
{
    /**
     * The scenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $scenario;
    /**
     * The starttime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $starttime;
    /**
     * The endtime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $endtime;
    /**
     * The milliseconds
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $milliseconds;
    /**
     * Constructor method for RESULTSET
     * @uses RESULTSET::setScenario()
     * @uses RESULTSET::setStarttime()
     * @uses RESULTSET::setEndtime()
     * @uses RESULTSET::setMilliseconds()
     * @param string $scenario
     * @param string $starttime
     * @param string $endtime
     * @param string $milliseconds
     */
    public function __construct($scenario = null, $starttime = null, $endtime = null, $milliseconds = null)
    {
        $this
            ->setScenario($scenario)
            ->setStarttime($starttime)
            ->setEndtime($endtime)
            ->setMilliseconds($milliseconds);
    }
    /**
     * Get scenario value
     * @return string
     */
    public function getScenario()
    {
        return $this->scenario;
    }
    /**
     * Set scenario value
     * @param string $scenario
     * @return \StructType\RESULTSET
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        $this->scenario = $scenario;
        return $this;
    }
    /**
     * Get starttime value
     * @return string
     */
    public function getStarttime()
    {
        return $this->starttime;
    }
    /**
     * Set starttime value
     * @param string $starttime
     * @return \StructType\RESULTSET
     */
    public function setStarttime($starttime = null)
    {
        // validation for constraint: string
        if (!is_null($starttime) && !is_string($starttime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($starttime, true), gettype($starttime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($starttime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $starttime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($starttime, true)), __LINE__);
        }
        $this->starttime = $starttime;
        return $this;
    }
    /**
     * Get endtime value
     * @return string
     */
    public function getEndtime()
    {
        return $this->endtime;
    }
    /**
     * Set endtime value
     * @param string $endtime
     * @return \StructType\RESULTSET
     */
    public function setEndtime($endtime = null)
    {
        // validation for constraint: string
        if (!is_null($endtime) && !is_string($endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endtime, true), gettype($endtime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($endtime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $endtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($endtime, true)), __LINE__);
        }
        $this->endtime = $endtime;
        return $this;
    }
    /**
     * Get milliseconds value
     * @return string
     */
    public function getMilliseconds()
    {
        return $this->milliseconds;
    }
    /**
     * Set milliseconds value
     * @param string $milliseconds
     * @return \StructType\RESULTSET
     */
    public function setMilliseconds($milliseconds = null)
    {
        // validation for constraint: string
        if (!is_null($milliseconds) && !is_string($milliseconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($milliseconds, true), gettype($milliseconds)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($milliseconds) && !preg_match('/([-+]){0,1}([0-9])*/', $milliseconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($milliseconds, true)), __LINE__);
        }
        $this->milliseconds = $milliseconds;
        return $this;
    }
}
