<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RESERVATIONSEARCH StructType
 * @subpackage Structs
 */
class RESERVATIONSEARCH_1 extends AbstractStructBase
{
    /**
     * The resnofrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resnofrom;
    /**
     * The resnoto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resnoto;
    /**
     * The gdsresnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gdsresnumber;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hotel;
    /**
     * The definitivetentative
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $definitivetentative;
    /**
     * Constructor method for RESERVATIONSEARCH
     * @uses RESERVATIONSEARCH_1::setResnofrom()
     * @uses RESERVATIONSEARCH_1::setResnoto()
     * @uses RESERVATIONSEARCH_1::setGdsresnumber()
     * @uses RESERVATIONSEARCH_1::setArrival()
     * @uses RESERVATIONSEARCH_1::setDeparture()
     * @uses RESERVATIONSEARCH_1::setHotel()
     * @uses RESERVATIONSEARCH_1::setDefinitivetentative()
     * @param string $resnofrom
     * @param string $resnoto
     * @param string $gdsresnumber
     * @param string $arrival
     * @param string $departure
     * @param string $hotel
     * @param string $definitivetentative
     */
    public function __construct($resnofrom = null, $resnoto = null, $gdsresnumber = null, $arrival = null, $departure = null, $hotel = null, $definitivetentative = null)
    {
        $this
            ->setResnofrom($resnofrom)
            ->setResnoto($resnoto)
            ->setGdsresnumber($gdsresnumber)
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setHotel($hotel)
            ->setDefinitivetentative($definitivetentative);
    }
    /**
     * Get resnofrom value
     * @return string|null
     */
    public function getResnofrom()
    {
        return $this->resnofrom;
    }
    /**
     * Set resnofrom value
     * @param string $resnofrom
     * @return \StructType\RESERVATIONSEARCH_1
     */
    public function setResnofrom($resnofrom = null)
    {
        // validation for constraint: string
        if (!is_null($resnofrom) && !is_string($resnofrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resnofrom, true), gettype($resnofrom)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resnofrom) && !preg_match('/([-+]){0,1}([0-9])*/', $resnofrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resnofrom, true)), __LINE__);
        }
        $this->resnofrom = $resnofrom;
        return $this;
    }
    /**
     * Get resnoto value
     * @return string|null
     */
    public function getResnoto()
    {
        return $this->resnoto;
    }
    /**
     * Set resnoto value
     * @param string $resnoto
     * @return \StructType\RESERVATIONSEARCH_1
     */
    public function setResnoto($resnoto = null)
    {
        // validation for constraint: string
        if (!is_null($resnoto) && !is_string($resnoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resnoto, true), gettype($resnoto)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resnoto) && !preg_match('/([-+]){0,1}([0-9])*/', $resnoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resnoto, true)), __LINE__);
        }
        $this->resnoto = $resnoto;
        return $this;
    }
    /**
     * Get gdsresnumber value
     * @return string|null
     */
    public function getGdsresnumber()
    {
        return $this->gdsresnumber;
    }
    /**
     * Set gdsresnumber value
     * @param string $gdsresnumber
     * @return \StructType\RESERVATIONSEARCH_1
     */
    public function setGdsresnumber($gdsresnumber = null)
    {
        // validation for constraint: string
        if (!is_null($gdsresnumber) && !is_string($gdsresnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gdsresnumber, true), gettype($gdsresnumber)), __LINE__);
        }
        $this->gdsresnumber = $gdsresnumber;
        return $this;
    }
    /**
     * Get arrival value
     * @return string|null
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\RESERVATIONSEARCH_1
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string|null
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\RESERVATIONSEARCH_1
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get hotel value
     * @return string|null
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\RESERVATIONSEARCH_1
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get definitivetentative value
     * @return string|null
     */
    public function getDefinitivetentative()
    {
        return $this->definitivetentative;
    }
    /**
     * Set definitivetentative value
     * @param string $definitivetentative
     * @return \StructType\RESERVATIONSEARCH_1
     */
    public function setDefinitivetentative($definitivetentative = null)
    {
        // validation for constraint: string
        if (!is_null($definitivetentative) && !is_string($definitivetentative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitivetentative, true), gettype($definitivetentative)), __LINE__);
        }
        $this->definitivetentative = $definitivetentative;
        return $this;
    }
}
