<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RESERVATIONPACKAGE StructType
 * @subpackage Structs
 */
class RESERVATIONPACKAGE_1 extends AbstractStructBase
{
    /**
     * The RESERVATIONPACKAGE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATIONPACKAGE_OBJID;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $quantity;
    /**
     * The priceperunit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $priceperunit;
    /**
     * The totalprice
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $totalprice;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * Constructor method for RESERVATIONPACKAGE
     * @uses RESERVATIONPACKAGE_1::setRESERVATIONPACKAGE_OBJID()
     * @uses RESERVATIONPACKAGE_1::setService()
     * @uses RESERVATIONPACKAGE_1::setDatefrom()
     * @uses RESERVATIONPACKAGE_1::setDateto()
     * @uses RESERVATIONPACKAGE_1::setQuantity()
     * @uses RESERVATIONPACKAGE_1::setPriceperunit()
     * @uses RESERVATIONPACKAGE_1::setTotalprice()
     * @uses RESERVATIONPACKAGE_1::setCurrency()
     * @param string $rESERVATIONPACKAGE_OBJID
     * @param string $service
     * @param string $datefrom
     * @param string $dateto
     * @param string $quantity
     * @param string $priceperunit
     * @param string $totalprice
     * @param string $currency
     */
    public function __construct($rESERVATIONPACKAGE_OBJID = null, $service = null, $datefrom = null, $dateto = null, $quantity = null, $priceperunit = null, $totalprice = null, $currency = null)
    {
        $this
            ->setRESERVATIONPACKAGE_OBJID($rESERVATIONPACKAGE_OBJID)
            ->setService($service)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setQuantity($quantity)
            ->setPriceperunit($priceperunit)
            ->setTotalprice($totalprice)
            ->setCurrency($currency);
    }
    /**
     * Get RESERVATIONPACKAGE_OBJID value
     * @return string
     */
    public function getRESERVATIONPACKAGE_OBJID()
    {
        return $this->{'RESERVATIONPACKAGE-OBJID'};
    }
    /**
     * Set RESERVATIONPACKAGE_OBJID value
     * @param string $rESERVATIONPACKAGE_OBJID
     * @return \StructType\RESERVATIONPACKAGE_1
     */
    public function setRESERVATIONPACKAGE_OBJID($rESERVATIONPACKAGE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATIONPACKAGE_OBJID) && !is_string($rESERVATIONPACKAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATIONPACKAGE_OBJID, true), gettype($rESERVATIONPACKAGE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATIONPACKAGE_OBJID) && !preg_match('/([0-9])*/', $rESERVATIONPACKAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATIONPACKAGE_OBJID, true)), __LINE__);
        }
        $this->RESERVATIONPACKAGE_OBJID = $this->{'RESERVATIONPACKAGE-OBJID'} = $rESERVATIONPACKAGE_OBJID;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\RESERVATIONPACKAGE_1
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\RESERVATIONPACKAGE_1
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\RESERVATIONPACKAGE_1
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get quantity value
     * @return string
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\RESERVATIONPACKAGE_1
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($quantity) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($quantity, true)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get priceperunit value
     * @return string
     */
    public function getPriceperunit()
    {
        return $this->priceperunit;
    }
    /**
     * Set priceperunit value
     * @param string $priceperunit
     * @return \StructType\RESERVATIONPACKAGE_1
     */
    public function setPriceperunit($priceperunit = null)
    {
        // validation for constraint: string
        if (!is_null($priceperunit) && !is_string($priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceperunit, true), gettype($priceperunit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($priceperunit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($priceperunit, true)), __LINE__);
        }
        $this->priceperunit = $priceperunit;
        return $this;
    }
    /**
     * Get totalprice value
     * @return string
     */
    public function getTotalprice()
    {
        return $this->totalprice;
    }
    /**
     * Set totalprice value
     * @param string $totalprice
     * @return \StructType\RESERVATIONPACKAGE_1
     */
    public function setTotalprice($totalprice = null)
    {
        // validation for constraint: string
        if (!is_null($totalprice) && !is_string($totalprice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalprice, true), gettype($totalprice)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($totalprice) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $totalprice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($totalprice, true)), __LINE__);
        }
        $this->totalprice = $totalprice;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\RESERVATIONPACKAGE_1
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
}
