<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Postings StructType
 * @subpackage Structs
 */
class Postings extends AbstractStructBase
{
    /**
     * The Posting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Posting[]
     */
    public $Posting;
    /**
     * Constructor method for Postings
     * @uses Postings::setPosting()
     * @param \StructType\Posting[] $posting
     */
    public function __construct(array $posting = array())
    {
        $this
            ->setPosting($posting);
    }
    /**
     * Get Posting value
     * @return \StructType\Posting[]|null
     */
    public function getPosting()
    {
        return $this->Posting;
    }
    /**
     * This method is responsible for validating the values passed to the setPosting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostingForArrayConstraintsFromSetPosting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $postingsPostingItem) {
            // validation for constraint: itemType
            if (!$postingsPostingItem instanceof \StructType\Posting) {
                $invalidValues[] = is_object($postingsPostingItem) ? get_class($postingsPostingItem) : sprintf('%s(%s)', gettype($postingsPostingItem), var_export($postingsPostingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Posting property can only contain items of type \StructType\Posting, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Posting value
     * @throws \InvalidArgumentException
     * @param \StructType\Posting[] $posting
     * @return \StructType\Postings
     */
    public function setPosting(array $posting = array())
    {
        // validation for constraint: array
        if ('' !== ($postingArrayErrorMessage = self::validatePostingForArrayConstraintsFromSetPosting($posting))) {
            throw new \InvalidArgumentException($postingArrayErrorMessage, __LINE__);
        }
        $this->Posting = $posting;
        return $this;
    }
    /**
     * Add item to Posting value
     * @throws \InvalidArgumentException
     * @param \StructType\Posting $item
     * @return \StructType\Postings
     */
    public function addToPosting(\StructType\Posting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Posting) {
            throw new \InvalidArgumentException(sprintf('The Posting property can only contain items of type \StructType\Posting, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Posting[] = $item;
        return $this;
    }
}
