<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostFOService StructType
 * @subpackage Structs
 */
class PostFOService extends AbstractStructBase
{
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $quantity;
    /**
     * The manualrate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $manualrate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratecategory;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratesegment;
    /**
     * The discount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $discount;
    /**
     * The discountgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $discountgroup;
    /**
     * The lengthofstay
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $lengthofstay;
    /**
     * The waiter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $waiter;
    /**
     * The outlet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $outlet;
    /**
     * The descriptionlst
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 36
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $descriptionlst;
    /**
     * The invoicetext
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoicetext;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The isfromzpos
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $isfromzpos;
    /**
     * Constructor method for PostFOService
     * @uses PostFOService::setService()
     * @uses PostFOService::setQuantity()
     * @uses PostFOService::setManualrate()
     * @uses PostFOService::setCurrency()
     * @uses PostFOService::setRatecategory()
     * @uses PostFOService::setRatesegment()
     * @uses PostFOService::setDiscount()
     * @uses PostFOService::setDiscountgroup()
     * @uses PostFOService::setLengthofstay()
     * @uses PostFOService::setWaiter()
     * @uses PostFOService::setOutlet()
     * @uses PostFOService::setDescriptionlst()
     * @uses PostFOService::setInvoicetext()
     * @uses PostFOService::setComment()
     * @uses PostFOService::setIsfromzpos()
     * @param string $service
     * @param string $quantity
     * @param string $manualrate
     * @param string $currency
     * @param string $ratecategory
     * @param string $ratesegment
     * @param string $discount
     * @param string $discountgroup
     * @param string $lengthofstay
     * @param string $waiter
     * @param string $outlet
     * @param string $descriptionlst
     * @param string $invoicetext
     * @param string $comment
     * @param string $isfromzpos
     */
    public function __construct($service = null, $quantity = null, $manualrate = null, $currency = null, $ratecategory = null, $ratesegment = null, $discount = null, $discountgroup = null, $lengthofstay = null, $waiter = null, $outlet = null, $descriptionlst = null, $invoicetext = null, $comment = null, $isfromzpos = null)
    {
        $this
            ->setService($service)
            ->setQuantity($quantity)
            ->setManualrate($manualrate)
            ->setCurrency($currency)
            ->setRatecategory($ratecategory)
            ->setRatesegment($ratesegment)
            ->setDiscount($discount)
            ->setDiscountgroup($discountgroup)
            ->setLengthofstay($lengthofstay)
            ->setWaiter($waiter)
            ->setOutlet($outlet)
            ->setDescriptionlst($descriptionlst)
            ->setInvoicetext($invoicetext)
            ->setComment($comment)
            ->setIsfromzpos($isfromzpos);
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\PostFOService
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get quantity value
     * @return string
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\PostFOService
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($quantity) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($quantity, true)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get manualrate value
     * @return string
     */
    public function getManualrate()
    {
        return $this->manualrate;
    }
    /**
     * Set manualrate value
     * @param string $manualrate
     * @return \StructType\PostFOService
     */
    public function setManualrate($manualrate = null)
    {
        // validation for constraint: string
        if (!is_null($manualrate) && !is_string($manualrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manualrate, true), gettype($manualrate)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($manualrate) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $manualrate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($manualrate, true)), __LINE__);
        }
        $this->manualrate = $manualrate;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PostFOService
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string|null
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\PostFOService
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string|null
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\PostFOService
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get discount value
     * @return string|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param string $discount
     * @return \StructType\PostFOService
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($discount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($discount, true)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get discountgroup value
     * @return string|null
     */
    public function getDiscountgroup()
    {
        return $this->discountgroup;
    }
    /**
     * Set discountgroup value
     * @param string $discountgroup
     * @return \StructType\PostFOService
     */
    public function setDiscountgroup($discountgroup = null)
    {
        // validation for constraint: string
        if (!is_null($discountgroup) && !is_string($discountgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountgroup, true), gettype($discountgroup)), __LINE__);
        }
        $this->discountgroup = $discountgroup;
        return $this;
    }
    /**
     * Get lengthofstay value
     * @return string|null
     */
    public function getLengthofstay()
    {
        return $this->lengthofstay;
    }
    /**
     * Set lengthofstay value
     * @param string $lengthofstay
     * @return \StructType\PostFOService
     */
    public function setLengthofstay($lengthofstay = null)
    {
        // validation for constraint: string
        if (!is_null($lengthofstay) && !is_string($lengthofstay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lengthofstay, true), gettype($lengthofstay)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($lengthofstay) && !preg_match('/([-+]){0,1}([0-9])*/', $lengthofstay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($lengthofstay, true)), __LINE__);
        }
        $this->lengthofstay = $lengthofstay;
        return $this;
    }
    /**
     * Get waiter value
     * @return string|null
     */
    public function getWaiter()
    {
        return $this->waiter;
    }
    /**
     * Set waiter value
     * @param string $waiter
     * @return \StructType\PostFOService
     */
    public function setWaiter($waiter = null)
    {
        // validation for constraint: string
        if (!is_null($waiter) && !is_string($waiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waiter, true), gettype($waiter)), __LINE__);
        }
        $this->waiter = $waiter;
        return $this;
    }
    /**
     * Get outlet value
     * @return string|null
     */
    public function getOutlet()
    {
        return $this->outlet;
    }
    /**
     * Set outlet value
     * @param string $outlet
     * @return \StructType\PostFOService
     */
    public function setOutlet($outlet = null)
    {
        // validation for constraint: string
        if (!is_null($outlet) && !is_string($outlet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outlet, true), gettype($outlet)), __LINE__);
        }
        $this->outlet = $outlet;
        return $this;
    }
    /**
     * Get descriptionlst value
     * @return string|null
     */
    public function getDescriptionlst()
    {
        return $this->descriptionlst;
    }
    /**
     * Set descriptionlst value
     * @param string $descriptionlst
     * @return \StructType\PostFOService
     */
    public function setDescriptionlst($descriptionlst = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionlst) && !is_string($descriptionlst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionlst, true), gettype($descriptionlst)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($descriptionlst) && mb_strlen($descriptionlst) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($descriptionlst)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($descriptionlst) && mb_strlen($descriptionlst) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($descriptionlst)), __LINE__);
        }
        $this->descriptionlst = $descriptionlst;
        return $this;
    }
    /**
     * Get invoicetext value
     * @return string|null
     */
    public function getInvoicetext()
    {
        return $this->invoicetext;
    }
    /**
     * Set invoicetext value
     * @param string $invoicetext
     * @return \StructType\PostFOService
     */
    public function setInvoicetext($invoicetext = null)
    {
        // validation for constraint: string
        if (!is_null($invoicetext) && !is_string($invoicetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicetext, true), gettype($invoicetext)), __LINE__);
        }
        $this->invoicetext = $invoicetext;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\PostFOService
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get isfromzpos value
     * @return string|null
     */
    public function getIsfromzpos()
    {
        return $this->isfromzpos;
    }
    /**
     * Set isfromzpos value
     * @param string $isfromzpos
     * @return \StructType\PostFOService
     */
    public function setIsfromzpos($isfromzpos = null)
    {
        // validation for constraint: string
        if (!is_null($isfromzpos) && !is_string($isfromzpos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isfromzpos, true), gettype($isfromzpos)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($isfromzpos) && !preg_match('/([-+]){0,1}([0-9])*/', $isfromzpos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($isfromzpos, true)), __LINE__);
        }
        $this->isfromzpos = $isfromzpos;
        return $this;
    }
}
