<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonSearch StructType
 * @subpackage Structs
 */
class PersonSearch extends AbstractStructBase
{
    /**
     * The PERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PERSON_OBJID;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Person
     */
    public $Person;
    /**
     * Constructor method for PersonSearch
     * @uses PersonSearch::setPERSON_OBJID()
     * @uses PersonSearch::setPerson()
     * @param string $pERSON_OBJID
     * @param \StructType\Person $person
     */
    public function __construct($pERSON_OBJID = null, \StructType\Person $person = null)
    {
        $this
            ->setPERSON_OBJID($pERSON_OBJID)
            ->setPerson($person);
    }
    /**
     * Get PERSON_OBJID value
     * @return string
     */
    public function getPERSON_OBJID()
    {
        return $this->{'PERSON-OBJID'};
    }
    /**
     * Set PERSON_OBJID value
     * @param string $pERSON_OBJID
     * @return \StructType\PersonSearch
     */
    public function setPERSON_OBJID($pERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pERSON_OBJID) && !is_string($pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pERSON_OBJID, true), gettype($pERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pERSON_OBJID) && !preg_match('/([0-9])*/', $pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pERSON_OBJID, true)), __LINE__);
        }
        $this->PERSON_OBJID = $this->{'PERSON-OBJID'} = $pERSON_OBJID;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \StructType\Person $person
     * @return \StructType\PersonSearch
     */
    public function setPerson(\StructType\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
}
