<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageSearchEntry StructType
 * @subpackage Structs
 */
class PackageSearchEntry extends AbstractStructBase
{
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Package;
    /**
     * The Mapping
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Mapping[]
     */
    public $Mapping;
    /**
     * Constructor method for PackageSearchEntry
     * @uses PackageSearchEntry::setPackage()
     * @uses PackageSearchEntry::setMapping()
     * @param string $package
     * @param \StructType\Mapping[] $mapping
     */
    public function __construct($package = null, array $mapping = array())
    {
        $this
            ->setPackage($package)
            ->setMapping($mapping);
    }
    /**
     * Get Package value
     * @return string
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * Set Package value
     * @param string $package
     * @return \StructType\PackageSearchEntry
     */
    public function setPackage($package = null)
    {
        // validation for constraint: string
        if (!is_null($package) && !is_string($package)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($package, true), gettype($package)), __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Get Mapping value
     * @return \StructType\Mapping[]|null
     */
    public function getMapping()
    {
        return $this->Mapping;
    }
    /**
     * This method is responsible for validating the values passed to the setMapping method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMapping method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMappingForArrayConstraintsFromSetMapping(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageSearchEntryMappingItem) {
            // validation for constraint: itemType
            if (!$packageSearchEntryMappingItem instanceof \StructType\Mapping) {
                $invalidValues[] = is_object($packageSearchEntryMappingItem) ? get_class($packageSearchEntryMappingItem) : sprintf('%s(%s)', gettype($packageSearchEntryMappingItem), var_export($packageSearchEntryMappingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mapping property can only contain items of type \StructType\Mapping, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mapping value
     * @throws \InvalidArgumentException
     * @param \StructType\Mapping[] $mapping
     * @return \StructType\PackageSearchEntry
     */
    public function setMapping(array $mapping = array())
    {
        // validation for constraint: array
        if ('' !== ($mappingArrayErrorMessage = self::validateMappingForArrayConstraintsFromSetMapping($mapping))) {
            throw new \InvalidArgumentException($mappingArrayErrorMessage, __LINE__);
        }
        $this->Mapping = $mapping;
        return $this;
    }
    /**
     * Add item to Mapping value
     * @throws \InvalidArgumentException
     * @param \StructType\Mapping $item
     * @return \StructType\PackageSearchEntry
     */
    public function addToMapping(\StructType\Mapping $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mapping) {
            throw new \InvalidArgumentException(sprintf('The Mapping property can only contain items of type \StructType\Mapping, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mapping[] = $item;
        return $this;
    }
}
