<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageReservation StructType
 * @subpackage Structs
 */
class PackageReservation extends AbstractStructBase
{
    /**
     * The PACKAGE_RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PACKAGE_RESERVATION_OBJID;
    /**
     * Constructor method for PackageReservation
     * @uses PackageReservation::setPACKAGE_RESERVATION_OBJID()
     * @param string $pACKAGE_RESERVATION_OBJID
     */
    public function __construct($pACKAGE_RESERVATION_OBJID = null)
    {
        $this
            ->setPACKAGE_RESERVATION_OBJID($pACKAGE_RESERVATION_OBJID);
    }
    /**
     * Get PACKAGE_RESERVATION_OBJID value
     * @return string
     */
    public function getPACKAGE_RESERVATION_OBJID()
    {
        return $this->{'PACKAGE-RESERVATION-OBJID'};
    }
    /**
     * Set PACKAGE_RESERVATION_OBJID value
     * @param string $pACKAGE_RESERVATION_OBJID
     * @return \StructType\PackageReservation
     */
    public function setPACKAGE_RESERVATION_OBJID($pACKAGE_RESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pACKAGE_RESERVATION_OBJID) && !is_string($pACKAGE_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pACKAGE_RESERVATION_OBJID, true), gettype($pACKAGE_RESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pACKAGE_RESERVATION_OBJID) && !preg_match('/([0-9])*/', $pACKAGE_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pACKAGE_RESERVATION_OBJID, true)), __LINE__);
        }
        $this->PACKAGE_RESERVATION_OBJID = $this->{'PACKAGE-RESERVATION-OBJID'} = $pACKAGE_RESERVATION_OBJID;
        return $this;
    }
}
