<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PERSON-SERVICE StructType
 * @subpackage Structs
 */
class PERSON_SERVICE extends AbstractStructBase
{
    /**
     * The PERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PERSON_OBJID;
    /**
     * The SERVICE_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SERVICE_OBJID;
    /**
     * Constructor method for PERSON-SERVICE
     * @uses PERSON_SERVICE::setPERSON_OBJID()
     * @uses PERSON_SERVICE::setSERVICE_OBJID()
     * @param string $pERSON_OBJID
     * @param string $sERVICE_OBJID
     */
    public function __construct($pERSON_OBJID = null, $sERVICE_OBJID = null)
    {
        $this
            ->setPERSON_OBJID($pERSON_OBJID)
            ->setSERVICE_OBJID($sERVICE_OBJID);
    }
    /**
     * Get PERSON_OBJID value
     * @return string
     */
    public function getPERSON_OBJID()
    {
        return $this->{'PERSON-OBJID'};
    }
    /**
     * Set PERSON_OBJID value
     * @param string $pERSON_OBJID
     * @return \StructType\PERSON_SERVICE
     */
    public function setPERSON_OBJID($pERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pERSON_OBJID) && !is_string($pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pERSON_OBJID, true), gettype($pERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pERSON_OBJID) && !preg_match('/([0-9])*/', $pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pERSON_OBJID, true)), __LINE__);
        }
        $this->PERSON_OBJID = $this->{'PERSON-OBJID'} = $pERSON_OBJID;
        return $this;
    }
    /**
     * Get SERVICE_OBJID value
     * @return string
     */
    public function getSERVICE_OBJID()
    {
        return $this->{'SERVICE-OBJID'};
    }
    /**
     * Set SERVICE_OBJID value
     * @param string $sERVICE_OBJID
     * @return \StructType\PERSON_SERVICE
     */
    public function setSERVICE_OBJID($sERVICE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICE_OBJID) && !is_string($sERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICE_OBJID, true), gettype($sERVICE_OBJID)), __LINE__);
        }
        $this->SERVICE_OBJID = $this->{'SERVICE-OBJID'} = $sERVICE_OBJID;
        return $this;
    }
}
