<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PAYMENT-POSTING StructType
 * @subpackage Structs
 */
class PAYMENT_POSTING extends AbstractStructBase
{
    /**
     * The PAYMENT_POSTING_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PAYMENT_POSTING_OBJID;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The dateOfPayment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateOfPayment;
    /**
     * The timeOfPayment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timeOfPayment;
    /**
     * The authorizationcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $authorizationcode;
    /**
     * The refno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $refno;
    /**
     * The cchandle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cchandle;
    /**
     * The terminalid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $terminalid;
    /**
     * The interfacetype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $interfacetype;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The shift
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $shift;
    /**
     * The outlet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $outlet;
    /**
     * The waiter
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $waiter;
    /**
     * The cashregisterno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $cashregisterno;
    /**
     * The INVOICE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\INVOICE[]
     */
    public $INVOICE;
    /**
     * The ACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ACCOUNT[]
     */
    public $ACCOUNT;
    /**
     * Constructor method for PAYMENT-POSTING
     * @uses PAYMENT_POSTING::setPAYMENT_POSTING_OBJID()
     * @uses PAYMENT_POSTING::setAmount()
     * @uses PAYMENT_POSTING::setCurrency()
     * @uses PAYMENT_POSTING::setDate()
     * @uses PAYMENT_POSTING::setDateOfPayment()
     * @uses PAYMENT_POSTING::setTimeOfPayment()
     * @uses PAYMENT_POSTING::setAuthorizationcode()
     * @uses PAYMENT_POSTING::setRefno()
     * @uses PAYMENT_POSTING::setCchandle()
     * @uses PAYMENT_POSTING::setTerminalid()
     * @uses PAYMENT_POSTING::setInterfacetype()
     * @uses PAYMENT_POSTING::setTypeofpayment()
     * @uses PAYMENT_POSTING::setShift()
     * @uses PAYMENT_POSTING::setOutlet()
     * @uses PAYMENT_POSTING::setWaiter()
     * @uses PAYMENT_POSTING::setCashregisterno()
     * @uses PAYMENT_POSTING::setINVOICE()
     * @uses PAYMENT_POSTING::setACCOUNT()
     * @param string $pAYMENT_POSTING_OBJID
     * @param string $amount
     * @param string $currency
     * @param string $date
     * @param string $dateOfPayment
     * @param string $timeOfPayment
     * @param string $authorizationcode
     * @param string $refno
     * @param string $cchandle
     * @param string $terminalid
     * @param string $interfacetype
     * @param string $typeofpayment
     * @param string $shift
     * @param string $outlet
     * @param string $waiter
     * @param string $cashregisterno
     * @param \StructType\INVOICE[] $iNVOICE
     * @param \StructType\ACCOUNT[] $aCCOUNT
     */
    public function __construct($pAYMENT_POSTING_OBJID = null, $amount = null, $currency = null, $date = null, $dateOfPayment = null, $timeOfPayment = null, $authorizationcode = null, $refno = null, $cchandle = null, $terminalid = null, $interfacetype = null, $typeofpayment = null, $shift = null, $outlet = null, $waiter = null, $cashregisterno = null, array $iNVOICE = array(), array $aCCOUNT = array())
    {
        $this
            ->setPAYMENT_POSTING_OBJID($pAYMENT_POSTING_OBJID)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setDate($date)
            ->setDateOfPayment($dateOfPayment)
            ->setTimeOfPayment($timeOfPayment)
            ->setAuthorizationcode($authorizationcode)
            ->setRefno($refno)
            ->setCchandle($cchandle)
            ->setTerminalid($terminalid)
            ->setInterfacetype($interfacetype)
            ->setTypeofpayment($typeofpayment)
            ->setShift($shift)
            ->setOutlet($outlet)
            ->setWaiter($waiter)
            ->setCashregisterno($cashregisterno)
            ->setINVOICE($iNVOICE)
            ->setACCOUNT($aCCOUNT);
    }
    /**
     * Get PAYMENT_POSTING_OBJID value
     * @return string
     */
    public function getPAYMENT_POSTING_OBJID()
    {
        return $this->{'PAYMENT-POSTING-OBJID'};
    }
    /**
     * Set PAYMENT_POSTING_OBJID value
     * @param string $pAYMENT_POSTING_OBJID
     * @return \StructType\PAYMENT_POSTING
     */
    public function setPAYMENT_POSTING_OBJID($pAYMENT_POSTING_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pAYMENT_POSTING_OBJID) && !is_string($pAYMENT_POSTING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAYMENT_POSTING_OBJID, true), gettype($pAYMENT_POSTING_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pAYMENT_POSTING_OBJID) && !preg_match('/([0-9])*/', $pAYMENT_POSTING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pAYMENT_POSTING_OBJID, true)), __LINE__);
        }
        $this->PAYMENT_POSTING_OBJID = $this->{'PAYMENT-POSTING-OBJID'} = $pAYMENT_POSTING_OBJID;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\PAYMENT_POSTING
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\PAYMENT_POSTING
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\PAYMENT_POSTING
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get dateOfPayment value
     * @return string
     */
    public function getDateOfPayment()
    {
        return $this->dateOfPayment;
    }
    /**
     * Set dateOfPayment value
     * @param string $dateOfPayment
     * @return \StructType\PAYMENT_POSTING
     */
    public function setDateOfPayment($dateOfPayment = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfPayment) && !is_string($dateOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfPayment, true), gettype($dateOfPayment)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateOfPayment) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateOfPayment, true)), __LINE__);
        }
        $this->dateOfPayment = $dateOfPayment;
        return $this;
    }
    /**
     * Get timeOfPayment value
     * @return string
     */
    public function getTimeOfPayment()
    {
        return $this->timeOfPayment;
    }
    /**
     * Set timeOfPayment value
     * @param string $timeOfPayment
     * @return \StructType\PAYMENT_POSTING
     */
    public function setTimeOfPayment($timeOfPayment = null)
    {
        // validation for constraint: string
        if (!is_null($timeOfPayment) && !is_string($timeOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeOfPayment, true), gettype($timeOfPayment)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timeOfPayment) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timeOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timeOfPayment, true)), __LINE__);
        }
        $this->timeOfPayment = $timeOfPayment;
        return $this;
    }
    /**
     * Get authorizationcode value
     * @return string
     */
    public function getAuthorizationcode()
    {
        return $this->authorizationcode;
    }
    /**
     * Set authorizationcode value
     * @param string $authorizationcode
     * @return \StructType\PAYMENT_POSTING
     */
    public function setAuthorizationcode($authorizationcode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationcode) && !is_string($authorizationcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationcode, true), gettype($authorizationcode)), __LINE__);
        }
        $this->authorizationcode = $authorizationcode;
        return $this;
    }
    /**
     * Get refno value
     * @return string
     */
    public function getRefno()
    {
        return $this->refno;
    }
    /**
     * Set refno value
     * @param string $refno
     * @return \StructType\PAYMENT_POSTING
     */
    public function setRefno($refno = null)
    {
        // validation for constraint: string
        if (!is_null($refno) && !is_string($refno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refno, true), gettype($refno)), __LINE__);
        }
        $this->refno = $refno;
        return $this;
    }
    /**
     * Get cchandle value
     * @return string
     */
    public function getCchandle()
    {
        return $this->cchandle;
    }
    /**
     * Set cchandle value
     * @param string $cchandle
     * @return \StructType\PAYMENT_POSTING
     */
    public function setCchandle($cchandle = null)
    {
        // validation for constraint: string
        if (!is_null($cchandle) && !is_string($cchandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cchandle, true), gettype($cchandle)), __LINE__);
        }
        $this->cchandle = $cchandle;
        return $this;
    }
    /**
     * Get terminalid value
     * @return string
     */
    public function getTerminalid()
    {
        return $this->terminalid;
    }
    /**
     * Set terminalid value
     * @param string $terminalid
     * @return \StructType\PAYMENT_POSTING
     */
    public function setTerminalid($terminalid = null)
    {
        // validation for constraint: string
        if (!is_null($terminalid) && !is_string($terminalid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalid, true), gettype($terminalid)), __LINE__);
        }
        $this->terminalid = $terminalid;
        return $this;
    }
    /**
     * Get interfacetype value
     * @return string
     */
    public function getInterfacetype()
    {
        return $this->interfacetype;
    }
    /**
     * Set interfacetype value
     * @param string $interfacetype
     * @return \StructType\PAYMENT_POSTING
     */
    public function setInterfacetype($interfacetype = null)
    {
        // validation for constraint: string
        if (!is_null($interfacetype) && !is_string($interfacetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interfacetype, true), gettype($interfacetype)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($interfacetype) && !preg_match('/([-+]){0,1}([0-9])*/', $interfacetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($interfacetype, true)), __LINE__);
        }
        $this->interfacetype = $interfacetype;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\PAYMENT_POSTING
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get shift value
     * @return string
     */
    public function getShift()
    {
        return $this->shift;
    }
    /**
     * Set shift value
     * @param string $shift
     * @return \StructType\PAYMENT_POSTING
     */
    public function setShift($shift = null)
    {
        // validation for constraint: string
        if (!is_null($shift) && !is_string($shift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shift, true), gettype($shift)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($shift) && !preg_match('/([-+]){0,1}([0-9])*/', $shift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($shift, true)), __LINE__);
        }
        $this->shift = $shift;
        return $this;
    }
    /**
     * Get outlet value
     * @return string
     */
    public function getOutlet()
    {
        return $this->outlet;
    }
    /**
     * Set outlet value
     * @param string $outlet
     * @return \StructType\PAYMENT_POSTING
     */
    public function setOutlet($outlet = null)
    {
        // validation for constraint: string
        if (!is_null($outlet) && !is_string($outlet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outlet, true), gettype($outlet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($outlet) && !preg_match('/([-+]){0,1}([0-9])*/', $outlet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($outlet, true)), __LINE__);
        }
        $this->outlet = $outlet;
        return $this;
    }
    /**
     * Get waiter value
     * @return string
     */
    public function getWaiter()
    {
        return $this->waiter;
    }
    /**
     * Set waiter value
     * @param string $waiter
     * @return \StructType\PAYMENT_POSTING
     */
    public function setWaiter($waiter = null)
    {
        // validation for constraint: string
        if (!is_null($waiter) && !is_string($waiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waiter, true), gettype($waiter)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($waiter) && !preg_match('/([-+]){0,1}([0-9])*/', $waiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($waiter, true)), __LINE__);
        }
        $this->waiter = $waiter;
        return $this;
    }
    /**
     * Get cashregisterno value
     * @return string
     */
    public function getCashregisterno()
    {
        return $this->cashregisterno;
    }
    /**
     * Set cashregisterno value
     * @param string $cashregisterno
     * @return \StructType\PAYMENT_POSTING
     */
    public function setCashregisterno($cashregisterno = null)
    {
        // validation for constraint: string
        if (!is_null($cashregisterno) && !is_string($cashregisterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cashregisterno, true), gettype($cashregisterno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($cashregisterno) && !preg_match('/([-+]){0,1}([0-9])*/', $cashregisterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($cashregisterno, true)), __LINE__);
        }
        $this->cashregisterno = $cashregisterno;
        return $this;
    }
    /**
     * Get INVOICE value
     * @return \StructType\INVOICE[]|null
     */
    public function getINVOICE()
    {
        return $this->INVOICE;
    }
    /**
     * This method is responsible for validating the values passed to the setINVOICE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setINVOICE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateINVOICEForArrayConstraintsFromSetINVOICE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pAYMENT_POSTINGINVOICEItem) {
            // validation for constraint: itemType
            if (!$pAYMENT_POSTINGINVOICEItem instanceof \StructType\INVOICE) {
                $invalidValues[] = is_object($pAYMENT_POSTINGINVOICEItem) ? get_class($pAYMENT_POSTINGINVOICEItem) : sprintf('%s(%s)', gettype($pAYMENT_POSTINGINVOICEItem), var_export($pAYMENT_POSTINGINVOICEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE[] $iNVOICE
     * @return \StructType\PAYMENT_POSTING
     */
    public function setINVOICE(array $iNVOICE = array())
    {
        // validation for constraint: array
        if ('' !== ($iNVOICEArrayErrorMessage = self::validateINVOICEForArrayConstraintsFromSetINVOICE($iNVOICE))) {
            throw new \InvalidArgumentException($iNVOICEArrayErrorMessage, __LINE__);
        }
        $this->INVOICE = $iNVOICE;
        return $this;
    }
    /**
     * Add item to INVOICE value
     * @throws \InvalidArgumentException
     * @param \StructType\INVOICE $item
     * @return \StructType\PAYMENT_POSTING
     */
    public function addToINVOICE(\StructType\INVOICE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\INVOICE) {
            throw new \InvalidArgumentException(sprintf('The INVOICE property can only contain items of type \StructType\INVOICE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->INVOICE[] = $item;
        return $this;
    }
    /**
     * Get ACCOUNT value
     * @return \StructType\ACCOUNT[]|null
     */
    public function getACCOUNT()
    {
        return $this->ACCOUNT;
    }
    /**
     * This method is responsible for validating the values passed to the setACCOUNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setACCOUNT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateACCOUNTForArrayConstraintsFromSetACCOUNT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pAYMENT_POSTINGACCOUNTItem) {
            // validation for constraint: itemType
            if (!$pAYMENT_POSTINGACCOUNTItem instanceof \StructType\ACCOUNT) {
                $invalidValues[] = is_object($pAYMENT_POSTINGACCOUNTItem) ? get_class($pAYMENT_POSTINGACCOUNTItem) : sprintf('%s(%s)', gettype($pAYMENT_POSTINGACCOUNTItem), var_export($pAYMENT_POSTINGACCOUNTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ACCOUNT property can only contain items of type \StructType\ACCOUNT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\ACCOUNT[] $aCCOUNT
     * @return \StructType\PAYMENT_POSTING
     */
    public function setACCOUNT(array $aCCOUNT = array())
    {
        // validation for constraint: array
        if ('' !== ($aCCOUNTArrayErrorMessage = self::validateACCOUNTForArrayConstraintsFromSetACCOUNT($aCCOUNT))) {
            throw new \InvalidArgumentException($aCCOUNTArrayErrorMessage, __LINE__);
        }
        $this->ACCOUNT = $aCCOUNT;
        return $this;
    }
    /**
     * Add item to ACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\ACCOUNT $item
     * @return \StructType\PAYMENT_POSTING
     */
    public function addToACCOUNT(\StructType\ACCOUNT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ACCOUNT) {
            throw new \InvalidArgumentException(sprintf('The ACCOUNT property can only contain items of type \StructType\ACCOUNT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ACCOUNT[] = $item;
        return $this;
    }
}
