<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Output StructType
 * @subpackage Structs
 */
class Output extends AbstractStructBase
{
    /**
     * The Deposit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Deposit_1[]
     */
    public $Deposit;
    /**
     * Constructor method for Output
     * @uses Output::setDeposit()
     * @param \StructType\Deposit_1[] $deposit
     */
    public function __construct(array $deposit = array())
    {
        $this
            ->setDeposit($deposit);
    }
    /**
     * Get Deposit value
     * @return \StructType\Deposit_1[]|null
     */
    public function getDeposit()
    {
        return $this->Deposit;
    }
    /**
     * This method is responsible for validating the values passed to the setDeposit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeposit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositForArrayConstraintsFromSetDeposit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outputDepositItem) {
            // validation for constraint: itemType
            if (!$outputDepositItem instanceof \StructType\Deposit_1) {
                $invalidValues[] = is_object($outputDepositItem) ? get_class($outputDepositItem) : sprintf('%s(%s)', gettype($outputDepositItem), var_export($outputDepositItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deposit property can only contain items of type \StructType\Deposit_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deposit value
     * @throws \InvalidArgumentException
     * @param \StructType\Deposit_1[] $deposit
     * @return \StructType\Output
     */
    public function setDeposit(array $deposit = array())
    {
        // validation for constraint: array
        if ('' !== ($depositArrayErrorMessage = self::validateDepositForArrayConstraintsFromSetDeposit($deposit))) {
            throw new \InvalidArgumentException($depositArrayErrorMessage, __LINE__);
        }
        $this->Deposit = $deposit;
        return $this;
    }
    /**
     * Add item to Deposit value
     * @throws \InvalidArgumentException
     * @param \StructType\Deposit_1 $item
     * @return \StructType\Output
     */
    public function addToDeposit(\StructType\Deposit_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Deposit_1) {
            throw new \InvalidArgumentException(sprintf('The Deposit property can only contain items of type \StructType\Deposit_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Deposit[] = $item;
        return $this;
    }
}
