<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewGiftvoucher StructType
 * @subpackage Structs
 */
class NewGiftvoucher extends AbstractStructBase
{
    /**
     * The objid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $objid;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $number;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalreference;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The selldate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $selldate;
    /**
     * The hotelsell
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotelsell;
    /**
     * The expirydate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $expirydate;
    /**
     * Constructor method for NewGiftvoucher
     * @uses NewGiftvoucher::setObjid()
     * @uses NewGiftvoucher::setStatus()
     * @uses NewGiftvoucher::setNumber()
     * @uses NewGiftvoucher::setExternalreference()
     * @uses NewGiftvoucher::setAmount()
     * @uses NewGiftvoucher::setSelldate()
     * @uses NewGiftvoucher::setHotelsell()
     * @uses NewGiftvoucher::setExpirydate()
     * @param string $objid
     * @param string $status
     * @param string $number
     * @param string $externalreference
     * @param string $amount
     * @param string $selldate
     * @param string $hotelsell
     * @param string $expirydate
     */
    public function __construct($objid = null, $status = null, $number = null, $externalreference = null, $amount = null, $selldate = null, $hotelsell = null, $expirydate = null)
    {
        $this
            ->setObjid($objid)
            ->setStatus($status)
            ->setNumber($number)
            ->setExternalreference($externalreference)
            ->setAmount($amount)
            ->setSelldate($selldate)
            ->setHotelsell($hotelsell)
            ->setExpirydate($expirydate);
    }
    /**
     * Get objid value
     * @return string
     */
    public function getObjid()
    {
        return $this->objid;
    }
    /**
     * Set objid value
     * @param string $objid
     * @return \StructType\NewGiftvoucher
     */
    public function setObjid($objid = null)
    {
        // validation for constraint: string
        if (!is_null($objid) && !is_string($objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objid, true), gettype($objid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($objid) && !preg_match('/([0-9])*/', $objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($objid, true)), __LINE__);
        }
        $this->objid = $objid;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\NewGiftvoucher
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\NewGiftvoucher
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($number) && !preg_match('/([-+]){0,1}([0-9])*/', $number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($number, true)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\NewGiftvoucher
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($externalreference) && mb_strlen($externalreference) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($externalreference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference) && mb_strlen($externalreference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\NewGiftvoucher
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get selldate value
     * @return string
     */
    public function getSelldate()
    {
        return $this->selldate;
    }
    /**
     * Set selldate value
     * @param string $selldate
     * @return \StructType\NewGiftvoucher
     */
    public function setSelldate($selldate = null)
    {
        // validation for constraint: string
        if (!is_null($selldate) && !is_string($selldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selldate, true), gettype($selldate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($selldate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $selldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($selldate, true)), __LINE__);
        }
        $this->selldate = $selldate;
        return $this;
    }
    /**
     * Get hotelsell value
     * @return string
     */
    public function getHotelsell()
    {
        return $this->hotelsell;
    }
    /**
     * Set hotelsell value
     * @param string $hotelsell
     * @return \StructType\NewGiftvoucher
     */
    public function setHotelsell($hotelsell = null)
    {
        // validation for constraint: string
        if (!is_null($hotelsell) && !is_string($hotelsell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelsell, true), gettype($hotelsell)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotelsell) && !preg_match('/([-+]){0,1}([0-9])*/', $hotelsell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotelsell, true)), __LINE__);
        }
        $this->hotelsell = $hotelsell;
        return $this;
    }
    /**
     * Get expirydate value
     * @return string
     */
    public function getExpirydate()
    {
        return $this->expirydate;
    }
    /**
     * Set expirydate value
     * @param string $expirydate
     * @return \StructType\NewGiftvoucher
     */
    public function setExpirydate($expirydate = null)
    {
        // validation for constraint: string
        if (!is_null($expirydate) && !is_string($expirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirydate, true), gettype($expirydate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($expirydate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $expirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($expirydate, true)), __LINE__);
        }
        $this->expirydate = $expirydate;
        return $this;
    }
}
