<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Namelist StructType
 * @subpackage Structs
 */
class Namelist extends AbstractStructBase
{
    /**
     * The PERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PERSON_OBJID;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The guesttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $guesttype;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subsubcountry;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $region;
    /**
     * The nationality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nationality;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email1;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $mobile1;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * The birthcountry
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $birthcountry;
    /**
     * The persontype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $persontype;
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guest_1[]
     */
    public $Guest;
    /**
     * The PoliceListEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PoliceListEntry[]
     */
    public $PoliceListEntry;
    /**
     * Constructor method for Namelist
     * @uses Namelist::setPERSON_OBJID()
     * @uses Namelist::setAddress()
     * @uses Namelist::setGuesttype()
     * @uses Namelist::setName1()
     * @uses Namelist::setName2()
     * @uses Namelist::setStreet()
     * @uses Namelist::setPostcode()
     * @uses Namelist::setCity()
     * @uses Namelist::setCountry()
     * @uses Namelist::setSubcountry()
     * @uses Namelist::setSubsubcountry()
     * @uses Namelist::setRegion()
     * @uses Namelist::setNationality()
     * @uses Namelist::setEmail1()
     * @uses Namelist::setMobile1()
     * @uses Namelist::setBirthdate()
     * @uses Namelist::setBirthcountry()
     * @uses Namelist::setPersontype()
     * @uses Namelist::setGuest()
     * @uses Namelist::setPoliceListEntry()
     * @param string $pERSON_OBJID
     * @param string $address
     * @param string $guesttype
     * @param string $name1
     * @param string $name2
     * @param string $street
     * @param string $postcode
     * @param string $city
     * @param string $country
     * @param string $subcountry
     * @param string $subsubcountry
     * @param string $region
     * @param string $nationality
     * @param string $email1
     * @param string $mobile1
     * @param string $birthdate
     * @param string $birthcountry
     * @param string $persontype
     * @param \StructType\Guest_1[] $guest
     * @param \StructType\PoliceListEntry[] $policeListEntry
     */
    public function __construct($pERSON_OBJID = null, $address = null, $guesttype = null, $name1 = null, $name2 = null, $street = null, $postcode = null, $city = null, $country = null, $subcountry = null, $subsubcountry = null, $region = null, $nationality = null, $email1 = null, $mobile1 = null, $birthdate = null, $birthcountry = null, $persontype = null, array $guest = array(), array $policeListEntry = array())
    {
        $this
            ->setPERSON_OBJID($pERSON_OBJID)
            ->setAddress($address)
            ->setGuesttype($guesttype)
            ->setName1($name1)
            ->setName2($name2)
            ->setStreet($street)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setSubsubcountry($subsubcountry)
            ->setRegion($region)
            ->setNationality($nationality)
            ->setEmail1($email1)
            ->setMobile1($mobile1)
            ->setBirthdate($birthdate)
            ->setBirthcountry($birthcountry)
            ->setPersontype($persontype)
            ->setGuest($guest)
            ->setPoliceListEntry($policeListEntry);
    }
    /**
     * Get PERSON_OBJID value
     * @return string
     */
    public function getPERSON_OBJID()
    {
        return $this->{'PERSON-OBJID'};
    }
    /**
     * Set PERSON_OBJID value
     * @param string $pERSON_OBJID
     * @return \StructType\Namelist
     */
    public function setPERSON_OBJID($pERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pERSON_OBJID) && !is_string($pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pERSON_OBJID, true), gettype($pERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pERSON_OBJID) && !preg_match('/([0-9])*/', $pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pERSON_OBJID, true)), __LINE__);
        }
        $this->PERSON_OBJID = $this->{'PERSON-OBJID'} = $pERSON_OBJID;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\Namelist
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get guesttype value
     * @return string
     */
    public function getGuesttype()
    {
        return $this->guesttype;
    }
    /**
     * Set guesttype value
     * @param string $guesttype
     * @return \StructType\Namelist
     */
    public function setGuesttype($guesttype = null)
    {
        // validation for constraint: string
        if (!is_null($guesttype) && !is_string($guesttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guesttype, true), gettype($guesttype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($guesttype) && mb_strlen($guesttype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($guesttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guesttype) && mb_strlen($guesttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guesttype)), __LINE__);
        }
        $this->guesttype = $guesttype;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\Namelist
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\Namelist
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name2) && mb_strlen($name2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\Namelist
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Namelist
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Namelist
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Namelist
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\Namelist
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\Namelist
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get region value
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\Namelist
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($region) && mb_strlen($region) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($region)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($region) && mb_strlen($region) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get nationality value
     * @return string
     */
    public function getNationality()
    {
        return $this->nationality;
    }
    /**
     * Set nationality value
     * @param string $nationality
     * @return \StructType\Namelist
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($nationality) && mb_strlen($nationality) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($nationality)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nationality) && mb_strlen($nationality) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nationality)), __LINE__);
        }
        $this->nationality = $nationality;
        return $this;
    }
    /**
     * Get email1 value
     * @return string
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\Namelist
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\Namelist
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\Namelist
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get birthcountry value
     * @return string
     */
    public function getBirthcountry()
    {
        return $this->birthcountry;
    }
    /**
     * Set birthcountry value
     * @param string $birthcountry
     * @return \StructType\Namelist
     */
    public function setBirthcountry($birthcountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthcountry) && !is_string($birthcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthcountry, true), gettype($birthcountry)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($birthcountry) && mb_strlen($birthcountry) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($birthcountry)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($birthcountry) && mb_strlen($birthcountry) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($birthcountry)), __LINE__);
        }
        $this->birthcountry = $birthcountry;
        return $this;
    }
    /**
     * Get persontype value
     * @return string
     */
    public function getPersontype()
    {
        return $this->persontype;
    }
    /**
     * Set persontype value
     * @param string $persontype
     * @return \StructType\Namelist
     */
    public function setPersontype($persontype = null)
    {
        // validation for constraint: string
        if (!is_null($persontype) && !is_string($persontype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($persontype, true), gettype($persontype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($persontype) && mb_strlen($persontype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($persontype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($persontype) && mb_strlen($persontype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($persontype)), __LINE__);
        }
        $this->persontype = $persontype;
        return $this;
    }
    /**
     * Get Guest value
     * @return \StructType\Guest_1[]|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestForArrayConstraintsFromSetGuest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $namelistGuestItem) {
            // validation for constraint: itemType
            if (!$namelistGuestItem instanceof \StructType\Guest_1) {
                $invalidValues[] = is_object($namelistGuestItem) ? get_class($namelistGuestItem) : sprintf('%s(%s)', gettype($namelistGuestItem), var_export($namelistGuestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest property can only contain items of type \StructType\Guest_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_1[] $guest
     * @return \StructType\Namelist
     */
    public function setGuest(array $guest = array())
    {
        // validation for constraint: array
        if ('' !== ($guestArrayErrorMessage = self::validateGuestForArrayConstraintsFromSetGuest($guest))) {
            throw new \InvalidArgumentException($guestArrayErrorMessage, __LINE__);
        }
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Add item to Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_1 $item
     * @return \StructType\Namelist
     */
    public function addToGuest(\StructType\Guest_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guest_1) {
            throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of type \StructType\Guest_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest[] = $item;
        return $this;
    }
    /**
     * Get PoliceListEntry value
     * @return \StructType\PoliceListEntry[]|null
     */
    public function getPoliceListEntry()
    {
        return $this->PoliceListEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setPoliceListEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPoliceListEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePoliceListEntryForArrayConstraintsFromSetPoliceListEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $namelistPoliceListEntryItem) {
            // validation for constraint: itemType
            if (!$namelistPoliceListEntryItem instanceof \StructType\PoliceListEntry) {
                $invalidValues[] = is_object($namelistPoliceListEntryItem) ? get_class($namelistPoliceListEntryItem) : sprintf('%s(%s)', gettype($namelistPoliceListEntryItem), var_export($namelistPoliceListEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PoliceListEntry property can only contain items of type \StructType\PoliceListEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PoliceListEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\PoliceListEntry[] $policeListEntry
     * @return \StructType\Namelist
     */
    public function setPoliceListEntry(array $policeListEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($policeListEntryArrayErrorMessage = self::validatePoliceListEntryForArrayConstraintsFromSetPoliceListEntry($policeListEntry))) {
            throw new \InvalidArgumentException($policeListEntryArrayErrorMessage, __LINE__);
        }
        $this->PoliceListEntry = $policeListEntry;
        return $this;
    }
    /**
     * Add item to PoliceListEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\PoliceListEntry $item
     * @return \StructType\Namelist
     */
    public function addToPoliceListEntry(\StructType\PoliceListEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PoliceListEntry) {
            throw new \InvalidArgumentException(sprintf('The PoliceListEntry property can only contain items of type \StructType\PoliceListEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PoliceListEntry[] = $item;
        return $this;
    }
}
