<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NOTIFICATION-REGISTRATION StructType
 * @subpackage Structs
 */
class NOTIFICATION_REGISTRATION extends AbstractStructBase
{
    /**
     * The key
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $key;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The notificationid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $notificationid;
    /**
     * The confirmationdisabled
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $confirmationdisabled;
    /**
     * The TRIGGER
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TRIGGER[]
     */
    public $TRIGGER;
    /**
     * The CONSTRAINT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CONSTRAINT[]
     */
    public $CONSTRAINT;
    /**
     * Constructor method for NOTIFICATION-REGISTRATION
     * @uses NOTIFICATION_REGISTRATION::setKey()
     * @uses NOTIFICATION_REGISTRATION::setProduct()
     * @uses NOTIFICATION_REGISTRATION::setNotificationid()
     * @uses NOTIFICATION_REGISTRATION::setConfirmationdisabled()
     * @uses NOTIFICATION_REGISTRATION::setTRIGGER()
     * @uses NOTIFICATION_REGISTRATION::setCONSTRAINT()
     * @param string $key
     * @param string $product
     * @param string $notificationid
     * @param string $confirmationdisabled
     * @param \StructType\TRIGGER[] $tRIGGER
     * @param \StructType\CONSTRAINT[] $cONSTRAINT
     */
    public function __construct($key = null, $product = null, $notificationid = null, $confirmationdisabled = null, array $tRIGGER = array(), array $cONSTRAINT = array())
    {
        $this
            ->setKey($key)
            ->setProduct($product)
            ->setNotificationid($notificationid)
            ->setConfirmationdisabled($confirmationdisabled)
            ->setTRIGGER($tRIGGER)
            ->setCONSTRAINT($cONSTRAINT);
    }
    /**
     * Get key value
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\NOTIFICATION_REGISTRATION
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($key) && !preg_match('/([-+]){0,1}([0-9])*/', $key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($key, true)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\NOTIFICATION_REGISTRATION
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get notificationid value
     * @return string
     */
    public function getNotificationid()
    {
        return $this->notificationid;
    }
    /**
     * Set notificationid value
     * @param string $notificationid
     * @return \StructType\NOTIFICATION_REGISTRATION
     */
    public function setNotificationid($notificationid = null)
    {
        // validation for constraint: string
        if (!is_null($notificationid) && !is_string($notificationid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationid, true), gettype($notificationid)), __LINE__);
        }
        $this->notificationid = $notificationid;
        return $this;
    }
    /**
     * Get confirmationdisabled value
     * @return string
     */
    public function getConfirmationdisabled()
    {
        return $this->confirmationdisabled;
    }
    /**
     * Set confirmationdisabled value
     * @param string $confirmationdisabled
     * @return \StructType\NOTIFICATION_REGISTRATION
     */
    public function setConfirmationdisabled($confirmationdisabled = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationdisabled) && !is_string($confirmationdisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationdisabled, true), gettype($confirmationdisabled)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($confirmationdisabled) && !preg_match('/([-+]){0,1}([0-9])*/', $confirmationdisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($confirmationdisabled, true)), __LINE__);
        }
        $this->confirmationdisabled = $confirmationdisabled;
        return $this;
    }
    /**
     * Get TRIGGER value
     * @return \StructType\TRIGGER[]|null
     */
    public function getTRIGGER()
    {
        return $this->TRIGGER;
    }
    /**
     * This method is responsible for validating the values passed to the setTRIGGER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTRIGGER method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTRIGGERForArrayConstraintsFromSetTRIGGER(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nOTIFICATION_REGISTRATIONTRIGGERItem) {
            // validation for constraint: itemType
            if (!$nOTIFICATION_REGISTRATIONTRIGGERItem instanceof \StructType\TRIGGER) {
                $invalidValues[] = is_object($nOTIFICATION_REGISTRATIONTRIGGERItem) ? get_class($nOTIFICATION_REGISTRATIONTRIGGERItem) : sprintf('%s(%s)', gettype($nOTIFICATION_REGISTRATIONTRIGGERItem), var_export($nOTIFICATION_REGISTRATIONTRIGGERItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TRIGGER property can only contain items of type \StructType\TRIGGER, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TRIGGER value
     * @throws \InvalidArgumentException
     * @param \StructType\TRIGGER[] $tRIGGER
     * @return \StructType\NOTIFICATION_REGISTRATION
     */
    public function setTRIGGER(array $tRIGGER = array())
    {
        // validation for constraint: array
        if ('' !== ($tRIGGERArrayErrorMessage = self::validateTRIGGERForArrayConstraintsFromSetTRIGGER($tRIGGER))) {
            throw new \InvalidArgumentException($tRIGGERArrayErrorMessage, __LINE__);
        }
        $this->TRIGGER = $tRIGGER;
        return $this;
    }
    /**
     * Add item to TRIGGER value
     * @throws \InvalidArgumentException
     * @param \StructType\TRIGGER $item
     * @return \StructType\NOTIFICATION_REGISTRATION
     */
    public function addToTRIGGER(\StructType\TRIGGER $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TRIGGER) {
            throw new \InvalidArgumentException(sprintf('The TRIGGER property can only contain items of type \StructType\TRIGGER, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TRIGGER[] = $item;
        return $this;
    }
    /**
     * Get CONSTRAINT value
     * @return \StructType\CONSTRAINT[]|null
     */
    public function getCONSTRAINT()
    {
        return $this->CONSTRAINT;
    }
    /**
     * This method is responsible for validating the values passed to the setCONSTRAINT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCONSTRAINT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCONSTRAINTForArrayConstraintsFromSetCONSTRAINT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nOTIFICATION_REGISTRATIONCONSTRAINTItem) {
            // validation for constraint: itemType
            if (!$nOTIFICATION_REGISTRATIONCONSTRAINTItem instanceof \StructType\CONSTRAINT) {
                $invalidValues[] = is_object($nOTIFICATION_REGISTRATIONCONSTRAINTItem) ? get_class($nOTIFICATION_REGISTRATIONCONSTRAINTItem) : sprintf('%s(%s)', gettype($nOTIFICATION_REGISTRATIONCONSTRAINTItem), var_export($nOTIFICATION_REGISTRATIONCONSTRAINTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CONSTRAINT property can only contain items of type \StructType\CONSTRAINT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CONSTRAINT value
     * @throws \InvalidArgumentException
     * @param \StructType\CONSTRAINT[] $cONSTRAINT
     * @return \StructType\NOTIFICATION_REGISTRATION
     */
    public function setCONSTRAINT(array $cONSTRAINT = array())
    {
        // validation for constraint: array
        if ('' !== ($cONSTRAINTArrayErrorMessage = self::validateCONSTRAINTForArrayConstraintsFromSetCONSTRAINT($cONSTRAINT))) {
            throw new \InvalidArgumentException($cONSTRAINTArrayErrorMessage, __LINE__);
        }
        $this->CONSTRAINT = $cONSTRAINT;
        return $this;
    }
    /**
     * Add item to CONSTRAINT value
     * @throws \InvalidArgumentException
     * @param \StructType\CONSTRAINT $item
     * @return \StructType\NOTIFICATION_REGISTRATION
     */
    public function addToCONSTRAINT(\StructType\CONSTRAINT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CONSTRAINT) {
            throw new \InvalidArgumentException(sprintf('The CONSTRAINT property can only contain items of type \StructType\CONSTRAINT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CONSTRAINT[] = $item;
        return $this;
    }
}
