<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NOTIFICATION-CONFIRM StructType
 * @subpackage Structs
 */
class NOTIFICATION_CONFIRM extends AbstractStructBase
{
    /**
     * The TASK_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $TASK_OBJID;
    /**
     * Constructor method for NOTIFICATION-CONFIRM
     * @uses NOTIFICATION_CONFIRM::setTASK_OBJID()
     * @param string $tASK_OBJID
     */
    public function __construct($tASK_OBJID = null)
    {
        $this
            ->setTASK_OBJID($tASK_OBJID);
    }
    /**
     * Get TASK_OBJID value
     * @return string
     */
    public function getTASK_OBJID()
    {
        return $this->{'TASK-OBJID'};
    }
    /**
     * Set TASK_OBJID value
     * @param string $tASK_OBJID
     * @return \StructType\NOTIFICATION_CONFIRM
     */
    public function setTASK_OBJID($tASK_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($tASK_OBJID) && !is_string($tASK_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tASK_OBJID, true), gettype($tASK_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($tASK_OBJID) && !preg_match('/([0-9])*/', $tASK_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($tASK_OBJID, true)), __LINE__);
        }
        $this->TASK_OBJID = $this->{'TASK-OBJID'} = $tASK_OBJID;
        return $this;
    }
}
