<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NEWSLETTER-SUBSCRIPTION StructType
 * @subpackage Structs
 */
class NEWSLETTER_SUBSCRIPTION extends AbstractStructBase
{
    /**
     * The emailsubscriptionhotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $emailsubscriptionhotel;
    /**
     * The emailsubscriptionpartner
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $emailsubscriptionpartner;
    /**
     * The emailsubscriptionstatus
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $emailsubscriptionstatus;
    /**
     * The emailsubscriptiondate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $emailsubscriptiondate;
    /**
     * Constructor method for NEWSLETTER-SUBSCRIPTION
     * @uses NEWSLETTER_SUBSCRIPTION::setEmailsubscriptionhotel()
     * @uses NEWSLETTER_SUBSCRIPTION::setEmailsubscriptionpartner()
     * @uses NEWSLETTER_SUBSCRIPTION::setEmailsubscriptionstatus()
     * @uses NEWSLETTER_SUBSCRIPTION::setEmailsubscriptiondate()
     * @param string $emailsubscriptionhotel
     * @param string $emailsubscriptionpartner
     * @param string $emailsubscriptionstatus
     * @param string $emailsubscriptiondate
     */
    public function __construct($emailsubscriptionhotel = null, $emailsubscriptionpartner = null, $emailsubscriptionstatus = null, $emailsubscriptiondate = null)
    {
        $this
            ->setEmailsubscriptionhotel($emailsubscriptionhotel)
            ->setEmailsubscriptionpartner($emailsubscriptionpartner)
            ->setEmailsubscriptionstatus($emailsubscriptionstatus)
            ->setEmailsubscriptiondate($emailsubscriptiondate);
    }
    /**
     * Get emailsubscriptionhotel value
     * @return string
     */
    public function getEmailsubscriptionhotel()
    {
        return $this->emailsubscriptionhotel;
    }
    /**
     * Set emailsubscriptionhotel value
     * @param string $emailsubscriptionhotel
     * @return \StructType\NEWSLETTER_SUBSCRIPTION
     */
    public function setEmailsubscriptionhotel($emailsubscriptionhotel = null)
    {
        // validation for constraint: string
        if (!is_null($emailsubscriptionhotel) && !is_string($emailsubscriptionhotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailsubscriptionhotel, true), gettype($emailsubscriptionhotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($emailsubscriptionhotel) && !preg_match('/([-+]){0,1}([0-9])*/', $emailsubscriptionhotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($emailsubscriptionhotel, true)), __LINE__);
        }
        $this->emailsubscriptionhotel = $emailsubscriptionhotel;
        return $this;
    }
    /**
     * Get emailsubscriptionpartner value
     * @return string
     */
    public function getEmailsubscriptionpartner()
    {
        return $this->emailsubscriptionpartner;
    }
    /**
     * Set emailsubscriptionpartner value
     * @param string $emailsubscriptionpartner
     * @return \StructType\NEWSLETTER_SUBSCRIPTION
     */
    public function setEmailsubscriptionpartner($emailsubscriptionpartner = null)
    {
        // validation for constraint: string
        if (!is_null($emailsubscriptionpartner) && !is_string($emailsubscriptionpartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailsubscriptionpartner, true), gettype($emailsubscriptionpartner)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($emailsubscriptionpartner) && !preg_match('/([-+]){0,1}([0-9])*/', $emailsubscriptionpartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($emailsubscriptionpartner, true)), __LINE__);
        }
        $this->emailsubscriptionpartner = $emailsubscriptionpartner;
        return $this;
    }
    /**
     * Get emailsubscriptionstatus value
     * @return string
     */
    public function getEmailsubscriptionstatus()
    {
        return $this->emailsubscriptionstatus;
    }
    /**
     * Set emailsubscriptionstatus value
     * @param string $emailsubscriptionstatus
     * @return \StructType\NEWSLETTER_SUBSCRIPTION
     */
    public function setEmailsubscriptionstatus($emailsubscriptionstatus = null)
    {
        // validation for constraint: string
        if (!is_null($emailsubscriptionstatus) && !is_string($emailsubscriptionstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailsubscriptionstatus, true), gettype($emailsubscriptionstatus)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($emailsubscriptionstatus) && mb_strlen($emailsubscriptionstatus) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($emailsubscriptionstatus)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($emailsubscriptionstatus) && mb_strlen($emailsubscriptionstatus) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($emailsubscriptionstatus)), __LINE__);
        }
        $this->emailsubscriptionstatus = $emailsubscriptionstatus;
        return $this;
    }
    /**
     * Get emailsubscriptiondate value
     * @return string
     */
    public function getEmailsubscriptiondate()
    {
        return $this->emailsubscriptiondate;
    }
    /**
     * Set emailsubscriptiondate value
     * @param string $emailsubscriptiondate
     * @return \StructType\NEWSLETTER_SUBSCRIPTION
     */
    public function setEmailsubscriptiondate($emailsubscriptiondate = null)
    {
        // validation for constraint: string
        if (!is_null($emailsubscriptiondate) && !is_string($emailsubscriptiondate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailsubscriptiondate, true), gettype($emailsubscriptiondate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($emailsubscriptiondate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $emailsubscriptiondate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($emailsubscriptiondate, true)), __LINE__);
        }
        $this->emailsubscriptiondate = $emailsubscriptiondate;
        return $this;
    }
}
