<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MainAccount StructType
 * @subpackage Structs
 */
class MainAccount extends AbstractStructBase
{
    /**
     * The ACCOUNT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ACCOUNT_OBJID;
    /**
     * The accounttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accounttype;
    /**
     * The accountno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $accountno;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The credit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $credit;
    /**
     * The debit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $debit;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $balance;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The eventno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $eventno;
    /**
     * The arrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $arrival;
    /**
     * The departure
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $departure;
    /**
     * The creditlimit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $creditlimit;
    /**
     * The nopost
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $nopost;
    /**
     * The paymentlink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentlink;
    /**
     * The paymentlinkembedded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paymentlinkembedded;
    /**
     * The Postings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Postings[]
     */
    public $Postings;
    /**
     * The InvoicedPostings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvoicedPostings[]
     */
    public $InvoicedPostings;
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payments[]
     */
    public $Payments;
    /**
     * The InvoicedPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvoicedPayments[]
     */
    public $InvoicedPayments;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Comments[]
     */
    public $Comments;
    /**
     * The InvoiceHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvoiceHolder[]
     */
    public $InvoiceHolder;
    /**
     * Constructor method for MainAccount
     * @uses MainAccount::setACCOUNT_OBJID()
     * @uses MainAccount::setAccounttype()
     * @uses MainAccount::setAccountno()
     * @uses MainAccount::setStatus()
     * @uses MainAccount::setCredit()
     * @uses MainAccount::setDebit()
     * @uses MainAccount::setBalance()
     * @uses MainAccount::setResno()
     * @uses MainAccount::setEventno()
     * @uses MainAccount::setArrival()
     * @uses MainAccount::setDeparture()
     * @uses MainAccount::setCreditlimit()
     * @uses MainAccount::setNopost()
     * @uses MainAccount::setPaymentlink()
     * @uses MainAccount::setPaymentlinkembedded()
     * @uses MainAccount::setPostings()
     * @uses MainAccount::setInvoicedPostings()
     * @uses MainAccount::setPayments()
     * @uses MainAccount::setInvoicedPayments()
     * @uses MainAccount::setComments()
     * @uses MainAccount::setInvoiceHolder()
     * @param string $aCCOUNT_OBJID
     * @param string $accounttype
     * @param string $accountno
     * @param string $status
     * @param string $credit
     * @param string $debit
     * @param string $balance
     * @param string $resno
     * @param string $eventno
     * @param string $arrival
     * @param string $departure
     * @param string $creditlimit
     * @param string $nopost
     * @param string $paymentlink
     * @param string $paymentlinkembedded
     * @param \StructType\Postings[] $postings
     * @param \StructType\InvoicedPostings[] $invoicedPostings
     * @param \StructType\Payments[] $payments
     * @param \StructType\InvoicedPayments[] $invoicedPayments
     * @param \StructType\Comments[] $comments
     * @param \StructType\InvoiceHolder[] $invoiceHolder
     */
    public function __construct($aCCOUNT_OBJID = null, $accounttype = null, $accountno = null, $status = null, $credit = null, $debit = null, $balance = null, $resno = null, $eventno = null, $arrival = null, $departure = null, $creditlimit = null, $nopost = null, $paymentlink = null, $paymentlinkembedded = null, array $postings = array(), array $invoicedPostings = array(), array $payments = array(), array $invoicedPayments = array(), array $comments = array(), array $invoiceHolder = array())
    {
        $this
            ->setACCOUNT_OBJID($aCCOUNT_OBJID)
            ->setAccounttype($accounttype)
            ->setAccountno($accountno)
            ->setStatus($status)
            ->setCredit($credit)
            ->setDebit($debit)
            ->setBalance($balance)
            ->setResno($resno)
            ->setEventno($eventno)
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setCreditlimit($creditlimit)
            ->setNopost($nopost)
            ->setPaymentlink($paymentlink)
            ->setPaymentlinkembedded($paymentlinkembedded)
            ->setPostings($postings)
            ->setInvoicedPostings($invoicedPostings)
            ->setPayments($payments)
            ->setInvoicedPayments($invoicedPayments)
            ->setComments($comments)
            ->setInvoiceHolder($invoiceHolder);
    }
    /**
     * Get ACCOUNT_OBJID value
     * @return string
     */
    public function getACCOUNT_OBJID()
    {
        return $this->{'ACCOUNT-OBJID'};
    }
    /**
     * Set ACCOUNT_OBJID value
     * @param string $aCCOUNT_OBJID
     * @return \StructType\MainAccount
     */
    public function setACCOUNT_OBJID($aCCOUNT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNT_OBJID) && !is_string($aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCCOUNT_OBJID, true), gettype($aCCOUNT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aCCOUNT_OBJID) && !preg_match('/([0-9])*/', $aCCOUNT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aCCOUNT_OBJID, true)), __LINE__);
        }
        $this->ACCOUNT_OBJID = $this->{'ACCOUNT-OBJID'} = $aCCOUNT_OBJID;
        return $this;
    }
    /**
     * Get accounttype value
     * @return string
     */
    public function getAccounttype()
    {
        return $this->accounttype;
    }
    /**
     * Set accounttype value
     * @param string $accounttype
     * @return \StructType\MainAccount
     */
    public function setAccounttype($accounttype = null)
    {
        // validation for constraint: string
        if (!is_null($accounttype) && !is_string($accounttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounttype, true), gettype($accounttype)), __LINE__);
        }
        $this->accounttype = $accounttype;
        return $this;
    }
    /**
     * Get accountno value
     * @return string
     */
    public function getAccountno()
    {
        return $this->accountno;
    }
    /**
     * Set accountno value
     * @param string $accountno
     * @return \StructType\MainAccount
     */
    public function setAccountno($accountno = null)
    {
        // validation for constraint: string
        if (!is_null($accountno) && !is_string($accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountno, true), gettype($accountno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($accountno) && !preg_match('/([-+]){0,1}([0-9])*/', $accountno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($accountno, true)), __LINE__);
        }
        $this->accountno = $accountno;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\MainAccount
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get credit value
     * @return string
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * Set credit value
     * @param string $credit
     * @return \StructType\MainAccount
     */
    public function setCredit($credit = null)
    {
        // validation for constraint: string
        if (!is_null($credit) && !is_string($credit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit, true), gettype($credit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($credit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $credit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($credit, true)), __LINE__);
        }
        $this->credit = $credit;
        return $this;
    }
    /**
     * Get debit value
     * @return string
     */
    public function getDebit()
    {
        return $this->debit;
    }
    /**
     * Set debit value
     * @param string $debit
     * @return \StructType\MainAccount
     */
    public function setDebit($debit = null)
    {
        // validation for constraint: string
        if (!is_null($debit) && !is_string($debit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debit, true), gettype($debit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($debit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $debit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($debit, true)), __LINE__);
        }
        $this->debit = $debit;
        return $this;
    }
    /**
     * Get balance value
     * @return string
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param string $balance
     * @return \StructType\MainAccount
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: string
        if (!is_null($balance) && !is_string($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($balance) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($balance, true)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\MainAccount
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get eventno value
     * @return string
     */
    public function getEventno()
    {
        return $this->eventno;
    }
    /**
     * Set eventno value
     * @param string $eventno
     * @return \StructType\MainAccount
     */
    public function setEventno($eventno = null)
    {
        // validation for constraint: string
        if (!is_null($eventno) && !is_string($eventno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventno, true), gettype($eventno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($eventno) && !preg_match('/([-+]){0,1}([0-9])*/', $eventno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($eventno, true)), __LINE__);
        }
        $this->eventno = $eventno;
        return $this;
    }
    /**
     * Get arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->arrival;
    }
    /**
     * Set arrival value
     * @param string $arrival
     * @return \StructType\MainAccount
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($arrival) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($arrival, true)), __LINE__);
        }
        $this->arrival = $arrival;
        return $this;
    }
    /**
     * Get departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->departure;
    }
    /**
     * Set departure value
     * @param string $departure
     * @return \StructType\MainAccount
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($departure) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($departure, true)), __LINE__);
        }
        $this->departure = $departure;
        return $this;
    }
    /**
     * Get creditlimit value
     * @return string
     */
    public function getCreditlimit()
    {
        return $this->creditlimit;
    }
    /**
     * Set creditlimit value
     * @param string $creditlimit
     * @return \StructType\MainAccount
     */
    public function setCreditlimit($creditlimit = null)
    {
        // validation for constraint: string
        if (!is_null($creditlimit) && !is_string($creditlimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditlimit, true), gettype($creditlimit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($creditlimit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $creditlimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($creditlimit, true)), __LINE__);
        }
        $this->creditlimit = $creditlimit;
        return $this;
    }
    /**
     * Get nopost value
     * @return string
     */
    public function getNopost()
    {
        return $this->nopost;
    }
    /**
     * Set nopost value
     * @param string $nopost
     * @return \StructType\MainAccount
     */
    public function setNopost($nopost = null)
    {
        // validation for constraint: string
        if (!is_null($nopost) && !is_string($nopost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nopost, true), gettype($nopost)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($nopost) && !preg_match('/([-+]){0,1}([0-9])*/', $nopost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($nopost, true)), __LINE__);
        }
        $this->nopost = $nopost;
        return $this;
    }
    /**
     * Get paymentlink value
     * @return string
     */
    public function getPaymentlink()
    {
        return $this->paymentlink;
    }
    /**
     * Set paymentlink value
     * @param string $paymentlink
     * @return \StructType\MainAccount
     */
    public function setPaymentlink($paymentlink = null)
    {
        // validation for constraint: string
        if (!is_null($paymentlink) && !is_string($paymentlink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentlink, true), gettype($paymentlink)), __LINE__);
        }
        $this->paymentlink = $paymentlink;
        return $this;
    }
    /**
     * Get paymentlinkembedded value
     * @return string
     */
    public function getPaymentlinkembedded()
    {
        return $this->paymentlinkembedded;
    }
    /**
     * Set paymentlinkembedded value
     * @param string $paymentlinkembedded
     * @return \StructType\MainAccount
     */
    public function setPaymentlinkembedded($paymentlinkembedded = null)
    {
        // validation for constraint: string
        if (!is_null($paymentlinkembedded) && !is_string($paymentlinkembedded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentlinkembedded, true), gettype($paymentlinkembedded)), __LINE__);
        }
        $this->paymentlinkembedded = $paymentlinkembedded;
        return $this;
    }
    /**
     * Get Postings value
     * @return \StructType\Postings[]|null
     */
    public function getPostings()
    {
        return $this->Postings;
    }
    /**
     * This method is responsible for validating the values passed to the setPostings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostingsForArrayConstraintsFromSetPostings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mainAccountPostingsItem) {
            // validation for constraint: itemType
            if (!$mainAccountPostingsItem instanceof \StructType\Postings) {
                $invalidValues[] = is_object($mainAccountPostingsItem) ? get_class($mainAccountPostingsItem) : sprintf('%s(%s)', gettype($mainAccountPostingsItem), var_export($mainAccountPostingsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Postings property can only contain items of type \StructType\Postings, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Postings value
     * @throws \InvalidArgumentException
     * @param \StructType\Postings[] $postings
     * @return \StructType\MainAccount
     */
    public function setPostings(array $postings = array())
    {
        // validation for constraint: array
        if ('' !== ($postingsArrayErrorMessage = self::validatePostingsForArrayConstraintsFromSetPostings($postings))) {
            throw new \InvalidArgumentException($postingsArrayErrorMessage, __LINE__);
        }
        $this->Postings = $postings;
        return $this;
    }
    /**
     * Add item to Postings value
     * @throws \InvalidArgumentException
     * @param \StructType\Postings $item
     * @return \StructType\MainAccount
     */
    public function addToPostings(\StructType\Postings $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Postings) {
            throw new \InvalidArgumentException(sprintf('The Postings property can only contain items of type \StructType\Postings, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Postings[] = $item;
        return $this;
    }
    /**
     * Get InvoicedPostings value
     * @return \StructType\InvoicedPostings[]|null
     */
    public function getInvoicedPostings()
    {
        return $this->InvoicedPostings;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoicedPostings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoicedPostings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoicedPostingsForArrayConstraintsFromSetInvoicedPostings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mainAccountInvoicedPostingsItem) {
            // validation for constraint: itemType
            if (!$mainAccountInvoicedPostingsItem instanceof \StructType\InvoicedPostings) {
                $invalidValues[] = is_object($mainAccountInvoicedPostingsItem) ? get_class($mainAccountInvoicedPostingsItem) : sprintf('%s(%s)', gettype($mainAccountInvoicedPostingsItem), var_export($mainAccountInvoicedPostingsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoicedPostings property can only contain items of type \StructType\InvoicedPostings, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoicedPostings value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicedPostings[] $invoicedPostings
     * @return \StructType\MainAccount
     */
    public function setInvoicedPostings(array $invoicedPostings = array())
    {
        // validation for constraint: array
        if ('' !== ($invoicedPostingsArrayErrorMessage = self::validateInvoicedPostingsForArrayConstraintsFromSetInvoicedPostings($invoicedPostings))) {
            throw new \InvalidArgumentException($invoicedPostingsArrayErrorMessage, __LINE__);
        }
        $this->InvoicedPostings = $invoicedPostings;
        return $this;
    }
    /**
     * Add item to InvoicedPostings value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicedPostings $item
     * @return \StructType\MainAccount
     */
    public function addToInvoicedPostings(\StructType\InvoicedPostings $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoicedPostings) {
            throw new \InvalidArgumentException(sprintf('The InvoicedPostings property can only contain items of type \StructType\InvoicedPostings, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoicedPostings[] = $item;
        return $this;
    }
    /**
     * Get Payments value
     * @return \StructType\Payments[]|null
     */
    public function getPayments()
    {
        return $this->Payments;
    }
    /**
     * This method is responsible for validating the values passed to the setPayments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentsForArrayConstraintsFromSetPayments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mainAccountPaymentsItem) {
            // validation for constraint: itemType
            if (!$mainAccountPaymentsItem instanceof \StructType\Payments) {
                $invalidValues[] = is_object($mainAccountPaymentsItem) ? get_class($mainAccountPaymentsItem) : sprintf('%s(%s)', gettype($mainAccountPaymentsItem), var_export($mainAccountPaymentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payments property can only contain items of type \StructType\Payments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payments value
     * @throws \InvalidArgumentException
     * @param \StructType\Payments[] $payments
     * @return \StructType\MainAccount
     */
    public function setPayments(array $payments = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentsArrayErrorMessage = self::validatePaymentsForArrayConstraintsFromSetPayments($payments))) {
            throw new \InvalidArgumentException($paymentsArrayErrorMessage, __LINE__);
        }
        $this->Payments = $payments;
        return $this;
    }
    /**
     * Add item to Payments value
     * @throws \InvalidArgumentException
     * @param \StructType\Payments $item
     * @return \StructType\MainAccount
     */
    public function addToPayments(\StructType\Payments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payments) {
            throw new \InvalidArgumentException(sprintf('The Payments property can only contain items of type \StructType\Payments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payments[] = $item;
        return $this;
    }
    /**
     * Get InvoicedPayments value
     * @return \StructType\InvoicedPayments[]|null
     */
    public function getInvoicedPayments()
    {
        return $this->InvoicedPayments;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoicedPayments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoicedPayments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoicedPaymentsForArrayConstraintsFromSetInvoicedPayments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mainAccountInvoicedPaymentsItem) {
            // validation for constraint: itemType
            if (!$mainAccountInvoicedPaymentsItem instanceof \StructType\InvoicedPayments) {
                $invalidValues[] = is_object($mainAccountInvoicedPaymentsItem) ? get_class($mainAccountInvoicedPaymentsItem) : sprintf('%s(%s)', gettype($mainAccountInvoicedPaymentsItem), var_export($mainAccountInvoicedPaymentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoicedPayments property can only contain items of type \StructType\InvoicedPayments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoicedPayments value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicedPayments[] $invoicedPayments
     * @return \StructType\MainAccount
     */
    public function setInvoicedPayments(array $invoicedPayments = array())
    {
        // validation for constraint: array
        if ('' !== ($invoicedPaymentsArrayErrorMessage = self::validateInvoicedPaymentsForArrayConstraintsFromSetInvoicedPayments($invoicedPayments))) {
            throw new \InvalidArgumentException($invoicedPaymentsArrayErrorMessage, __LINE__);
        }
        $this->InvoicedPayments = $invoicedPayments;
        return $this;
    }
    /**
     * Add item to InvoicedPayments value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicedPayments $item
     * @return \StructType\MainAccount
     */
    public function addToInvoicedPayments(\StructType\InvoicedPayments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoicedPayments) {
            throw new \InvalidArgumentException(sprintf('The InvoicedPayments property can only contain items of type \StructType\InvoicedPayments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoicedPayments[] = $item;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\Comments[]|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * This method is responsible for validating the values passed to the setComments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommentsForArrayConstraintsFromSetComments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mainAccountCommentsItem) {
            // validation for constraint: itemType
            if (!$mainAccountCommentsItem instanceof \StructType\Comments) {
                $invalidValues[] = is_object($mainAccountCommentsItem) ? get_class($mainAccountCommentsItem) : sprintf('%s(%s)', gettype($mainAccountCommentsItem), var_export($mainAccountCommentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Comments property can only contain items of type \StructType\Comments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Comments value
     * @throws \InvalidArgumentException
     * @param \StructType\Comments[] $comments
     * @return \StructType\MainAccount
     */
    public function setComments(array $comments = array())
    {
        // validation for constraint: array
        if ('' !== ($commentsArrayErrorMessage = self::validateCommentsForArrayConstraintsFromSetComments($comments))) {
            throw new \InvalidArgumentException($commentsArrayErrorMessage, __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Add item to Comments value
     * @throws \InvalidArgumentException
     * @param \StructType\Comments $item
     * @return \StructType\MainAccount
     */
    public function addToComments(\StructType\Comments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Comments) {
            throw new \InvalidArgumentException(sprintf('The Comments property can only contain items of type \StructType\Comments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Comments[] = $item;
        return $this;
    }
    /**
     * Get InvoiceHolder value
     * @return \StructType\InvoiceHolder[]|null
     */
    public function getInvoiceHolder()
    {
        return $this->InvoiceHolder;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceHolder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceHolder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceHolderForArrayConstraintsFromSetInvoiceHolder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mainAccountInvoiceHolderItem) {
            // validation for constraint: itemType
            if (!$mainAccountInvoiceHolderItem instanceof \StructType\InvoiceHolder) {
                $invalidValues[] = is_object($mainAccountInvoiceHolderItem) ? get_class($mainAccountInvoiceHolderItem) : sprintf('%s(%s)', gettype($mainAccountInvoiceHolderItem), var_export($mainAccountInvoiceHolderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceHolder property can only contain items of type \StructType\InvoiceHolder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceHolder value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceHolder[] $invoiceHolder
     * @return \StructType\MainAccount
     */
    public function setInvoiceHolder(array $invoiceHolder = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceHolderArrayErrorMessage = self::validateInvoiceHolderForArrayConstraintsFromSetInvoiceHolder($invoiceHolder))) {
            throw new \InvalidArgumentException($invoiceHolderArrayErrorMessage, __LINE__);
        }
        $this->InvoiceHolder = $invoiceHolder;
        return $this;
    }
    /**
     * Add item to InvoiceHolder value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceHolder $item
     * @return \StructType\MainAccount
     */
    public function addToInvoiceHolder(\StructType\InvoiceHolder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceHolder) {
            throw new \InvalidArgumentException(sprintf('The InvoiceHolder property can only contain items of type \StructType\InvoiceHolder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceHolder[] = $item;
        return $this;
    }
}
