<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LOST-AND-FOUND StructType
 * @subpackage Structs
 */
class LOST_AND_FOUND extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The guest
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $guest;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $room;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $location;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The return
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $return;
    /**
     * The LOST_AND_FOUND_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $LOST_AND_FOUND_OBJID;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $number;
    /**
     * The info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $info;
    /**
     * The hasimages
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hasimages;
    /**
     * The IMAGES
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IMAGES_1[]
     */
    public $IMAGES;
    /**
     * Constructor method for LOST-AND-FOUND
     * @uses LOST_AND_FOUND::setDate()
     * @uses LOST_AND_FOUND::setDescription()
     * @uses LOST_AND_FOUND::setGuest()
     * @uses LOST_AND_FOUND::setRoom()
     * @uses LOST_AND_FOUND::setLocation()
     * @uses LOST_AND_FOUND::setType()
     * @uses LOST_AND_FOUND::setStatus()
     * @uses LOST_AND_FOUND::setReturn()
     * @uses LOST_AND_FOUND::setLOST_AND_FOUND_OBJID()
     * @uses LOST_AND_FOUND::setNumber()
     * @uses LOST_AND_FOUND::setInfo()
     * @uses LOST_AND_FOUND::setHasimages()
     * @uses LOST_AND_FOUND::setIMAGES()
     * @param string $date
     * @param string $description
     * @param string $guest
     * @param string $room
     * @param string $location
     * @param string $type
     * @param string $status
     * @param string $return
     * @param string $lOST_AND_FOUND_OBJID
     * @param string $number
     * @param string $info
     * @param string $hasimages
     * @param \StructType\IMAGES_1[] $iMAGES
     */
    public function __construct($date = null, $description = null, $guest = null, $room = null, $location = null, $type = null, $status = null, $return = null, $lOST_AND_FOUND_OBJID = null, $number = null, $info = null, $hasimages = null, array $iMAGES = array())
    {
        $this
            ->setDate($date)
            ->setDescription($description)
            ->setGuest($guest)
            ->setRoom($room)
            ->setLocation($location)
            ->setType($type)
            ->setStatus($status)
            ->setReturn($return)
            ->setLOST_AND_FOUND_OBJID($lOST_AND_FOUND_OBJID)
            ->setNumber($number)
            ->setInfo($info)
            ->setHasimages($hasimages)
            ->setIMAGES($iMAGES);
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\LOST_AND_FOUND
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LOST_AND_FOUND
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($description) && mb_strlen($description) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get guest value
     * @return string
     */
    public function getGuest()
    {
        return $this->guest;
    }
    /**
     * Set guest value
     * @param string $guest
     * @return \StructType\LOST_AND_FOUND
     */
    public function setGuest($guest = null)
    {
        // validation for constraint: string
        if (!is_null($guest) && !is_string($guest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guest, true), gettype($guest)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($guest) && mb_strlen($guest) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($guest)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guest) && mb_strlen($guest) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guest)), __LINE__);
        }
        $this->guest = $guest;
        return $this;
    }
    /**
     * Get room value
     * @return string
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\LOST_AND_FOUND
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get location value
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\LOST_AND_FOUND
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($location) && mb_strlen($location) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($location)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($location) && mb_strlen($location) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\LOST_AND_FOUND
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($type) && mb_strlen($type) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($type) && mb_strlen($type) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\LOST_AND_FOUND
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get return value
     * @return string
     */
    public function getReturn()
    {
        return $this->return;
    }
    /**
     * Set return value
     * @param string $return
     * @return \StructType\LOST_AND_FOUND
     */
    public function setReturn($return = null)
    {
        // validation for constraint: string
        if (!is_null($return) && !is_string($return)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return, true), gettype($return)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($return) && mb_strlen($return) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($return)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($return) && mb_strlen($return) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($return)), __LINE__);
        }
        $this->return = $return;
        return $this;
    }
    /**
     * Get LOST_AND_FOUND_OBJID value
     * @return string
     */
    public function getLOST_AND_FOUND_OBJID()
    {
        return $this->{'LOST-AND-FOUND-OBJID'};
    }
    /**
     * Set LOST_AND_FOUND_OBJID value
     * @param string $lOST_AND_FOUND_OBJID
     * @return \StructType\LOST_AND_FOUND
     */
    public function setLOST_AND_FOUND_OBJID($lOST_AND_FOUND_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($lOST_AND_FOUND_OBJID) && !is_string($lOST_AND_FOUND_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lOST_AND_FOUND_OBJID, true), gettype($lOST_AND_FOUND_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($lOST_AND_FOUND_OBJID) && !preg_match('/([0-9])*/', $lOST_AND_FOUND_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($lOST_AND_FOUND_OBJID, true)), __LINE__);
        }
        $this->LOST_AND_FOUND_OBJID = $this->{'LOST-AND-FOUND-OBJID'} = $lOST_AND_FOUND_OBJID;
        return $this;
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\LOST_AND_FOUND
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($number) && !preg_match('/([-+]){0,1}([0-9])*/', $number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($number, true)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get info value
     * @return string
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param string $info
     * @return \StructType\LOST_AND_FOUND
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Get hasimages value
     * @return string
     */
    public function getHasimages()
    {
        return $this->hasimages;
    }
    /**
     * Set hasimages value
     * @param string $hasimages
     * @return \StructType\LOST_AND_FOUND
     */
    public function setHasimages($hasimages = null)
    {
        // validation for constraint: string
        if (!is_null($hasimages) && !is_string($hasimages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hasimages, true), gettype($hasimages)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hasimages) && !preg_match('/([-+]){0,1}([0-9])*/', $hasimages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hasimages, true)), __LINE__);
        }
        $this->hasimages = $hasimages;
        return $this;
    }
    /**
     * Get IMAGES value
     * @return \StructType\IMAGES_1[]|null
     */
    public function getIMAGES()
    {
        return $this->IMAGES;
    }
    /**
     * This method is responsible for validating the values passed to the setIMAGES method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIMAGES method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIMAGESForArrayConstraintsFromSetIMAGES(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lOST_AND_FOUNDIMAGESItem) {
            // validation for constraint: itemType
            if (!$lOST_AND_FOUNDIMAGESItem instanceof \StructType\IMAGES_1) {
                $invalidValues[] = is_object($lOST_AND_FOUNDIMAGESItem) ? get_class($lOST_AND_FOUNDIMAGESItem) : sprintf('%s(%s)', gettype($lOST_AND_FOUNDIMAGESItem), var_export($lOST_AND_FOUNDIMAGESItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IMAGES property can only contain items of type \StructType\IMAGES_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IMAGES value
     * @throws \InvalidArgumentException
     * @param \StructType\IMAGES_1[] $iMAGES
     * @return \StructType\LOST_AND_FOUND
     */
    public function setIMAGES(array $iMAGES = array())
    {
        // validation for constraint: array
        if ('' !== ($iMAGESArrayErrorMessage = self::validateIMAGESForArrayConstraintsFromSetIMAGES($iMAGES))) {
            throw new \InvalidArgumentException($iMAGESArrayErrorMessage, __LINE__);
        }
        $this->IMAGES = $iMAGES;
        return $this;
    }
    /**
     * Add item to IMAGES value
     * @throws \InvalidArgumentException
     * @param \StructType\IMAGES_1 $item
     * @return \StructType\LOST_AND_FOUND
     */
    public function addToIMAGES(\StructType\IMAGES_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IMAGES_1) {
            throw new \InvalidArgumentException(sprintf('The IMAGES property can only contain items of type \StructType\IMAGES_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IMAGES[] = $item;
        return $this;
    }
}
