<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoicedPosting StructType
 * @subpackage Structs
 */
class InvoicedPosting extends AbstractStructBase
{
    /**
     * The POSTING_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $POSTING_OBJID;
    /**
     * The paidincomplete
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $paidincomplete;
    /**
     * The hoteldate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $hoteldate;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $packages;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The descriptionlst
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $descriptionlst;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $quantity;
    /**
     * The priceperunit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $priceperunit;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The currencyamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyamount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The guestname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guestname;
    /**
     * The originalroom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $originalroom;
    /**
     * The invoiceno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $invoiceno;
    /**
     * The invoicenoset
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $invoicenoset;
    /**
     * The externaldocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $externaldocument;
    /**
     * The externalinvoiceno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $externalinvoiceno;
    /**
     * The waiter
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $waiter;
    /**
     * The outlet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $outlet;
    /**
     * Constructor method for InvoicedPosting
     * @uses InvoicedPosting::setPOSTING_OBJID()
     * @uses InvoicedPosting::setPaidincomplete()
     * @uses InvoicedPosting::setHoteldate()
     * @uses InvoicedPosting::setPackages()
     * @uses InvoicedPosting::setService()
     * @uses InvoicedPosting::setDescriptionlst()
     * @uses InvoicedPosting::setQuantity()
     * @uses InvoicedPosting::setPriceperunit()
     * @uses InvoicedPosting::setAmount()
     * @uses InvoicedPosting::setCurrencyamount()
     * @uses InvoicedPosting::setCurrency()
     * @uses InvoicedPosting::setGuestname()
     * @uses InvoicedPosting::setOriginalroom()
     * @uses InvoicedPosting::setInvoiceno()
     * @uses InvoicedPosting::setInvoicenoset()
     * @uses InvoicedPosting::setExternaldocument()
     * @uses InvoicedPosting::setExternalinvoiceno()
     * @uses InvoicedPosting::setWaiter()
     * @uses InvoicedPosting::setOutlet()
     * @param string $pOSTING_OBJID
     * @param string $paidincomplete
     * @param string $hoteldate
     * @param string $packages
     * @param string $service
     * @param string $descriptionlst
     * @param string $quantity
     * @param string $priceperunit
     * @param string $amount
     * @param string $currencyamount
     * @param string $currency
     * @param string $guestname
     * @param string $originalroom
     * @param string $invoiceno
     * @param string $invoicenoset
     * @param string $externaldocument
     * @param string $externalinvoiceno
     * @param string $waiter
     * @param string $outlet
     */
    public function __construct($pOSTING_OBJID = null, $paidincomplete = null, $hoteldate = null, $packages = null, $service = null, $descriptionlst = null, $quantity = null, $priceperunit = null, $amount = null, $currencyamount = null, $currency = null, $guestname = null, $originalroom = null, $invoiceno = null, $invoicenoset = null, $externaldocument = null, $externalinvoiceno = null, $waiter = null, $outlet = null)
    {
        $this
            ->setPOSTING_OBJID($pOSTING_OBJID)
            ->setPaidincomplete($paidincomplete)
            ->setHoteldate($hoteldate)
            ->setPackages($packages)
            ->setService($service)
            ->setDescriptionlst($descriptionlst)
            ->setQuantity($quantity)
            ->setPriceperunit($priceperunit)
            ->setAmount($amount)
            ->setCurrencyamount($currencyamount)
            ->setCurrency($currency)
            ->setGuestname($guestname)
            ->setOriginalroom($originalroom)
            ->setInvoiceno($invoiceno)
            ->setInvoicenoset($invoicenoset)
            ->setExternaldocument($externaldocument)
            ->setExternalinvoiceno($externalinvoiceno)
            ->setWaiter($waiter)
            ->setOutlet($outlet);
    }
    /**
     * Get POSTING_OBJID value
     * @return string
     */
    public function getPOSTING_OBJID()
    {
        return $this->{'POSTING-OBJID'};
    }
    /**
     * Set POSTING_OBJID value
     * @param string $pOSTING_OBJID
     * @return \StructType\InvoicedPosting
     */
    public function setPOSTING_OBJID($pOSTING_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pOSTING_OBJID) && !is_string($pOSTING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOSTING_OBJID, true), gettype($pOSTING_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pOSTING_OBJID) && !preg_match('/([0-9])*/', $pOSTING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pOSTING_OBJID, true)), __LINE__);
        }
        $this->POSTING_OBJID = $this->{'POSTING-OBJID'} = $pOSTING_OBJID;
        return $this;
    }
    /**
     * Get paidincomplete value
     * @return string
     */
    public function getPaidincomplete()
    {
        return $this->paidincomplete;
    }
    /**
     * Set paidincomplete value
     * @param string $paidincomplete
     * @return \StructType\InvoicedPosting
     */
    public function setPaidincomplete($paidincomplete = null)
    {
        // validation for constraint: string
        if (!is_null($paidincomplete) && !is_string($paidincomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidincomplete, true), gettype($paidincomplete)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($paidincomplete) && !preg_match('/([-+]){0,1}([0-9])*/', $paidincomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($paidincomplete, true)), __LINE__);
        }
        $this->paidincomplete = $paidincomplete;
        return $this;
    }
    /**
     * Get hoteldate value
     * @return string
     */
    public function getHoteldate()
    {
        return $this->hoteldate;
    }
    /**
     * Set hoteldate value
     * @param string $hoteldate
     * @return \StructType\InvoicedPosting
     */
    public function setHoteldate($hoteldate = null)
    {
        // validation for constraint: string
        if (!is_null($hoteldate) && !is_string($hoteldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoteldate, true), gettype($hoteldate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($hoteldate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $hoteldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($hoteldate, true)), __LINE__);
        }
        $this->hoteldate = $hoteldate;
        return $this;
    }
    /**
     * Get packages value
     * @return string
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * Set packages value
     * @param string $packages
     * @return \StructType\InvoicedPosting
     */
    public function setPackages($packages = null)
    {
        // validation for constraint: string
        if (!is_null($packages) && !is_string($packages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packages, true), gettype($packages)), __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\InvoicedPosting
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get descriptionlst value
     * @return string
     */
    public function getDescriptionlst()
    {
        return $this->descriptionlst;
    }
    /**
     * Set descriptionlst value
     * @param string $descriptionlst
     * @return \StructType\InvoicedPosting
     */
    public function setDescriptionlst($descriptionlst = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionlst) && !is_string($descriptionlst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionlst, true), gettype($descriptionlst)), __LINE__);
        }
        $this->descriptionlst = $descriptionlst;
        return $this;
    }
    /**
     * Get quantity value
     * @return string
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\InvoicedPosting
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($quantity) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($quantity, true)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get priceperunit value
     * @return string
     */
    public function getPriceperunit()
    {
        return $this->priceperunit;
    }
    /**
     * Set priceperunit value
     * @param string $priceperunit
     * @return \StructType\InvoicedPosting
     */
    public function setPriceperunit($priceperunit = null)
    {
        // validation for constraint: string
        if (!is_null($priceperunit) && !is_string($priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceperunit, true), gettype($priceperunit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($priceperunit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($priceperunit, true)), __LINE__);
        }
        $this->priceperunit = $priceperunit;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\InvoicedPosting
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currencyamount value
     * @return string
     */
    public function getCurrencyamount()
    {
        return $this->currencyamount;
    }
    /**
     * Set currencyamount value
     * @param string $currencyamount
     * @return \StructType\InvoicedPosting
     */
    public function setCurrencyamount($currencyamount = null)
    {
        // validation for constraint: string
        if (!is_null($currencyamount) && !is_string($currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyamount, true), gettype($currencyamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyamount, true)), __LINE__);
        }
        $this->currencyamount = $currencyamount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\InvoicedPosting
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get guestname value
     * @return string
     */
    public function getGuestname()
    {
        return $this->guestname;
    }
    /**
     * Set guestname value
     * @param string $guestname
     * @return \StructType\InvoicedPosting
     */
    public function setGuestname($guestname = null)
    {
        // validation for constraint: string
        if (!is_null($guestname) && !is_string($guestname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestname, true), gettype($guestname)), __LINE__);
        }
        $this->guestname = $guestname;
        return $this;
    }
    /**
     * Get originalroom value
     * @return string
     */
    public function getOriginalroom()
    {
        return $this->originalroom;
    }
    /**
     * Set originalroom value
     * @param string $originalroom
     * @return \StructType\InvoicedPosting
     */
    public function setOriginalroom($originalroom = null)
    {
        // validation for constraint: string
        if (!is_null($originalroom) && !is_string($originalroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalroom, true), gettype($originalroom)), __LINE__);
        }
        $this->originalroom = $originalroom;
        return $this;
    }
    /**
     * Get invoiceno value
     * @return string
     */
    public function getInvoiceno()
    {
        return $this->invoiceno;
    }
    /**
     * Set invoiceno value
     * @param string $invoiceno
     * @return \StructType\InvoicedPosting
     */
    public function setInvoiceno($invoiceno = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceno) && !is_string($invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceno, true), gettype($invoiceno)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($invoiceno) && !preg_match('/([0-9])*/', $invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($invoiceno, true)), __LINE__);
        }
        $this->invoiceno = $invoiceno;
        return $this;
    }
    /**
     * Get invoicenoset value
     * @return string
     */
    public function getInvoicenoset()
    {
        return $this->invoicenoset;
    }
    /**
     * Set invoicenoset value
     * @param string $invoicenoset
     * @return \StructType\InvoicedPosting
     */
    public function setInvoicenoset($invoicenoset = null)
    {
        // validation for constraint: string
        if (!is_null($invoicenoset) && !is_string($invoicenoset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicenoset, true), gettype($invoicenoset)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($invoicenoset) && mb_strlen($invoicenoset) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($invoicenoset)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($invoicenoset) && mb_strlen($invoicenoset) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($invoicenoset)), __LINE__);
        }
        $this->invoicenoset = $invoicenoset;
        return $this;
    }
    /**
     * Get externaldocument value
     * @return string
     */
    public function getExternaldocument()
    {
        return $this->externaldocument;
    }
    /**
     * Set externaldocument value
     * @param string $externaldocument
     * @return \StructType\InvoicedPosting
     */
    public function setExternaldocument($externaldocument = null)
    {
        // validation for constraint: string
        if (!is_null($externaldocument) && !is_string($externaldocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externaldocument, true), gettype($externaldocument)), __LINE__);
        }
        $this->externaldocument = $externaldocument;
        return $this;
    }
    /**
     * Get externalinvoiceno value
     * @return string
     */
    public function getExternalinvoiceno()
    {
        return $this->externalinvoiceno;
    }
    /**
     * Set externalinvoiceno value
     * @param string $externalinvoiceno
     * @return \StructType\InvoicedPosting
     */
    public function setExternalinvoiceno($externalinvoiceno = null)
    {
        // validation for constraint: string
        if (!is_null($externalinvoiceno) && !is_string($externalinvoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalinvoiceno, true), gettype($externalinvoiceno)), __LINE__);
        }
        $this->externalinvoiceno = $externalinvoiceno;
        return $this;
    }
    /**
     * Get waiter value
     * @return string
     */
    public function getWaiter()
    {
        return $this->waiter;
    }
    /**
     * Set waiter value
     * @param string $waiter
     * @return \StructType\InvoicedPosting
     */
    public function setWaiter($waiter = null)
    {
        // validation for constraint: string
        if (!is_null($waiter) && !is_string($waiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waiter, true), gettype($waiter)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($waiter) && !preg_match('/([-+]){0,1}([0-9])*/', $waiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($waiter, true)), __LINE__);
        }
        $this->waiter = $waiter;
        return $this;
    }
    /**
     * Get outlet value
     * @return string
     */
    public function getOutlet()
    {
        return $this->outlet;
    }
    /**
     * Set outlet value
     * @param string $outlet
     * @return \StructType\InvoicedPosting
     */
    public function setOutlet($outlet = null)
    {
        // validation for constraint: string
        if (!is_null($outlet) && !is_string($outlet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outlet, true), gettype($outlet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($outlet) && !preg_match('/([-+]){0,1}([0-9])*/', $outlet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($outlet, true)), __LINE__);
        }
        $this->outlet = $outlet;
        return $this;
    }
}
