<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoicedPayment StructType
 * @subpackage Structs
 */
class InvoicedPayment extends AbstractStructBase
{
    /**
     * The PAYMENT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PAYMENT_OBJID;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The invoicetext
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoicetext;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The currencyamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyamount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The originalroom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $originalroom;
    /**
     * The guestname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guestname;
    /**
     * The invoiceno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $invoiceno;
    /**
     * The invoicenoset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoicenoset;
    /**
     * The receiptnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $receiptnumber;
    /**
     * The shift
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $shift;
    /**
     * The approvalNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $approvalNumber;
    /**
     * The processingdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $processingdate;
    /**
     * The interfacePartner
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $interfacePartner;
    /**
     * Constructor method for InvoicedPayment
     * @uses InvoicedPayment::setPAYMENT_OBJID()
     * @uses InvoicedPayment::setDate()
     * @uses InvoicedPayment::setTypeofpayment()
     * @uses InvoicedPayment::setInvoicetext()
     * @uses InvoicedPayment::setAmount()
     * @uses InvoicedPayment::setCurrencyamount()
     * @uses InvoicedPayment::setCurrency()
     * @uses InvoicedPayment::setOriginalroom()
     * @uses InvoicedPayment::setGuestname()
     * @uses InvoicedPayment::setInvoiceno()
     * @uses InvoicedPayment::setInvoicenoset()
     * @uses InvoicedPayment::setReceiptnumber()
     * @uses InvoicedPayment::setShift()
     * @uses InvoicedPayment::setApprovalNumber()
     * @uses InvoicedPayment::setProcessingdate()
     * @uses InvoicedPayment::setInterfacePartner()
     * @param string $pAYMENT_OBJID
     * @param string $date
     * @param string $typeofpayment
     * @param string $invoicetext
     * @param string $amount
     * @param string $currencyamount
     * @param string $currency
     * @param string $originalroom
     * @param string $guestname
     * @param string $invoiceno
     * @param string $invoicenoset
     * @param string $receiptnumber
     * @param string $shift
     * @param string $approvalNumber
     * @param string $processingdate
     * @param string $interfacePartner
     */
    public function __construct($pAYMENT_OBJID = null, $date = null, $typeofpayment = null, $invoicetext = null, $amount = null, $currencyamount = null, $currency = null, $originalroom = null, $guestname = null, $invoiceno = null, $invoicenoset = null, $receiptnumber = null, $shift = null, $approvalNumber = null, $processingdate = null, $interfacePartner = null)
    {
        $this
            ->setPAYMENT_OBJID($pAYMENT_OBJID)
            ->setDate($date)
            ->setTypeofpayment($typeofpayment)
            ->setInvoicetext($invoicetext)
            ->setAmount($amount)
            ->setCurrencyamount($currencyamount)
            ->setCurrency($currency)
            ->setOriginalroom($originalroom)
            ->setGuestname($guestname)
            ->setInvoiceno($invoiceno)
            ->setInvoicenoset($invoicenoset)
            ->setReceiptnumber($receiptnumber)
            ->setShift($shift)
            ->setApprovalNumber($approvalNumber)
            ->setProcessingdate($processingdate)
            ->setInterfacePartner($interfacePartner);
    }
    /**
     * Get PAYMENT_OBJID value
     * @return string
     */
    public function getPAYMENT_OBJID()
    {
        return $this->{'PAYMENT-OBJID'};
    }
    /**
     * Set PAYMENT_OBJID value
     * @param string $pAYMENT_OBJID
     * @return \StructType\InvoicedPayment
     */
    public function setPAYMENT_OBJID($pAYMENT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pAYMENT_OBJID) && !is_string($pAYMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAYMENT_OBJID, true), gettype($pAYMENT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pAYMENT_OBJID) && !preg_match('/([0-9])*/', $pAYMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pAYMENT_OBJID, true)), __LINE__);
        }
        $this->PAYMENT_OBJID = $this->{'PAYMENT-OBJID'} = $pAYMENT_OBJID;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\InvoicedPayment
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\InvoicedPayment
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get invoicetext value
     * @return string
     */
    public function getInvoicetext()
    {
        return $this->invoicetext;
    }
    /**
     * Set invoicetext value
     * @param string $invoicetext
     * @return \StructType\InvoicedPayment
     */
    public function setInvoicetext($invoicetext = null)
    {
        // validation for constraint: string
        if (!is_null($invoicetext) && !is_string($invoicetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicetext, true), gettype($invoicetext)), __LINE__);
        }
        $this->invoicetext = $invoicetext;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\InvoicedPayment
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currencyamount value
     * @return string
     */
    public function getCurrencyamount()
    {
        return $this->currencyamount;
    }
    /**
     * Set currencyamount value
     * @param string $currencyamount
     * @return \StructType\InvoicedPayment
     */
    public function setCurrencyamount($currencyamount = null)
    {
        // validation for constraint: string
        if (!is_null($currencyamount) && !is_string($currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyamount, true), gettype($currencyamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyamount, true)), __LINE__);
        }
        $this->currencyamount = $currencyamount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\InvoicedPayment
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get originalroom value
     * @return string
     */
    public function getOriginalroom()
    {
        return $this->originalroom;
    }
    /**
     * Set originalroom value
     * @param string $originalroom
     * @return \StructType\InvoicedPayment
     */
    public function setOriginalroom($originalroom = null)
    {
        // validation for constraint: string
        if (!is_null($originalroom) && !is_string($originalroom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalroom, true), gettype($originalroom)), __LINE__);
        }
        $this->originalroom = $originalroom;
        return $this;
    }
    /**
     * Get guestname value
     * @return string
     */
    public function getGuestname()
    {
        return $this->guestname;
    }
    /**
     * Set guestname value
     * @param string $guestname
     * @return \StructType\InvoicedPayment
     */
    public function setGuestname($guestname = null)
    {
        // validation for constraint: string
        if (!is_null($guestname) && !is_string($guestname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestname, true), gettype($guestname)), __LINE__);
        }
        $this->guestname = $guestname;
        return $this;
    }
    /**
     * Get invoiceno value
     * @return string
     */
    public function getInvoiceno()
    {
        return $this->invoiceno;
    }
    /**
     * Set invoiceno value
     * @param string $invoiceno
     * @return \StructType\InvoicedPayment
     */
    public function setInvoiceno($invoiceno = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceno) && !is_string($invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceno, true), gettype($invoiceno)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($invoiceno) && !preg_match('/([0-9])*/', $invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($invoiceno, true)), __LINE__);
        }
        $this->invoiceno = $invoiceno;
        return $this;
    }
    /**
     * Get invoicenoset value
     * @return string
     */
    public function getInvoicenoset()
    {
        return $this->invoicenoset;
    }
    /**
     * Set invoicenoset value
     * @param string $invoicenoset
     * @return \StructType\InvoicedPayment
     */
    public function setInvoicenoset($invoicenoset = null)
    {
        // validation for constraint: string
        if (!is_null($invoicenoset) && !is_string($invoicenoset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicenoset, true), gettype($invoicenoset)), __LINE__);
        }
        $this->invoicenoset = $invoicenoset;
        return $this;
    }
    /**
     * Get receiptnumber value
     * @return string
     */
    public function getReceiptnumber()
    {
        return $this->receiptnumber;
    }
    /**
     * Set receiptnumber value
     * @param string $receiptnumber
     * @return \StructType\InvoicedPayment
     */
    public function setReceiptnumber($receiptnumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiptnumber) && !is_string($receiptnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptnumber, true), gettype($receiptnumber)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($receiptnumber) && !preg_match('/([-+]){0,1}([0-9])*/', $receiptnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($receiptnumber, true)), __LINE__);
        }
        $this->receiptnumber = $receiptnumber;
        return $this;
    }
    /**
     * Get shift value
     * @return string
     */
    public function getShift()
    {
        return $this->shift;
    }
    /**
     * Set shift value
     * @param string $shift
     * @return \StructType\InvoicedPayment
     */
    public function setShift($shift = null)
    {
        // validation for constraint: string
        if (!is_null($shift) && !is_string($shift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shift, true), gettype($shift)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($shift) && !preg_match('/([-+]){0,1}([0-9])*/', $shift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($shift, true)), __LINE__);
        }
        $this->shift = $shift;
        return $this;
    }
    /**
     * Get approvalNumber value
     * @return string
     */
    public function getApprovalNumber()
    {
        return $this->approvalNumber;
    }
    /**
     * Set approvalNumber value
     * @param string $approvalNumber
     * @return \StructType\InvoicedPayment
     */
    public function setApprovalNumber($approvalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($approvalNumber) && !is_string($approvalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalNumber, true), gettype($approvalNumber)), __LINE__);
        }
        $this->approvalNumber = $approvalNumber;
        return $this;
    }
    /**
     * Get processingdate value
     * @return string
     */
    public function getProcessingdate()
    {
        return $this->processingdate;
    }
    /**
     * Set processingdate value
     * @param string $processingdate
     * @return \StructType\InvoicedPayment
     */
    public function setProcessingdate($processingdate = null)
    {
        // validation for constraint: string
        if (!is_null($processingdate) && !is_string($processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processingdate, true), gettype($processingdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($processingdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($processingdate, true)), __LINE__);
        }
        $this->processingdate = $processingdate;
        return $this;
    }
    /**
     * Get interfacePartner value
     * @return string
     */
    public function getInterfacePartner()
    {
        return $this->interfacePartner;
    }
    /**
     * Set interfacePartner value
     * @param string $interfacePartner
     * @return \StructType\InvoicedPayment
     */
    public function setInterfacePartner($interfacePartner = null)
    {
        // validation for constraint: string
        if (!is_null($interfacePartner) && !is_string($interfacePartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interfacePartner, true), gettype($interfacePartner)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($interfacePartner) && !preg_match('/([-+]){0,1}([0-9])*/', $interfacePartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($interfacePartner, true)), __LINE__);
        }
        $this->interfacePartner = $interfacePartner;
        return $this;
    }
}
