<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageManager StructType
 * @subpackage Structs
 */
class ImageManager extends AbstractStructBase
{
    /**
     * The refobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $refobjid;
    /**
     * The reftablename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reftablename;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Images[]
     */
    public $Images;
    /**
     * Constructor method for ImageManager
     * @uses ImageManager::setRefobjid()
     * @uses ImageManager::setReftablename()
     * @uses ImageManager::setImages()
     * @param string $refobjid
     * @param string $reftablename
     * @param \StructType\Images[] $images
     */
    public function __construct($refobjid = null, $reftablename = null, array $images = array())
    {
        $this
            ->setRefobjid($refobjid)
            ->setReftablename($reftablename)
            ->setImages($images);
    }
    /**
     * Get refobjid value
     * @return string|null
     */
    public function getRefobjid()
    {
        return $this->refobjid;
    }
    /**
     * Set refobjid value
     * @param string $refobjid
     * @return \StructType\ImageManager
     */
    public function setRefobjid($refobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refobjid) && !is_string($refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refobjid, true), gettype($refobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refobjid) && !preg_match('/([0-9])*/', $refobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refobjid, true)), __LINE__);
        }
        $this->refobjid = $refobjid;
        return $this;
    }
    /**
     * Get reftablename value
     * @return string|null
     */
    public function getReftablename()
    {
        return $this->reftablename;
    }
    /**
     * Set reftablename value
     * @param string $reftablename
     * @return \StructType\ImageManager
     */
    public function setReftablename($reftablename = null)
    {
        // validation for constraint: string
        if (!is_null($reftablename) && !is_string($reftablename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reftablename, true), gettype($reftablename)), __LINE__);
        }
        $this->reftablename = $reftablename;
        return $this;
    }
    /**
     * Get Images value
     * @return \StructType\Images[]|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * This method is responsible for validating the values passed to the setImages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImagesForArrayConstraintsFromSetImages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imageManagerImagesItem) {
            // validation for constraint: itemType
            if (!$imageManagerImagesItem instanceof \StructType\Images) {
                $invalidValues[] = is_object($imageManagerImagesItem) ? get_class($imageManagerImagesItem) : sprintf('%s(%s)', gettype($imageManagerImagesItem), var_export($imageManagerImagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Images property can only contain items of type \StructType\Images, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Images value
     * @throws \InvalidArgumentException
     * @param \StructType\Images[] $images
     * @return \StructType\ImageManager
     */
    public function setImages(array $images = array())
    {
        // validation for constraint: array
        if ('' !== ($imagesArrayErrorMessage = self::validateImagesForArrayConstraintsFromSetImages($images))) {
            throw new \InvalidArgumentException($imagesArrayErrorMessage, __LINE__);
        }
        $this->Images = $images;
        return $this;
    }
    /**
     * Add item to Images value
     * @throws \InvalidArgumentException
     * @param \StructType\Images $item
     * @return \StructType\ImageManager
     */
    public function addToImages(\StructType\Images $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Images) {
            throw new \InvalidArgumentException(sprintf('The Images property can only contain items of type \StructType\Images, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Images[] = $item;
        return $this;
    }
}
