<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICE-HOLDER StructType
 * @subpackage Structs
 */
class INVOICE_HOLDER extends AbstractStructBase
{
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The INVOICE_HOLDER_CONTACT_PERSON_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $INVOICE_HOLDER_CONTACT_PERSON_OBJID;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $firstName;
    /**
     * The INVOICE_HOLDER_CONTACTPERSON_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $INVOICE_HOLDER_CONTACTPERSON_OBJID;
    /**
     * The INVOICE_HOLDER_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $INVOICE_HOLDER_OBJID;
    /**
     * The INVOICE_HOLDER_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $INVOICE_HOLDER_CENTRALID;
    /**
     * Constructor method for INVOICE-HOLDER
     * @uses INVOICE_HOLDER::setName1()
     * @uses INVOICE_HOLDER::setName2()
     * @uses INVOICE_HOLDER::setINVOICE_HOLDER_CONTACT_PERSON_OBJID()
     * @uses INVOICE_HOLDER::setAddress()
     * @uses INVOICE_HOLDER::setLastName()
     * @uses INVOICE_HOLDER::setFirstName()
     * @uses INVOICE_HOLDER::setINVOICE_HOLDER_CONTACTPERSON_OBJID()
     * @uses INVOICE_HOLDER::setINVOICE_HOLDER_OBJID()
     * @uses INVOICE_HOLDER::setINVOICE_HOLDER_CENTRALID()
     * @param string $name1
     * @param string $name2
     * @param string $iNVOICE_HOLDER_CONTACT_PERSON_OBJID
     * @param string $address
     * @param string $lastName
     * @param string $firstName
     * @param string $iNVOICE_HOLDER_CONTACTPERSON_OBJID
     * @param string $iNVOICE_HOLDER_OBJID
     * @param string $iNVOICE_HOLDER_CENTRALID
     */
    public function __construct($name1 = null, $name2 = null, $iNVOICE_HOLDER_CONTACT_PERSON_OBJID = null, $address = null, $lastName = null, $firstName = null, $iNVOICE_HOLDER_CONTACTPERSON_OBJID = null, $iNVOICE_HOLDER_OBJID = null, $iNVOICE_HOLDER_CENTRALID = null)
    {
        $this
            ->setName1($name1)
            ->setName2($name2)
            ->setINVOICE_HOLDER_CONTACT_PERSON_OBJID($iNVOICE_HOLDER_CONTACT_PERSON_OBJID)
            ->setAddress($address)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setINVOICE_HOLDER_CONTACTPERSON_OBJID($iNVOICE_HOLDER_CONTACTPERSON_OBJID)
            ->setINVOICE_HOLDER_OBJID($iNVOICE_HOLDER_OBJID)
            ->setINVOICE_HOLDER_CENTRALID($iNVOICE_HOLDER_CENTRALID);
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\INVOICE_HOLDER
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\INVOICE_HOLDER
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER_CONTACT_PERSON_OBJID value
     * @return string
     */
    public function getINVOICE_HOLDER_CONTACT_PERSON_OBJID()
    {
        return $this->{'INVOICE-HOLDER-CONTACT-PERSON-OBJID'};
    }
    /**
     * Set INVOICE_HOLDER_CONTACT_PERSON_OBJID value
     * @param string $iNVOICE_HOLDER_CONTACT_PERSON_OBJID
     * @return \StructType\INVOICE_HOLDER
     */
    public function setINVOICE_HOLDER_CONTACT_PERSON_OBJID($iNVOICE_HOLDER_CONTACT_PERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_HOLDER_CONTACT_PERSON_OBJID) && !is_string($iNVOICE_HOLDER_CONTACT_PERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_HOLDER_CONTACT_PERSON_OBJID, true), gettype($iNVOICE_HOLDER_CONTACT_PERSON_OBJID)), __LINE__);
        }
        $this->INVOICE_HOLDER_CONTACT_PERSON_OBJID = $this->{'INVOICE-HOLDER-CONTACT-PERSON-OBJID'} = $iNVOICE_HOLDER_CONTACT_PERSON_OBJID;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\INVOICE_HOLDER
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\INVOICE_HOLDER
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\INVOICE_HOLDER
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($firstName) && mb_strlen($firstName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($firstName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($firstName) && mb_strlen($firstName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER_CONTACTPERSON_OBJID value
     * @return string
     */
    public function getINVOICE_HOLDER_CONTACTPERSON_OBJID()
    {
        return $this->{'INVOICE-HOLDER-CONTACTPERSON-OBJID'};
    }
    /**
     * Set INVOICE_HOLDER_CONTACTPERSON_OBJID value
     * @param string $iNVOICE_HOLDER_CONTACTPERSON_OBJID
     * @return \StructType\INVOICE_HOLDER
     */
    public function setINVOICE_HOLDER_CONTACTPERSON_OBJID($iNVOICE_HOLDER_CONTACTPERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_HOLDER_CONTACTPERSON_OBJID) && !is_string($iNVOICE_HOLDER_CONTACTPERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_HOLDER_CONTACTPERSON_OBJID, true), gettype($iNVOICE_HOLDER_CONTACTPERSON_OBJID)), __LINE__);
        }
        $this->INVOICE_HOLDER_CONTACTPERSON_OBJID = $this->{'INVOICE-HOLDER-CONTACTPERSON-OBJID'} = $iNVOICE_HOLDER_CONTACTPERSON_OBJID;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER_OBJID value
     * @return string|null
     */
    public function getINVOICE_HOLDER_OBJID()
    {
        return $this->{'INVOICE-HOLDER-OBJID'};
    }
    /**
     * Set INVOICE_HOLDER_OBJID value
     * @param string $iNVOICE_HOLDER_OBJID
     * @return \StructType\INVOICE_HOLDER
     */
    public function setINVOICE_HOLDER_OBJID($iNVOICE_HOLDER_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_HOLDER_OBJID) && !is_string($iNVOICE_HOLDER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_HOLDER_OBJID, true), gettype($iNVOICE_HOLDER_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iNVOICE_HOLDER_OBJID) && !preg_match('/([0-9])*/', $iNVOICE_HOLDER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iNVOICE_HOLDER_OBJID, true)), __LINE__);
        }
        $this->INVOICE_HOLDER_OBJID = $this->{'INVOICE-HOLDER-OBJID'} = $iNVOICE_HOLDER_OBJID;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER_CENTRALID value
     * @return string|null
     */
    public function getINVOICE_HOLDER_CENTRALID()
    {
        return $this->{'INVOICE-HOLDER-CENTRALID'};
    }
    /**
     * Set INVOICE_HOLDER_CENTRALID value
     * @param string $iNVOICE_HOLDER_CENTRALID
     * @return \StructType\INVOICE_HOLDER
     */
    public function setINVOICE_HOLDER_CENTRALID($iNVOICE_HOLDER_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_HOLDER_CENTRALID) && !is_string($iNVOICE_HOLDER_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_HOLDER_CENTRALID, true), gettype($iNVOICE_HOLDER_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iNVOICE_HOLDER_CENTRALID) && !preg_match('/([0-9])*/', $iNVOICE_HOLDER_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iNVOICE_HOLDER_CENTRALID, true)), __LINE__);
        }
        $this->INVOICE_HOLDER_CENTRALID = $this->{'INVOICE-HOLDER-CENTRALID'} = $iNVOICE_HOLDER_CENTRALID;
        return $this;
    }
}
