<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INTERNET StructType
 * @subpackage Structs
 */
class INTERNET extends AbstractStructBase
{
    /**
     * The centralcategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $centralcategory;
    /**
     * The externalsystem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalsystem;
    /**
     * The percentage
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $percentage;
    /**
     * The master
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $master;
    /**
     * Constructor method for INTERNET
     * @uses INTERNET::setCentralcategory()
     * @uses INTERNET::setExternalsystem()
     * @uses INTERNET::setPercentage()
     * @uses INTERNET::setMaster()
     * @param string $centralcategory
     * @param string $externalsystem
     * @param string $percentage
     * @param string $master
     */
    public function __construct($centralcategory = null, $externalsystem = null, $percentage = null, $master = null)
    {
        $this
            ->setCentralcategory($centralcategory)
            ->setExternalsystem($externalsystem)
            ->setPercentage($percentage)
            ->setMaster($master);
    }
    /**
     * Get centralcategory value
     * @return string|null
     */
    public function getCentralcategory()
    {
        return $this->centralcategory;
    }
    /**
     * Set centralcategory value
     * @param string $centralcategory
     * @return \StructType\INTERNET
     */
    public function setCentralcategory($centralcategory = null)
    {
        // validation for constraint: string
        if (!is_null($centralcategory) && !is_string($centralcategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralcategory, true), gettype($centralcategory)), __LINE__);
        }
        $this->centralcategory = $centralcategory;
        return $this;
    }
    /**
     * Get externalsystem value
     * @return string|null
     */
    public function getExternalsystem()
    {
        return $this->externalsystem;
    }
    /**
     * Set externalsystem value
     * @param string $externalsystem
     * @return \StructType\INTERNET
     */
    public function setExternalsystem($externalsystem = null)
    {
        // validation for constraint: string
        if (!is_null($externalsystem) && !is_string($externalsystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalsystem, true), gettype($externalsystem)), __LINE__);
        }
        $this->externalsystem = $externalsystem;
        return $this;
    }
    /**
     * Get percentage value
     * @return string|null
     */
    public function getPercentage()
    {
        return $this->percentage;
    }
    /**
     * Set percentage value
     * @param string $percentage
     * @return \StructType\INTERNET
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: string
        if (!is_null($percentage) && !is_string($percentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($percentage) && !preg_match('/([-+]){0,1}([0-9])*/', $percentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($percentage, true)), __LINE__);
        }
        $this->percentage = $percentage;
        return $this;
    }
    /**
     * Get master value
     * @return string|null
     */
    public function getMaster()
    {
        return $this->master;
    }
    /**
     * Set master value
     * @param string $master
     * @return \StructType\INTERNET
     */
    public function setMaster($master = null)
    {
        // validation for constraint: string
        if (!is_null($master) && !is_string($master)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($master, true), gettype($master)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($master) && !preg_match('/([-+]){0,1}([0-9])*/', $master)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($master, true)), __LINE__);
        }
        $this->master = $master;
        return $this;
    }
}
